/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;

public class FSStatsPublisher
implements StatsPublisher,
StatsCollectionTaskIndependent {
    private Configuration conf;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private Map<String, Map<String, String>> statsMap;

    @Override
    public boolean init(StatsCollectionContext context) {
        try {
            for (String tmpDir : context.getStatsTmpDirs()) {
                Path statsDir = new Path(tmpDir);
                this.LOG.debug((Object)("Initing FSStatsPublisher with : " + statsDir));
                statsDir.getFileSystem(context.getHiveConf()).mkdirs(statsDir);
                this.LOG.info((Object)("created : " + statsDir));
            }
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean connect(StatsCollectionContext context) {
        this.conf = context.getHiveConf();
        List<String> statsDirs = context.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        this.LOG.debug((Object)("Connecting to : " + statsDir));
        this.statsMap = new HashMap<String, Map<String, String>>();
        try {
            return statsDir.getFileSystem(this.conf).exists(statsDir);
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean publishStat(String partKV, Map<String, String> stats) {
        this.LOG.debug((Object)("Putting in map : " + partKV + "\t" + stats));
        HashMap<String, String> cpy = new HashMap<String, String>(stats);
        Map<String, String> statMap = this.statsMap.get(partKV);
        if (null != statMap) {
            for (Map.Entry<String, String> e : statMap.entrySet()) {
                cpy.put(e.getKey(), String.valueOf(Long.valueOf(e.getValue()) + Long.valueOf((String)cpy.get(e.getKey()))));
            }
        }
        this.statsMap.put(partKV, cpy);
        return true;
    }

    @Override
    public boolean closeConnection(StatsCollectionContext context) {
        List<String> statsDirs = context.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        try {
            Path statsFile = null;
            statsFile = context.getIndexForTezUnion() != -1 ? new Path(statsDir, "tmpstats-" + this.conf.getInt("mapred.task.partition", 0) + "_" + context.getIndexForTezUnion()) : new Path(statsDir, "tmpstats-" + this.conf.getInt("mapred.task.partition", 0));
            this.LOG.debug((Object)("About to create stats file for this task : " + statsFile));
            Output output = new Output((OutputStream)statsFile.getFileSystem(this.conf).create(statsFile, true));
            this.LOG.debug((Object)("Created file : " + statsFile));
            this.LOG.debug((Object)("Writing stats in it : " + this.statsMap));
            Utilities.runtimeSerializationKryo.get().writeObject(output, this.statsMap);
            output.close();
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            return false;
        }
    }
}

