/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.session.SessionState;

public class DependencyResolver {
    private static final String HIVE_HOME = "HIVE_HOME";
    private static final String HIVE_CONF_DIR = "HIVE_CONF_DIR";
    private String ivysettingsPath;
    private static SessionState.LogHelper _console = new SessionState.LogHelper(LogFactory.getLog((String)"DependencyResolver"));

    public DependencyResolver() {
        URL ivysetttingsResource;
        if (System.getenv().containsKey(HIVE_CONF_DIR)) {
            this.ivysettingsPath = System.getenv().get(HIVE_CONF_DIR) + "/ivysettings.xml";
        }
        if ((this.ivysettingsPath == null || !new File(this.ivysettingsPath).exists()) && System.getenv().containsKey(HIVE_HOME)) {
            this.ivysettingsPath = System.getenv().get(HIVE_HOME) + "/conf/ivysettings.xml";
        }
        if (!(this.ivysettingsPath != null && new File(this.ivysettingsPath).exists() || (ivysetttingsResource = ClassLoader.getSystemResource("ivysettings.xml")) == null)) {
            this.ivysettingsPath = ivysetttingsResource.getFile();
            _console.printInfo("ivysettings.xml file not found in HIVE_HOME or HIVE_CONF_DIR," + this.ivysettingsPath + " will be used");
        }
    }

    public List<URI> downloadDependencies(URI uri) throws URISyntaxException, IOException {
        HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new URISyntaxException(authority, "Invalid url: Expected 'org:module:version', found null");
        }
        String[] authorityTokens = authority.toLowerCase().split(":");
        if (authorityTokens.length != 3) {
            throw new URISyntaxException(authority, "Invalid url: Expected 'org:module:version', found " + authority);
        }
        dependencyMap.put("org", authorityTokens[0]);
        dependencyMap.put("module", authorityTokens[1]);
        dependencyMap.put("version", authorityTokens[2]);
        Map<String, Object> queryMap = this.parseQueryString(uri.getQuery());
        if (queryMap != null) {
            dependencyMap.putAll(queryMap);
        }
        return this.grab(dependencyMap);
    }

    private Map<String, Object> parseQueryString(String queryString) throws URISyntaxException {
        String[] mapTokens;
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        LinkedList<Map<String, String>> excludeList = new LinkedList<Map<String, String>>();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        for (String tokens : mapTokens = queryString.split("&")) {
            String[] mapPair = tokens.split("=");
            if (mapPair.length != 2) {
                throw new RuntimeException("Invalid query string: " + queryString);
            }
            if (mapPair[0].equals("exclude")) {
                excludeList.addAll(this.computeExcludeList(mapPair[1]));
                continue;
            }
            if (mapPair[0].equals("transitive")) {
                if (mapPair[1].toLowerCase().equals("true")) {
                    queryMap.put(mapPair[0], true);
                    continue;
                }
                queryMap.put(mapPair[0], false);
                continue;
            }
            queryMap.put(mapPair[0], mapPair[1]);
        }
        if (!excludeList.isEmpty()) {
            queryMap.put("exclude", excludeList);
        }
        return queryMap;
    }

    private List<Map<String, String>> computeExcludeList(String excludeString) throws URISyntaxException {
        String[] excludes = excludeString.split(",");
        LinkedList<Map<String, String>> excludeList = new LinkedList<Map<String, String>>();
        for (String exclude : excludes) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            String[] args = exclude.split(":");
            if (args.length != 2) {
                throw new URISyntaxException(excludeString, "Invalid exclude string: expected 'org:module,org:module,..', found " + excludeString);
            }
            tempMap.put("group", args[0]);
            tempMap.put("module", args[1]);
            excludeList.add(tempMap);
        }
        return excludeList;
    }

    private List<URI> grab(Map<String, Object> dependencies) throws IOException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (dependencies.containsKey("exclude")) {
            args.put("excludes", dependencies.get("exclude"));
        }
        if (!dependencies.containsKey("transitive")) {
            dependencies.put("transitive", true);
        }
        args.put("classLoader", new GroovyClassLoader());
        System.setProperty("grape.config", this.ivysettingsPath);
        System.setProperty("groovy.grape.report.downloads", "true");
        URI[] localUrls = Grape.resolve(args, (Map[])new Map[]{dependencies});
        if (localUrls == null) {
            throw new IOException("Not able to download all the dependencies..");
        }
        return Arrays.asList(localUrls);
    }
}

