/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.OrcTail;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public final class OrcFile {
    public static final String MAGIC = "ORC";
    @Deprecated
    public static final String COMPRESSION = "orc.compress";
    @Deprecated
    public static final String COMPRESSION_BLOCK_SIZE = "orc.compress.size";
    @Deprecated
    public static final String STRIPE_SIZE = "orc.stripe.size";
    @Deprecated
    public static final String ROW_INDEX_STRIDE = "orc.row.index.stride";
    @Deprecated
    public static final String ENABLE_INDEXES = "orc.create.index";
    @Deprecated
    public static final String BLOCK_PADDING = "orc.block.padding";
    private static MemoryManager memoryManager = null;

    private OrcFile() {
    }

    public static Reader createReader(FileSystem fs, Path path) throws IOException {
        ReaderOptions opts = new ReaderOptions(new Configuration());
        opts.filesystem(fs);
        return new ReaderImpl(path, opts);
    }

    public static ReaderOptions readerOptions(Configuration conf) {
        return new ReaderOptions(conf);
    }

    public static Reader createReader(Path path, ReaderOptions options) throws IOException {
        return new ReaderImpl(path, options);
    }

    public static WriterOptions writerOptions(Configuration conf) {
        return new WriterOptions(null, conf);
    }

    public static WriterOptions writerOptions(Properties tableProperties, Configuration conf) {
        return new WriterOptions(tableProperties, conf);
    }

    public static Writer createWriter(Path path, WriterOptions opts) throws IOException {
        FileSystem fs = opts.fileSystemValue == null ? path.getFileSystem(opts.configuration) : opts.fileSystemValue;
        return new WriterImpl(fs, path, opts.configuration, opts.inspectorValue, opts.stripeSizeValue, opts.compressValue, opts.bufferSizeValue, opts.rowIndexStrideValue, opts.memoryManagerValue, opts.blockPaddingValue, opts.versionValue, opts.callback, opts.encodingStrategy, opts.compressionStrategy, opts.paddingTolerance, opts.blockSizeValue, opts.bloomFilterColumns, opts.bloomFilterFpp, opts.enforceBufferSize);
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride) throws IOException {
        return OrcFile.createWriter(path, OrcFile.writerOptions(conf).fileSystem(fs).inspector(inspector).stripeSize(stripeSize).compress(compress).bufferSize(bufferSize).rowIndexStride(rowIndexStride));
    }

    private static synchronized MemoryManager getMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManager(conf);
        }
        return memoryManager;
    }

    public static class WriterOptions {
        private final Configuration configuration;
        private FileSystem fileSystemValue = null;
        private ObjectInspector inspectorValue = null;
        private long stripeSizeValue;
        private long blockSizeValue;
        private int rowIndexStrideValue;
        private int bufferSizeValue;
        private boolean blockPaddingValue;
        private CompressionKind compressValue;
        private MemoryManager memoryManagerValue;
        private Version versionValue;
        private WriterCallback callback;
        private EncodingStrategy encodingStrategy;
        private CompressionStrategy compressionStrategy;
        private float paddingTolerance;
        private String bloomFilterColumns;
        private double bloomFilterFpp;
        private boolean enforceBufferSize = false;

        WriterOptions(Properties tableProperties, Configuration conf) {
            this.configuration = conf;
            this.memoryManagerValue = OrcFile.getMemoryManager(conf);
            String propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.STRIPE_SIZE.propName);
            this.stripeSizeValue = propValue == null ? HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVE_ORC_DEFAULT_STRIPE_SIZE) : Long.parseLong(propValue);
            propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.BLOCK_SIZE.propName);
            this.blockSizeValue = propValue == null ? HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_SIZE) : Long.parseLong(propValue);
            propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.ROW_INDEX_STRIDE.propName);
            this.rowIndexStrideValue = propValue == null ? HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_DEFAULT_ROW_INDEX_STRIDE) : Integer.parseInt(propValue);
            String string = propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.ENABLE_INDEXES.propName);
            if (propValue != null && !Boolean.parseBoolean(propValue)) {
                this.rowIndexStrideValue = 0;
            }
            propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.COMPRESSION_BLOCK_SIZE.propName);
            this.bufferSizeValue = propValue == null ? HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_DEFAULT_BUFFER_SIZE) : Integer.parseInt(propValue);
            propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.BLOCK_PADDING.propName);
            this.blockPaddingValue = propValue == null ? HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_PADDING) : Boolean.parseBoolean(propValue);
            propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.COMPRESSION.propName);
            this.compressValue = propValue == null ? CompressionKind.valueOf(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS)) : CompressionKind.valueOf(propValue);
            this.bloomFilterColumns = propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.BLOOM_FILTER_COLUMNS.propName);
            propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.BLOOM_FILTER_FPP.propName);
            this.bloomFilterFpp = propValue == null ? 0.05 : Double.parseDouble(propValue);
            String versionName = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_ORC_WRITE_FORMAT);
            this.versionValue = versionName == null ? Version.CURRENT : Version.byName(versionName);
            String string2 = propValue = tableProperties == null ? null : tableProperties.getProperty(OrcTableProperties.ENCODING_STRATEGY.propName);
            if (propValue == null) {
                propValue = conf.get(HiveConf.ConfVars.HIVE_ORC_ENCODING_STRATEGY.varname);
            }
            this.encodingStrategy = propValue == null ? EncodingStrategy.SPEED : EncodingStrategy.valueOf(propValue);
            String compString = conf.get(HiveConf.ConfVars.HIVE_ORC_COMPRESSION_STRATEGY.varname);
            this.compressionStrategy = compString == null ? CompressionStrategy.SPEED : CompressionStrategy.valueOf(compString);
            this.paddingTolerance = conf.getFloat(HiveConf.ConfVars.HIVE_ORC_BLOCK_PADDING_TOLERANCE.varname, HiveConf.ConfVars.HIVE_ORC_BLOCK_PADDING_TOLERANCE.defaultFloatVal);
        }

        public WriterOptions fileSystem(FileSystem value) {
            this.fileSystemValue = value;
            return this;
        }

        public WriterOptions stripeSize(long value) {
            this.stripeSizeValue = value;
            return this;
        }

        public WriterOptions blockSize(long value) {
            this.blockSizeValue = value;
            return this;
        }

        public WriterOptions rowIndexStride(int value) {
            this.rowIndexStrideValue = value;
            return this;
        }

        public WriterOptions bufferSize(int value) {
            this.bufferSizeValue = value;
            return this;
        }

        public WriterOptions enforceBufferSize() {
            this.enforceBufferSize = true;
            return this;
        }

        public WriterOptions blockPadding(boolean value) {
            this.blockPaddingValue = value;
            return this;
        }

        public WriterOptions encodingStrategy(EncodingStrategy strategy) {
            this.encodingStrategy = strategy;
            return this;
        }

        public WriterOptions paddingTolerance(float value) {
            this.paddingTolerance = value;
            return this;
        }

        public WriterOptions bloomFilterColumns(String columns) {
            this.bloomFilterColumns = columns;
            return this;
        }

        public WriterOptions bloomFilterFpp(double fpp) {
            this.bloomFilterFpp = fpp;
            return this;
        }

        public WriterOptions compress(CompressionKind value) {
            this.compressValue = value;
            return this;
        }

        public WriterOptions inspector(ObjectInspector value) {
            this.inspectorValue = value;
            return this;
        }

        public WriterOptions version(Version value) {
            this.versionValue = value;
            return this;
        }

        public WriterOptions callback(WriterCallback callback) {
            this.callback = callback;
            return this;
        }

        WriterOptions memory(MemoryManager value) {
            this.memoryManagerValue = value;
            return this;
        }

        public FileSystem getFileSystem() {
            return this.fileSystemValue;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public int getBufferSize() {
            return this.bufferSizeValue;
        }

        public long getStripeSize() {
            return this.stripeSizeValue;
        }
    }

    public static interface WriterCallback {
        public void preStripeWrite(WriterContext var1) throws IOException;

        public void preFooterWrite(WriterContext var1) throws IOException;
    }

    public static interface WriterContext {
        public Writer getWriter();
    }

    public static class ReaderOptions {
        private final Configuration conf;
        private FileSystem filesystem;
        private long maxLength = Long.MAX_VALUE;
        private OrcTail orcTail;

        public ReaderOptions(Configuration conf) {
            this.conf = conf;
        }

        ReaderOptions orcTail(OrcTail orcTail) {
            this.orcTail = orcTail;
            return this;
        }

        public ReaderOptions filesystem(FileSystem fs) {
            this.filesystem = fs;
            return this;
        }

        public ReaderOptions maxLength(long val) {
            this.maxLength = val;
            return this;
        }

        Configuration getConfiguration() {
            return this.conf;
        }

        FileSystem getFilesystem() {
            return this.filesystem;
        }

        OrcTail getOrcTail() {
            return this.orcTail;
        }

        long getMaxLength() {
            return this.maxLength;
        }
    }

    public static enum OrcTableProperties {
        COMPRESSION("orc.compress"),
        COMPRESSION_BLOCK_SIZE("orc.compress.size"),
        STRIPE_SIZE("orc.stripe.size"),
        BLOCK_SIZE("orc.block.size"),
        ROW_INDEX_STRIDE("orc.row.index.stride"),
        ENABLE_INDEXES("orc.create.index"),
        BLOCK_PADDING("orc.block.padding"),
        ENCODING_STRATEGY("orc.encoding.strategy"),
        BLOOM_FILTER_COLUMNS("orc.bloom.filter.columns"),
        BLOOM_FILTER_FPP("orc.bloom.filter.fpp");

        private final String propName;

        private OrcTableProperties(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }

    public static enum CompressionStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum EncodingStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum WriterVersion {
        ORIGINAL(0),
        HIVE_8732(1),
        HIVE_4243(2),
        HIVE_12055(3),
        HIVE_13083(4);

        private final int id;

        public int getId() {
            return this.id;
        }

        private WriterVersion(int id) {
            this.id = id;
        }
    }

    public static enum Version {
        V_0_11("0.11", 0, 11),
        V_0_12("0.12", 0, 12);

        public static final Version CURRENT;
        private final String name;
        private final int major;
        private final int minor;

        private Version(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }

        public static Version byName(String name) {
            for (Version version : Version.values()) {
                if (!version.name.equals(name)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown ORC version " + name);
        }

        public String getName() {
            return this.name;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        static {
            CURRENT = V_0_12;
        }
    }
}

