/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.session.SessionState;

public class GlobalWorkMapFactory {
    private ThreadLocal<Map<Path, BaseWork>> threadLocalWorkMap = null;
    private Map<Path, BaseWork> gWorkMap = null;

    public Map<Path, BaseWork> get(Configuration conf) {
        if (SessionState.get() != null && SessionState.get().isHiveServerQuery() || HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
            if (this.threadLocalWorkMap == null) {
                this.threadLocalWorkMap = new ThreadLocal<Map<Path, BaseWork>>(){

                    @Override
                    protected Map<Path, BaseWork> initialValue() {
                        return new HashMap<Path, BaseWork>();
                    }
                };
            }
            return this.threadLocalWorkMap.get();
        }
        if (this.gWorkMap == null) {
            this.gWorkMap = new HashMap<Path, BaseWork>();
        }
        return this.gWorkMap;
    }
}

