/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Attribute;
import weka.core.WekaException;
import weka.gui.CostBenefitAnalysisPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.gui.visualize.PlotData2D;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.CostBenefitAnalysis;

public class CostBenefitAnalysisInteractiveView
extends BaseInteractiveViewer {
    private static final long serialVersionUID = 4624182171551712860L;
    protected ResultHistoryPanel m_history;
    protected JButton m_clearButton = new JButton("Clear results");
    protected CostBenefitAnalysisPanel m_cbPanel = new CostBenefitAnalysisPanel();
    protected JSplitPane m_splitPane;

    @Override
    public String getViewerName() {
        return "Cost-benefit Analysis";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.m_history = new ResultHistoryPanel(null);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.setDeleteListener(new ResultHistoryPanel.RDeleteListener(){

            @Override
            public void entryDeleted(String name, int index) {
                ((CostBenefitAnalysis)CostBenefitAnalysisInteractiveView.this.getStep()).getDatasets().remove(index);
            }
        });
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -5174882230278923704L;

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                Object data;
                int index = CostBenefitAnalysisInteractiveView.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1 && (data = CostBenefitAnalysisInteractiveView.this.m_history.getNamedObject(name = CostBenefitAnalysisInteractiveView.this.m_history.getNameAtIndex(index))) instanceof Data) {
                    PlotData2D threshData = (PlotData2D)((Data)data).getPrimaryPayload();
                    Attribute classAtt = (Attribute)((Data)data).getPayloadElement("class_attribute");
                    try {
                        CostBenefitAnalysisInteractiveView.this.m_cbPanel.setDataSet(threshData, classAtt);
                        CostBenefitAnalysisInteractiveView.this.m_cbPanel.repaint();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        String name;
                        Object data;
                        if (!lm.isSelectedIndex(i)) continue;
                        if (i == -1 || (data = CostBenefitAnalysisInteractiveView.this.m_history.getNamedObject(name = CostBenefitAnalysisInteractiveView.this.m_history.getNameAtIndex(i))) == null || !(data instanceof Data)) break;
                        PlotData2D threshData = (PlotData2D)((Data)data).getPrimaryPayload();
                        Attribute classAtt = (Attribute)((Data)data).getPayloadElement("class_attribute");
                        try {
                            CostBenefitAnalysisInteractiveView.this.m_cbPanel.setDataSet(threshData, classAtt);
                            CostBenefitAnalysisInteractiveView.this.m_cbPanel.repaint();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
        this.m_splitPane = new JSplitPane(1, this.m_history, this.m_cbPanel);
        this.add((Component)this.m_splitPane, "Center");
        this.m_cbPanel.setPreferredSize(new Dimension(1000, 600));
        boolean first = true;
        for (Data d : ((CostBenefitAnalysis)this.getStep()).getDatasets()) {
            PlotData2D threshData = (PlotData2D)d.getPrimaryPayload();
            Attribute classAtt = (Attribute)d.getPayloadElement("class_attribute");
            String title = threshData.getPlotName();
            this.m_history.addResult(title, new StringBuffer());
            this.m_history.addObject(title, d);
            if (!first) continue;
            try {
                this.m_cbPanel.setDataSet(threshData, classAtt);
                this.m_cbPanel.repaint();
                first = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CostBenefitAnalysisInteractiveView.this.m_history.clearResults();
                ((CostBenefitAnalysis)CostBenefitAnalysisInteractiveView.this.getStep()).getDatasets().clear();
                CostBenefitAnalysisInteractiveView.this.m_splitPane.remove(CostBenefitAnalysisInteractiveView.this.m_cbPanel);
                CostBenefitAnalysisInteractiveView.this.m_splitPane.revalidate();
            }
        });
    }
}

