/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.EventSetDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ImageEvent;
import weka.gui.beans.ImageListener;
import weka.gui.beans.Visible;

public class ImageSaver
extends JPanel
implements ImageListener,
BeanCommon,
Visible,
Serializable,
EnvironmentHandler {
    private static final long serialVersionUID = -641438159956934314L;
    protected BeanVisual m_visual = new BeanVisual("AbstractDataSink", "weka/gui/beans/icons/SerializedModelSaver.gif", "weka/gui/beans/icons/SerializedModelSaver_animated.gif");
    protected Object m_listenee = null;
    protected transient Logger m_logger = null;
    protected transient Environment m_env;
    protected String m_fileName;

    public String globalInfo() {
        return "Save static images (such as those produced by ModelPerformanceChart) to a file.";
    }

    public ImageSaver() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
    }

    public void setFilename(String filename) {
        this.m_fileName = filename;
    }

    public String getFilename() {
        return this.m_fileName;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/SerializedModelSaver.gif", "weka/gui/beans/icons/SerializedModelSaver_animated.gif");
        this.m_visual.setText("ImageSaver");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return this.m_listenee == null;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (this.m_listenee == source) {
            this.m_listenee = null;
        }
    }

    @Override
    public void acceptImage(ImageEvent imageE) {
        block13: {
            BufferedImage image = imageE.getImage();
            if (this.m_fileName != null && this.m_fileName.length() > 0) {
                File file;
                if (this.m_env == null) {
                    this.m_env = Environment.getSystemWide();
                }
                String filename = this.m_fileName;
                try {
                    filename = this.m_env.substitute(this.m_fileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (filename.toLowerCase().indexOf(".png") < 0) {
                    filename = filename + ".png";
                }
                if (!(file = new File(filename)).isDirectory()) {
                    try {
                        ImageIO.write((RenderedImage)image, "png", file);
                    }
                    catch (IOException e) {
                        if (this.m_logger != null) {
                            this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: " + "an error occurred whilte trying to write image (see log)");
                            this.m_logger.logMessage("[" + this.getCustomName() + "] " + "an error occurred whilte trying to write image: " + e.getMessage());
                            break block13;
                        }
                        e.printStackTrace();
                    }
                } else {
                    String message = "Can't write image to file because supplied filename is a directory!";
                    if (this.m_logger != null) {
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: " + message);
                        this.m_logger.logMessage("[" + this.getCustomName() + "] " + message);
                    }
                }
            } else {
                String message = "Can't write image bacause no filename has been supplied! is a directory!";
                if (this.m_logger != null) {
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: " + message);
                    this.m_logger.logMessage("[" + this.getCustomName() + "] " + message);
                }
            }
        }
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

