/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.HashSet;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.SimpleBatchFilter;

public class RemoveDuplicates
extends SimpleBatchFilter {
    private static final long serialVersionUID = 4518686110979589602L;

    @Override
    public String globalInfo() {
        return "Removes all duplicate instances from the first batch of data it receives.";
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    @Override
    protected boolean hasImmediateOutputFormat() {
        return true;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            HashSet<DecisionTableHashKey> hs = new HashSet<DecisionTableHashKey>();
            Instances newInstances = new Instances(instances, instances.numInstances());
            for (Instance inst : instances) {
                DecisionTableHashKey key = new DecisionTableHashKey(inst, instances.numAttributes(), true);
                if (!hs.add(key)) continue;
                newInstances.add(inst);
            }
            newInstances.compactify();
            return newInstances;
        }
        throw new Exception("The process method should never be called for subsequent batches.");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10136 $");
    }

    public static void main(String[] args) {
        RemoveDuplicates.runFilter(new RemoveDuplicates(), args);
    }
}

