/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Remove
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 5011337331921522847L;
    protected Range m_SelectCols = new Range();
    protected int[] m_SelectedAttributes;

    public Remove() {
        this.m_SelectCols.setInvert(true);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSpecify list of columns to delete. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        newVector.addElement(new Option("\tInvert matching sense (i.e. only keep specified columns)", "V", 0, "-V"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String deleteList = Utils.getOption('R', options);
        if (deleteList.length() != 0) {
            this.setAttributeIndices(deleteList);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getInvertSelection()) {
            options.add("-V");
        }
        if (!this.getAttributeIndices().equals("")) {
            options.add("-R");
            options.add(this.getAttributeIndices());
        }
        return options.toArray(new String[0]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_SelectCols.setUpper(instanceInfo.numAttributes() - 1);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int outputClass = -1;
        for (int current : this.m_SelectedAttributes = this.m_SelectCols.getSelection()) {
            if (instanceInfo.classIndex() == current) {
                outputClass = attributes.size();
            }
            Attribute keep = (Attribute)instanceInfo.attribute(current).copy();
            attributes.add(keep);
        }
        this.initInputLocators(this.getInputFormat(), this.m_SelectedAttributes);
        Instances outputFormat = new Instances(instanceInfo.relationName(), attributes, 0);
        outputFormat.setClassIndex(outputClass);
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.getOutputFormat().numAttributes() == 0) {
            return false;
        }
        double[] vals = new double[this.getOutputFormat().numAttributes()];
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int current = this.m_SelectedAttributes[i];
            vals[i] = instance.value(current);
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        this.copyValues(inst, false, instance.dataset(), this.outputFormatPeek());
        this.push(inst);
        return true;
    }

    public String globalInfo() {
        return "A filter that removes a range of attributes from the dataset. Will re-order the remaining attributes if invert matching sense is turned on and the attribute column indices are not specified in ascending order.";
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or delete. If set to true, only the specified attributes will be kept; If set to false, specified attributes will be deleted.";
    }

    public boolean getInvertSelection() {
        return !this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_SelectCols.setInvert(!invert);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_SelectCols.getRanges();
    }

    public void setAttributeIndices(String rangeList) {
        this.m_SelectCols.setRanges(rangeList);
    }

    public void setAttributeIndicesArray(int[] attributes) {
        this.setAttributeIndices(Range.indicesToRangeList(attributes));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12041 $");
    }

    public static void main(String[] argv) {
        Remove.runFilter(new Remove(), argv);
    }
}

