/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.CommandlineRunnable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Queue;
import weka.core.RelationalLocator;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.StringLocator;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.ConverterUtils;
import weka.filters.Sourcable;

public abstract class Filter
implements Serializable,
CapabilitiesHandler,
RevisionHandler,
OptionHandler,
CapabilitiesIgnorer,
CommandlineRunnable {
    private static final long serialVersionUID = -8835063755891851218L;
    private Instances m_OutputFormat = null;
    private Queue m_OutputQueue = null;
    protected StringLocator m_OutputStringAtts = null;
    protected StringLocator m_InputStringAtts = null;
    protected RelationalLocator m_OutputRelAtts = null;
    protected RelationalLocator m_InputRelAtts = null;
    private Instances m_InputFormat = null;
    protected boolean m_NewBatch = true;
    protected boolean m_FirstBatchDone = false;
    protected boolean m_Debug = false;
    protected boolean m_DoNotCheckCapabilities = false;

    public boolean isNewBatch() {
        return this.m_NewBatch;
    }

    public boolean isFirstBatchDone() {
        return this.m_FirstBatchDone;
    }

    public boolean mayRemoveInstanceAfterFirstBatchDone() {
        return false;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12382 $");
    }

    public Capabilities getCapabilities(Instances data) {
        Capabilities result = this.getCapabilities();
        if (data.classIndex() == -1) {
            Capabilities classes = result.getClassCapabilities();
            Iterator<Capabilities.Capability> iter = classes.capabilities();
            while (iter.hasNext()) {
                Capabilities.Capability cap = iter.next();
                if (cap == Capabilities.Capability.NO_CLASS) continue;
                result.disable(cap);
                result.disableDependency(cap);
            }
        } else {
            result.disable(Capabilities.Capability.NO_CLASS);
            result.disableDependency(Capabilities.Capability.NO_CLASS);
        }
        return result;
    }

    protected void setOutputFormat(Instances outputFormat) {
        if (outputFormat != null) {
            this.m_OutputFormat = outputFormat.stringFreeStructure();
            this.initOutputLocators(this.m_OutputFormat, null);
            String relationName = outputFormat.relationName() + "-" + this.getClass().getName();
            if (this instanceof OptionHandler) {
                String[] options;
                for (String option : options = this.getOptions()) {
                    relationName = relationName + option.trim();
                }
            }
            this.m_OutputFormat.setRelationName(relationName);
        } else {
            this.m_OutputFormat = null;
        }
        this.m_OutputQueue = new Queue();
    }

    protected Instances getInputFormat() {
        return this.m_InputFormat;
    }

    protected Instances inputFormatPeek() {
        return this.m_InputFormat;
    }

    protected Instances outputFormatPeek() {
        return this.m_OutputFormat;
    }

    protected void push(Instance instance) {
        this.push(instance, true);
    }

    protected void push(Instance instance, boolean copyInstance) {
        if (instance != null) {
            if (instance.dataset() != null) {
                if (copyInstance) {
                    instance = (Instance)instance.copy();
                }
                this.copyValues(instance, false);
            }
            instance.setDataset(this.m_OutputFormat);
            this.m_OutputQueue.push(instance);
        }
    }

    protected void resetQueue() {
        this.m_OutputQueue = new Queue();
    }

    protected void bufferInput(Instance instance) {
        if (instance != null) {
            instance = (Instance)instance.copy();
            this.copyValues(instance, true);
            this.m_InputFormat.add(instance);
        }
    }

    protected void initInputLocators(Instances data, int[] indices) {
        if (indices == null) {
            this.m_InputStringAtts = new StringLocator(data);
            this.m_InputRelAtts = new RelationalLocator(data);
        } else {
            this.m_InputStringAtts = new StringLocator(data, indices);
            this.m_InputRelAtts = new RelationalLocator(data, indices);
        }
    }

    protected void initOutputLocators(Instances data, int[] indices) {
        if (indices == null) {
            this.m_OutputStringAtts = new StringLocator(data);
            this.m_OutputRelAtts = new RelationalLocator(data);
        } else {
            this.m_OutputStringAtts = new StringLocator(data, indices);
            this.m_OutputRelAtts = new RelationalLocator(data, indices);
        }
    }

    protected void copyValues(Instance instance, boolean isInput) {
        RelationalLocator.copyRelationalValues(instance, isInput ? this.m_InputFormat : this.m_OutputFormat, isInput ? this.m_InputRelAtts : this.m_OutputRelAtts);
        StringLocator.copyStringValues(instance, isInput ? this.m_InputFormat : this.m_OutputFormat, isInput ? this.m_InputStringAtts : this.m_OutputStringAtts);
    }

    protected void copyValues(Instance instance, boolean instSrcCompat, Instances srcDataset, Instances destDataset) {
        RelationalLocator.copyRelationalValues(instance, instSrcCompat, srcDataset, this.m_InputRelAtts, destDataset, this.m_OutputRelAtts);
        StringLocator.copyStringValues(instance, instSrcCompat, srcDataset, this.m_InputStringAtts, destDataset, this.m_OutputStringAtts);
    }

    protected void flushInput() {
        if (this.m_InputStringAtts.getAttributeIndices().length > 0 || this.m_InputRelAtts.getAttributeIndices().length > 0) {
            this.m_InputFormat = this.m_InputFormat.stringFreeStructure();
            this.m_InputStringAtts = new StringLocator(this.m_InputFormat, this.m_InputStringAtts.getAllowedIndices());
            this.m_InputRelAtts = new RelationalLocator(this.m_InputFormat, this.m_InputRelAtts.getAllowedIndices());
        } else {
            this.m_InputFormat.delete();
        }
    }

    protected void testInputFormat(Instances instanceInfo) throws Exception {
        this.getCapabilities(instanceInfo).testWithFail(instanceInfo);
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        this.testInputFormat(instanceInfo);
        this.m_InputFormat = instanceInfo.stringFreeStructure();
        this.m_OutputFormat = null;
        this.m_OutputQueue = new Queue();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = false;
        this.initInputLocators(this.m_InputFormat, null);
        return false;
    }

    public Instances getOutputFormat() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output format defined.");
        }
        return new Instances(this.m_OutputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.m_OutputQueue = new Queue();
            this.m_NewBatch = false;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException("No input instance format defined");
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        if (this.m_OutputQueue.empty() && (this.m_OutputStringAtts.getAttributeIndices().length > 0 || this.m_OutputRelAtts.getAttributeIndices().length > 0)) {
            this.m_OutputFormat = this.m_OutputFormat.stringFreeStructure();
            this.m_OutputStringAtts = new StringLocator(this.m_OutputFormat, this.m_OutputStringAtts.getAllowedIndices());
        }
        return this.numPendingOutput() != 0;
    }

    public Instance output() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance result = (Instance)this.m_OutputQueue.pop();
        return result;
    }

    public Instance outputPeek() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance result = (Instance)this.m_OutputQueue.peek();
        return result;
    }

    public int numPendingOutput() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        return this.m_OutputQueue.size();
    }

    public boolean isOutputFormatDefined() {
        return this.m_OutputFormat != null;
    }

    public static Filter makeCopy(Filter model) throws Exception {
        return (Filter)new SerializedObject(model).getObject();
    }

    public static Filter[] makeCopies(Filter model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model filter set");
        }
        Filter[] filters = new Filter[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = (Filter)so.getObject();
        }
        return filters;
    }

    public static Instances useFilter(Instances data, Filter filter) throws Exception {
        Instance processed;
        for (int i = 0; i < data.numInstances(); ++i) {
            filter.input(data.instance(i));
        }
        filter.batchFinished();
        Instances newData = filter.getOutputFormat();
        while ((processed = filter.output()) != null) {
            newData.add(processed);
        }
        return newData;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static String wekaStaticWrapper(Sourcable filter, String className, Instances input, Instances output) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("// Generated with Weka " + Version.VERSION + "\n");
        result.append("//\n");
        result.append("// This code is public domain and comes with no warranty.\n");
        result.append("//\n");
        result.append("// Timestamp: " + new Date() + "\n");
        result.append("// Relation: " + input.relationName() + "\n");
        result.append("\n");
        result.append("package weka.filters;\n");
        result.append("\n");
        result.append("import weka.core.Attribute;\n");
        result.append("import weka.core.Capabilities;\n");
        result.append("import weka.core.Capabilities.Capability;\n");
        result.append("import weka.core.DenseInstance;\n");
        result.append("import weka.core.Instance;\n");
        result.append("import weka.core.Instances;\n");
        result.append("import weka.core.Utils;\n");
        result.append("import weka.filters.Filter;\n");
        result.append("import java.util.ArrayList;\n");
        result.append("\n");
        result.append("public class WekaWrapper\n");
        result.append("  extends Filter {\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns only the toString() method.\n");
        result.append("   *\n");
        result.append("   * @return a string describing the filter\n");
        result.append("   */\n");
        result.append("  public String globalInfo() {\n");
        result.append("    return toString();\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns the capabilities of this filter.\n");
        result.append("   *\n");
        result.append("   * @return the capabilities\n");
        result.append("   */\n");
        result.append("  public Capabilities getCapabilities() {\n");
        result.append(((Filter)((Object)filter)).getCapabilities().toSource("result", 4));
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * turns array of Objects into an Instance object\n");
        result.append("   *\n");
        result.append("   * @param obj\tthe Object array to turn into an Instance\n");
        result.append("   * @param format\tthe data format to use\n");
        result.append("   * @return\t\tthe generated Instance object\n");
        result.append("   */\n");
        result.append("  protected Instance objectsToInstance(Object[] obj, Instances format) {\n");
        result.append("    Instance\t\tresult;\n");
        result.append("    double[]\t\tvalues;\n");
        result.append("    int\t\ti;\n");
        result.append("\n");
        result.append("    values = new double[obj.length];\n");
        result.append("\n");
        result.append("    for (i = 0 ; i < obj.length; i++) {\n");
        result.append("      if (obj[i] == null)\n");
        result.append("        values[i] = Utils.missingValue();\n");
        result.append("      else if (format.attribute(i).isNumeric())\n");
        result.append("        values[i] = (Double) obj[i];\n");
        result.append("      else if (format.attribute(i).isNominal())\n");
        result.append("        values[i] = format.attribute(i).indexOfValue((String) obj[i]);\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    // create new instance\n");
        result.append("    result = new DenseInstance(1.0, values);\n");
        result.append("    result.setDataset(format);\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * turns the Instance object into an array of Objects\n");
        result.append("   *\n");
        result.append("   * @param inst\tthe instance to turn into an array\n");
        result.append("   * @return\t\tthe Object array representing the instance\n");
        result.append("   */\n");
        result.append("  protected Object[] instanceToObjects(Instance inst) {\n");
        result.append("    Object[]\tresult;\n");
        result.append("    int\t\ti;\n");
        result.append("\n");
        result.append("    result = new Object[inst.numAttributes()];\n");
        result.append("\n");
        result.append("    for (i = 0 ; i < inst.numAttributes(); i++) {\n");
        result.append("      if (inst.isMissing(i))\n");
        result.append("  \tresult[i] = null;\n");
        result.append("      else if (inst.attribute(i).isNumeric())\n");
        result.append("  \tresult[i] = inst.value(i);\n");
        result.append("      else\n");
        result.append("  \tresult[i] = inst.stringValue(i);\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * turns the Instances object into an array of Objects\n");
        result.append("   *\n");
        result.append("   * @param data\tthe instances to turn into an array\n");
        result.append("   * @return\t\tthe Object array representing the instances\n");
        result.append("   */\n");
        result.append("  protected Object[][] instancesToObjects(Instances data) {\n");
        result.append("    Object[][]\tresult;\n");
        result.append("    int\t\ti;\n");
        result.append("\n");
        result.append("    result = new Object[data.numInstances()][];\n");
        result.append("\n");
        result.append("    for (i = 0; i < data.numInstances(); i++)\n");
        result.append("      result[i] = instanceToObjects(data.instance(i));\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Only tests the input data.\n");
        result.append("   *\n");
        result.append("   * @param instanceInfo the format of the data to convert\n");
        result.append("   * @return always true, to indicate that the output format can \n");
        result.append("   *         be collected immediately.\n");
        result.append("   */\n");
        result.append("  public boolean setInputFormat(Instances instanceInfo) throws Exception {\n");
        result.append("    super.setInputFormat(instanceInfo);\n");
        result.append("    \n");
        result.append("    // generate output format\n");
        result.append("    ArrayList<Attribute> atts = new ArrayList<Attribute>();\n");
        result.append("    ArrayList<String> attValues;\n");
        for (int i = 0; i < output.numAttributes(); ++i) {
            result.append("    // " + output.attribute(i).name() + "\n");
            if (output.attribute(i).isNumeric()) {
                result.append("    atts.add(new Attribute(\"" + output.attribute(i).name() + "\"));\n");
                continue;
            }
            if (output.attribute(i).isNominal()) {
                result.append("    attValues = new ArrayList<String>();\n");
                for (int n = 0; n < output.attribute(i).numValues(); ++n) {
                    result.append("    attValues.add(\"" + output.attribute(i).value(n) + "\");\n");
                }
                result.append("    atts.add(new Attribute(\"" + output.attribute(i).name() + "\", attValues));\n");
                continue;
            }
            throw new UnsupportedAttributeTypeException("Attribute type '" + output.attribute(i).type() + "' (position " + (i + 1) + ") is not supported!");
        }
        result.append("    \n");
        result.append("    Instances format = new Instances(\"" + output.relationName() + "\", atts, 0);\n");
        result.append("    format.setClassIndex(" + output.classIndex() + ");\n");
        result.append("    setOutputFormat(format);\n");
        result.append("    \n");
        result.append("    return true;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Directly filters the instance.\n");
        result.append("   *\n");
        result.append("   * @param instance the instance to convert\n");
        result.append("   * @return always true, to indicate that the output can \n");
        result.append("   *         be collected immediately.\n");
        result.append("   */\n");
        result.append("  public boolean input(Instance instance) throws Exception {\n");
        result.append("    Object[] filtered = " + className + ".filter(instanceToObjects(instance));\n");
        result.append("    push(objectsToInstance(filtered, getOutputFormat()));\n");
        result.append("    return true;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Performs a batch filtering of the buffered data, if any available.\n");
        result.append("   *\n");
        result.append("   * @return true if instances were filtered otherwise false\n");
        result.append("   */\n");
        result.append("  public boolean batchFinished() throws Exception {\n");
        result.append("    if (getInputFormat() == null)\n");
        result.append("      throw new NullPointerException(\"No input instance format defined\");;\n");
        result.append("\n");
        result.append("    Instances inst = getInputFormat();\n");
        result.append("    if (inst.numInstances() > 0) {\n");
        result.append("      Object[][] filtered = " + className + ".filter(instancesToObjects(inst));\n");
        result.append("      for (int i = 0; i < filtered.length; i++) {\n");
        result.append("        push(objectsToInstance(filtered[i], getOutputFormat()));\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    flushInput();\n");
        result.append("    m_NewBatch = true;\n");
        result.append("    m_FirstBatchDone = true;\n");
        result.append("\n");
        result.append("    return (inst.numInstances() > 0);\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns only the classnames and what filter it is based on.\n");
        result.append("   *\n");
        result.append("   * @return a short description\n");
        result.append("   */\n");
        result.append("  public String toString() {\n");
        result.append("    return \"Auto-generated filter wrapper, based on " + filter.getClass().getName() + " (generated with Weka " + Version.VERSION + ").\\n" + "\" + this.getClass().getName() + \"/" + className + "\";\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Runs the filter from commandline.\n");
        result.append("   *\n");
        result.append("   * @param args the commandline arguments\n");
        result.append("   */\n");
        result.append("  public static void main(String args[]) {\n");
        result.append("    runFilter(new WekaWrapper(), args);\n");
        result.append("  }\n");
        result.append("}\n");
        result.append("\n");
        result.append(filter.toSource(className, input));
        return result.toString();
    }

    public static void filterFile(Filter filter, String[] options) throws Exception {
        boolean debug = false;
        Instances data = null;
        ConverterUtils.DataSource input = null;
        PrintWriter output = null;
        String sourceCode = "";
        int maxDecimalPlaces = 6;
        try {
            String tmpStr;
            boolean helpRequest = Utils.getFlag('h', options);
            if (Utils.getFlag('d', options)) {
                debug = true;
            }
            String infileName = Utils.getOption('i', options);
            String outfileName = Utils.getOption('o', options);
            String classIndex = Utils.getOption('c', options);
            if (filter instanceof Sourcable) {
                sourceCode = Utils.getOption('z', options);
            }
            if ((tmpStr = Utils.getOption("decimal", options)).length() > 0) {
                maxDecimalPlaces = Integer.parseInt(tmpStr);
            }
            if (filter instanceof OptionHandler) {
                filter.setOptions(options);
            }
            Utils.checkForRemainingOptions(options);
            if (helpRequest) {
                throw new Exception("Help requested.\n");
            }
            input = infileName.length() != 0 ? new ConverterUtils.DataSource(infileName) : new ConverterUtils.DataSource(System.in);
            output = outfileName.length() != 0 ? new PrintWriter(new FileOutputStream(outfileName)) : new PrintWriter(System.out);
            data = input.getStructure();
            if (classIndex.length() != 0) {
                if (classIndex.equals("first")) {
                    data.setClassIndex(0);
                } else if (classIndex.equals("last")) {
                    data.setClassIndex(data.numAttributes() - 1);
                } else {
                    data.setClassIndex(Integer.parseInt(classIndex) - 1);
                }
            }
        }
        catch (Exception ex) {
            String filterOptions = "";
            if (filter instanceof OptionHandler) {
                filterOptions = filterOptions + "\nFilter options:\n\n";
                Enumeration<Option> enu = filter.listOptions();
                while (enu.hasMoreElements()) {
                    Option option = enu.nextElement();
                    filterOptions = filterOptions + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            String genericOptions = "\nGeneral options:\n\n-h\n\tGet help on available options.\n\t(use -b -h for help on batch mode.)\n-i <file>\n\tThe name of the file containing input instances.\n\tIf not supplied then instances will be read from stdin.\n-o <file>\n\tThe name of the file output instances will be written to.\n\tIf not supplied then instances will be written to stdout.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n-decimal <integer>\n\tThe maximum number of digits to print after the decimal\n\tplace for numeric values (default: 6)\n";
            if (filter instanceof Sourcable) {
                genericOptions = genericOptions + "-z <class name>\n\tOutputs the source code representing the trained filter.\n";
            }
            throw new Exception('\n' + ex.getMessage() + filterOptions + genericOptions);
        }
        if (debug) {
            System.err.println("Setting input format");
        }
        boolean printedHeader = false;
        if (filter.setInputFormat(data)) {
            if (debug) {
                System.err.println("Getting output format");
            }
            output.println(filter.getOutputFormat().toString());
            printedHeader = true;
        }
        while (input.hasMoreElements(data)) {
            Instance inst = input.nextElement(data);
            if (debug) {
                System.err.println("Input instance to filter");
            }
            if (!filter.input(inst)) continue;
            if (debug) {
                System.err.println("Filter said collect immediately");
            }
            if (!printedHeader) {
                throw new Error("Filter didn't return true from setInputFormat() earlier!");
            }
            if (debug) {
                System.err.println("Getting output instance");
            }
            output.println(filter.output().toStringMaxDecimalDigits(maxDecimalPlaces));
        }
        if (debug) {
            System.err.println("Setting end of batch");
        }
        if (filter.batchFinished()) {
            if (debug) {
                System.err.println("Filter said collect output");
            }
            if (!printedHeader) {
                if (debug) {
                    System.err.println("Getting output format");
                }
                output.println(filter.getOutputFormat().toString());
            }
            if (debug) {
                System.err.println("Getting output instance");
            }
            while (filter.numPendingOutput() > 0) {
                output.println(filter.output().toStringMaxDecimalDigits(maxDecimalPlaces));
                if (!debug) continue;
                System.err.println("Getting output instance");
            }
        }
        if (debug) {
            System.err.println("Done");
        }
        if (output != null) {
            output.close();
        }
        if (sourceCode.length() != 0) {
            System.out.println(Filter.wekaStaticWrapper((Sourcable)((Object)filter), sourceCode, data, filter.getOutputFormat()));
        }
    }

    public static void batchFilterFile(Filter filter, String[] options) throws Exception {
        Instance inst;
        Instances firstData = null;
        Instances secondData = null;
        ConverterUtils.DataSource firstInput = null;
        ConverterUtils.DataSource secondInput = null;
        PrintWriter firstOutput = null;
        PrintWriter secondOutput = null;
        String sourceCode = "";
        int maxDecimalPlaces = 6;
        try {
            String tmpStr;
            boolean helpRequest = Utils.getFlag('h', options);
            String fileName = Utils.getOption('i', options);
            if (fileName.length() == 0) {
                throw new Exception("No first input file given.\n");
            }
            firstInput = new ConverterUtils.DataSource(fileName);
            fileName = Utils.getOption('r', options);
            if (fileName.length() == 0) {
                throw new Exception("No second input file given.\n");
            }
            secondInput = new ConverterUtils.DataSource(fileName);
            fileName = Utils.getOption('o', options);
            firstOutput = fileName.length() != 0 ? new PrintWriter(new FileOutputStream(fileName)) : new PrintWriter(System.out);
            fileName = Utils.getOption('s', options);
            secondOutput = fileName.length() != 0 ? new PrintWriter(new FileOutputStream(fileName)) : new PrintWriter(System.out);
            String classIndex = Utils.getOption('c', options);
            if (filter instanceof Sourcable) {
                sourceCode = Utils.getOption('z', options);
            }
            if ((tmpStr = Utils.getOption("decimal", options)).length() > 0) {
                maxDecimalPlaces = Integer.parseInt(tmpStr);
            }
            if (filter instanceof OptionHandler) {
                filter.setOptions(options);
            }
            Utils.checkForRemainingOptions(options);
            if (helpRequest) {
                throw new Exception("Help requested.\n");
            }
            firstData = firstInput.getStructure();
            secondData = secondInput.getStructure();
            if (!secondData.equalHeaders(firstData)) {
                throw new Exception("Input file formats differ.\n" + secondData.equalHeadersMsg(firstData) + "\n");
            }
            if (classIndex.length() != 0) {
                if (classIndex.equals("first")) {
                    firstData.setClassIndex(0);
                    secondData.setClassIndex(0);
                } else if (classIndex.equals("last")) {
                    firstData.setClassIndex(firstData.numAttributes() - 1);
                    secondData.setClassIndex(secondData.numAttributes() - 1);
                } else {
                    firstData.setClassIndex(Integer.parseInt(classIndex) - 1);
                    secondData.setClassIndex(Integer.parseInt(classIndex) - 1);
                }
            }
        }
        catch (Exception ex) {
            String filterOptions = "";
            if (filter instanceof OptionHandler) {
                filterOptions = filterOptions + "\nFilter options:\n\n";
                Enumeration<Option> enu = filter.listOptions();
                while (enu.hasMoreElements()) {
                    Option option = enu.nextElement();
                    filterOptions = filterOptions + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            String genericOptions = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-i <filename>\n\tThe file containing first input instances.\n-o <filename>\n\tThe file first output instances will be written to.\n-r <filename>\n\tThe file containing second input instances.\n-s <filename>\n\tThe file second output instances will be written to.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n-decimal <integer>\n\tThe maximum number of digits to print after the decimal\n\tplace for numeric values (default: 6)\n";
            if (filter instanceof Sourcable) {
                genericOptions = genericOptions + "-z <class name>\n\tOutputs the source code representing the trained filter.\n";
            }
            throw new Exception('\n' + ex.getMessage() + filterOptions + genericOptions);
        }
        boolean printedHeader = false;
        if (filter.setInputFormat(firstData)) {
            firstOutput.println(filter.getOutputFormat().toString());
            printedHeader = true;
        }
        while (firstInput.hasMoreElements(firstData)) {
            inst = firstInput.nextElement(firstData);
            if (!filter.input(inst)) continue;
            if (!printedHeader) {
                throw new Error("Filter didn't return true from setInputFormat() earlier!");
            }
            firstOutput.println(filter.output().toStringMaxDecimalDigits(maxDecimalPlaces));
        }
        if (filter.batchFinished()) {
            if (!printedHeader) {
                firstOutput.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                firstOutput.println(filter.output().toStringMaxDecimalDigits(maxDecimalPlaces));
            }
        }
        if (firstOutput != null) {
            firstOutput.close();
        }
        printedHeader = false;
        if (filter.isOutputFormatDefined()) {
            secondOutput.println(filter.getOutputFormat().toString());
            printedHeader = true;
        }
        while (secondInput.hasMoreElements(secondData)) {
            inst = secondInput.nextElement(secondData);
            if (!filter.input(inst)) continue;
            if (!printedHeader) {
                throw new Error("Filter didn't return true from isOutputFormatDefined() earlier!");
            }
            secondOutput.println(filter.output().toStringMaxDecimalDigits(maxDecimalPlaces));
        }
        if (filter.batchFinished()) {
            if (!printedHeader) {
                secondOutput.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                secondOutput.println(filter.output().toStringMaxDecimalDigits(maxDecimalPlaces));
            }
        }
        if (secondOutput != null) {
            secondOutput.close();
        }
        if (sourceCode.length() != 0) {
            System.out.println(Filter.wekaStaticWrapper((Sourcable)((Object)filter), sourceCode, firstData, filter.getOutputFormat()));
        }
    }

    public static void runFilter(Filter filter, String[] options) {
        try {
            filter.preExecution();
            if (Utils.getFlag('b', options)) {
                Filter.batchFilterFile(filter, options);
            } else {
                Filter.filterFile(filter, options);
            }
        }
        catch (Exception e) {
            if (e.toString().indexOf("Help requested") == -1 && e.toString().indexOf("Filter options") == -1) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
        try {
            filter.postExecution();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = Option.listOptionsForClassHierarchy(this.getClass(), Filter.class);
        newVector.addElement(new Option("\tIf set, filter is run in debug mode and\n\tmay output additional info to the console", "output-debug-info", 0, "-output-debug-info"));
        newVector.addElement(new Option("\tIf set, filter capabilities are not checked before filter is built\n\t(use with caution).", "-do-not-check-capabilities", 0, "-do-not-check-capabilities"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        Option.setOptionsForHierarchy(options, this, Filter.class);
        this.setDebug(Utils.getFlag("output-debug-info", options));
        this.setDoNotCheckCapabilities(Utils.getFlag("do-not-check-capabilities", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        for (String s : Option.getOptionsForHierarchy(this, Filter.class)) {
            options.add(s);
        }
        if (this.getDebug()) {
            options.add("-output-debug-info");
        }
        if (this.getDoNotCheckCapabilities()) {
            options.add("-do-not-check-capabilities");
        }
        return options.toArray(new String[0]);
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, filter may output additional info to the console.";
    }

    @Override
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    @Override
    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    public String doNotCheckCapabilitiesTipText() {
        return "If set, filters capabilities are not checked before filter is built (Use with caution to reduce runtime).";
    }

    @Override
    public void preExecution() throws Exception {
    }

    @Override
    public void run(Object toRun, String[] options) throws Exception {
        if (!(toRun instanceof Filter)) {
            throw new IllegalArgumentException("Object to run is not a Filter!");
        }
        Filter.runFilter((Filter)toRun, options);
    }

    @Override
    public void postExecution() throws Exception {
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("First argument must be the class name of a Filter");
            }
            String fname = args[0];
            Filter f = (Filter)Class.forName(fname).newInstance();
            args[0] = "";
            Filter.runFilter(f, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

