/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;

public class CheckSource
implements OptionHandler,
RevisionHandler {
    protected Filter m_Filter = null;
    protected Filter m_SourceCode = null;
    protected File m_Dataset = null;
    protected int m_ClassIndex = -1;

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe filter (incl. options) that was used to generate\n\tthe source code.", "W", 1, "-W <classname and options>"));
        result.addElement(new Option("\tThe classname of the generated source code.", "S", 1, "-S <classname>"));
        result.addElement(new Option("\tThe training set with which the source code was generated.", "t", 1, "-t <file>"));
        result.addElement(new Option("\tThe class index of the training set. 'first' and 'last' are\n\tvalid indices.\n\t(default: none)", "c", 1, "-c <index>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String[] spec;
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            spec = Utils.splitOptions(tmpStr);
            if (spec.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
        } else {
            throw new Exception("No filter (classname + options) provided!");
        }
        String classname = spec[0];
        spec[0] = "";
        this.setFilter((Filter)Utils.forName(Filter.class, classname, spec));
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() > 0) {
            spec = Utils.splitOptions(tmpStr);
            if (spec.length != 1) {
                throw new IllegalArgumentException("Invalid source code specification string");
            }
        } else {
            throw new Exception("No source code (classname) provided!");
        }
        classname = spec[0];
        spec[0] = "";
        this.setSourceCode((Filter)Utils.forName(Filter.class, classname, spec));
        tmpStr = Utils.getOption('t', options);
        if (tmpStr.length() == 0) {
            throw new Exception("No dataset provided!");
        }
        this.setDataset(new File(tmpStr));
        tmpStr = Utils.getOption('c', options);
        if (tmpStr.length() != 0) {
            if (tmpStr.equals("first")) {
                this.setClassIndex(0);
            } else if (tmpStr.equals("last")) {
                this.setClassIndex(-2);
            } else {
                this.setClassIndex(Integer.parseInt(tmpStr) - 1);
            }
        } else {
            this.setClassIndex(-1);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getFilter() != null) {
            result.add("-W");
            result.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions(this.getFilter().getOptions()));
        }
        if (this.getSourceCode() != null) {
            result.add("-S");
            result.add(this.getSourceCode().getClass().getName());
        }
        if (this.getDataset() != null) {
            result.add("-t");
            result.add(this.m_Dataset.getAbsolutePath());
        }
        if (this.getClassIndex() != -1) {
            result.add("-c");
            if (this.getClassIndex() == -2) {
                result.add("last");
            } else if (this.getClassIndex() == 0) {
                result.add("first");
            } else {
                result.add("" + (this.getClassIndex() + 1));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public void setSourceCode(Filter value) {
        this.m_SourceCode = value;
    }

    public Filter getSourceCode() {
        return this.m_SourceCode;
    }

    public void setDataset(File value) {
        if (!value.exists()) {
            throw new IllegalArgumentException("Dataset '" + value.getAbsolutePath() + "' does not exist!");
        }
        this.m_Dataset = value;
    }

    public File getDataset() {
        return this.m_Dataset;
    }

    public void setClassIndex(int value) {
        this.m_ClassIndex = value;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    protected boolean compare(Instance inst1, Instance inst2) {
        boolean result;
        boolean bl = result = inst1.numAttributes() == inst2.numAttributes();
        if (result) {
            for (int i = 0; i < inst1.numAttributes(); ++i) {
                if (Double.isNaN(inst1.value(i)) && Double.isNaN(inst2.value(i)) || inst1.value(i) == inst2.value(i)) continue;
                result = false;
                System.out.println("Values at position " + (i + 1) + " differ (Filter/Source code): " + inst1.value(i) + " != " + inst2.value(i));
                break;
            }
        }
        return result;
    }

    protected boolean compare(Instances inst1, Instances inst2) {
        boolean result;
        boolean bl = result = inst1.numInstances() == inst2.numInstances();
        if (result) {
            for (int i = 0; i < inst1.numInstances(); ++i) {
                result = this.compare(inst1.instance(i), inst2.instance(i));
                if (result) continue;
                System.out.println("Values in line " + (i + 1) + " differ!");
                break;
            }
        }
        return result;
    }

    public boolean execute() throws Exception {
        boolean result = true;
        if (this.getFilter() == null) {
            throw new Exception("No filter set!");
        }
        if (this.getSourceCode() == null) {
            throw new Exception("No source code set!");
        }
        if (this.getDataset() == null) {
            throw new Exception("No dataset set!");
        }
        if (!this.getDataset().exists()) {
            throw new Exception("Dataset '" + this.getDataset().getAbsolutePath() + "' does not exist!");
        }
        ConverterUtils.DataSource source = new ConverterUtils.DataSource(this.getDataset().getAbsolutePath());
        Instances data = source.getDataSet();
        if (this.getClassIndex() == -2) {
            data.setClassIndex(data.numAttributes() - 1);
        } else {
            data.setClassIndex(this.getClassIndex());
        }
        Filter filter = Filter.makeCopy(this.getFilter());
        filter.setInputFormat(data);
        Instances filteredInstances = Filter.useFilter(data, filter);
        Filter filterSource = Filter.makeCopy(this.getSourceCode());
        filterSource.setInputFormat(data);
        Instances filteredInstancesSource = Filter.useFilter(data, filterSource);
        result = this.compare(filteredInstances, filteredInstancesSource);
        if (result) {
            filter = Filter.makeCopy(this.getFilter());
            filter.setInputFormat(data);
            Filter.useFilter(data, filter);
            filterSource = Filter.makeCopy(this.getSourceCode());
            filterSource.setInputFormat(data);
            for (int i = 0; i < data.numInstances(); ++i) {
                filter.input(data.instance(i));
                filter.batchFinished();
                Instance filteredInstance = filter.output();
                filterSource.input(data.instance(i));
                filterSource.batchFinished();
                Instance filteredInstanceSource = filterSource.output();
                if (this.compare(filteredInstance, filteredInstanceSource)) continue;
                System.out.println(i + 1 + ". instance (Filter/Source code): " + filteredInstance + " != " + filteredInstanceSource);
            }
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10214 $");
    }

    public static void main(String[] args) throws Exception {
        CheckSource check = new CheckSource();
        if (Utils.getFlag('h', args)) {
            StringBuffer text = new StringBuffer();
            text.append("\nHelp requested:\n\n");
            Enumeration enm = check.listOptions();
            while (enm.hasMoreElements()) {
                Option option = (Option)enm.nextElement();
                text.append(option.synopsis() + "\n");
                text.append(option.description() + "\n");
            }
            System.out.println("\n" + text + "\n");
        } else {
            check.setOptions(args);
            if (check.execute()) {
                System.out.println("Tests OK!");
            } else {
                System.out.println("Tests failed!");
            }
        }
    }
}

