/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.UpdateableClusterer;
import weka.core.CheckScheme;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckClusterer
extends CheckScheme {
    protected Clusterer m_Clusterer = new SimpleKMeans();

    public CheckClusterer() {
        this.setNumInstances(40);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull name of the clusterer analyzed.\n\teg: weka.clusterers.SimpleKMeans\n\t(default weka.clusterers.SimpleKMeans)", "W", 1, "-W"));
        result.addAll(Collections.list(super.listOptions()));
        if (this.m_Clusterer != null && this.m_Clusterer instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_Clusterer.getClass().getName() + ":"));
            result.addAll(Collections.list(((OptionHandler)((Object)this.m_Clusterer)).listOptions()));
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNumInstances(Integer.parseInt(tmpStr));
        } else {
            this.setNumInstances(40);
        }
        super.setOptions(options);
        tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            tmpStr = SimpleKMeans.class.getName();
        }
        this.setClusterer((Clusterer)this.forName("weka.clusterers", Clusterer.class, tmpStr, Utils.partitionOptions(options)));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options;
        Vector<String> result = new Vector<String>();
        if (this.getClusterer() != null) {
            result.add("-W");
            result.add(this.getClusterer().getClass().getName());
        }
        Collections.addAll(result, super.getOptions());
        if (this.m_Clusterer != null && this.m_Clusterer instanceof OptionHandler && (options = ((OptionHandler)((Object)this.m_Clusterer)).getOptions()).length > 0) {
            result.add("--");
            Collections.addAll(result, options);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void doTests() {
        if (this.getClusterer() == null) {
            this.println("\n=== No clusterer set ===");
            return;
        }
        this.println("\n=== Check on Clusterer: " + this.getClusterer().getClass().getName() + " ===\n");
        this.println("--> Checking for interfaces");
        this.canTakeOptions();
        boolean updateable = this.updateableClusterer()[0];
        boolean weightedInstancesHandler = this.weightedInstancesHandler()[0];
        boolean multiInstanceHandler = this.multiInstanceHandler()[0];
        this.println("--> Clusterer tests");
        this.declaresSerialVersionUID();
        this.runTests(weightedInstancesHandler, multiInstanceHandler, updateable);
    }

    public void setClusterer(Clusterer newClusterer) {
        this.m_Clusterer = newClusterer;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    protected void runTests(boolean weighted, boolean multiInstance, boolean updateable) {
        boolean PNom = this.canPredict(true, false, false, false, false, multiInstance)[0];
        boolean PNum = this.canPredict(false, true, false, false, false, multiInstance)[0];
        boolean PStr = this.canPredict(false, false, true, false, false, multiInstance)[0];
        boolean PDat = this.canPredict(false, false, false, true, false, multiInstance)[0];
        boolean PRel = !multiInstance ? this.canPredict(false, false, false, false, true, multiInstance)[0] : false;
        if (PNom || PNum || PStr || PDat || PRel) {
            if (weighted) {
                this.instanceWeights(PNom, PNum, PStr, PDat, PRel, multiInstance);
            }
            this.canHandleZeroTraining(PNom, PNum, PStr, PDat, PRel, multiInstance);
            boolean handleMissingPredictors = this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, true, 20)[0];
            if (handleMissingPredictors) {
                this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, true, 100);
            }
            this.correctBuildInitialisation(PNom, PNum, PStr, PDat, PRel, multiInstance);
            this.datasetIntegrity(PNom, PNum, PStr, PDat, PRel, multiInstance, handleMissingPredictors);
            if (updateable) {
                this.updatingEquality(PNom, PNum, PStr, PDat, PRel, multiInstance);
            }
        }
    }

    protected boolean[] canTakeOptions() {
        boolean[] result = new boolean[2];
        this.print("options...");
        if (this.m_Clusterer instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration<Option> enu = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
                while (enu.hasMoreElements()) {
                    Option option = enu.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] updateableClusterer() {
        boolean[] result = new boolean[2];
        this.print("updateable clusterer...");
        if (this.m_Clusterer instanceof UpdateableClusterer) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] result = new boolean[2];
        this.print("weighted instances clusterer...");
        if (this.m_Clusterer instanceof WeightedInstancesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] result = new boolean[2];
        this.print("multi-instance clusterer...");
        if (this.m_Clusterer instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] declaresSerialVersionUID() {
        boolean[] result = new boolean[2];
        this.print("serialVersionUID...");
        boolean bl = result[0] = !SerializationHelper.needsUID(this.m_Clusterer.getClass());
        if (result[0]) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return result;
    }

    protected boolean[] canPredict(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance) {
        this.print("basic predict");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance);
        this.print("...");
        Vector<String> accepts = new Vector<String>();
        accepts.addElement("unary");
        accepts.addElement("binary");
        accepts.addElement("nominal");
        accepts.addElement("numeric");
        accepts.addElement("string");
        accepts.addElement("date");
        accepts.addElement("relational");
        accepts.addElement("multi-instance");
        accepts.addElement("not in classpath");
        int numTrain = this.getNumInstances();
        int missingLevel = 0;
        boolean predictorMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, missingLevel, predictorMissing, numTrain, accepts);
    }

    protected boolean[] canHandleZeroTraining(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance) {
        this.print("handle zero training instances");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance);
        this.print("...");
        Vector<String> accepts = new Vector<String>();
        accepts.addElement("train");
        accepts.addElement("value");
        int numTrain = 0;
        int missingLevel = 0;
        boolean predictorMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, missingLevel, predictorMissing, numTrain, accepts);
    }

    protected boolean[] correctBuildInitialisation(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance) {
        boolean[] result;
        block16: {
            result = new boolean[2];
            this.print("correct initialisation during buildClusterer");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance);
            this.print("...");
            int numTrain = this.getNumInstances();
            int missingLevel = 0;
            boolean predictorMissing = false;
            Instances train1 = null;
            Instances train2 = null;
            Clusterer clusterer = null;
            ClusterEvaluation evaluation1A = null;
            ClusterEvaluation evaluation1B = null;
            ClusterEvaluation evaluation2 = null;
            boolean built = false;
            int stage = 0;
            try {
                train1 = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, multiInstance);
                train2 = this.makeTestDataset(84, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, multiInstance);
                if (nominalPredictor && !multiInstance) {
                    train1.deleteAttributeAt(0);
                    train2.deleteAttributeAt(0);
                }
                if (missingLevel > 0) {
                    this.addMissing(train1, missingLevel, predictorMissing);
                    this.addMissing(train2, missingLevel, predictorMissing);
                }
                clusterer = AbstractClusterer.makeCopies(this.getClusterer(), 1)[0];
                evaluation1A = new ClusterEvaluation();
                evaluation1B = new ClusterEvaluation();
                evaluation2 = new ClusterEvaluation();
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                stage = 0;
                clusterer.buildClusterer(train1);
                built = true;
                evaluation1A.setClusterer(clusterer);
                evaluation1A.evaluateClusterer(train1);
                stage = 1;
                built = false;
                clusterer.buildClusterer(train2);
                built = true;
                evaluation2.setClusterer(clusterer);
                evaluation2.evaluateClusterer(train2);
                stage = 2;
                built = false;
                clusterer.buildClusterer(train1);
                built = true;
                evaluation1B.setClusterer(clusterer);
                evaluation1B.evaluateClusterer(train1);
                stage = 3;
                if (!evaluation1A.equals(evaluation1B)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n");
                        this.println("First buildClusterer()");
                        this.println(evaluation1A.clusterResultsToString() + "\n\n");
                        this.println("Second buildClusterer()");
                        this.println(evaluation1B.clusterResultsToString() + "\n\n");
                    }
                    throw new Exception("Results differ between buildClusterer calls");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block16;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (stage) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + ex.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + train1.toString() + "\n");
                this.println("=== Train2 Dataset ===\n" + train2.toString() + "\n");
            }
        }
        return result;
    }

    protected boolean[] canHandleMissing(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, boolean predictorMissing, int missingLevel) {
        if (missingLevel == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (predictorMissing) {
            this.print(" predictor");
        }
        this.print(" values");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance);
        this.print("...");
        Vector<String> accepts = new Vector<String>();
        accepts.addElement("missing");
        accepts.addElement("value");
        accepts.addElement("train");
        int numTrain = this.getNumInstances();
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, missingLevel, predictorMissing, numTrain, accepts);
    }

    protected boolean[] instanceWeights(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance) {
        boolean[] result;
        block14: {
            this.print("clusterer uses instance weights");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance);
            this.print("...");
            int numTrain = 2 * this.getNumInstances();
            int missingLevel = 0;
            boolean predictorMissing = false;
            result = new boolean[2];
            Instances train = null;
            Clusterer[] clusterers = null;
            ClusterEvaluation evaluationB = null;
            ClusterEvaluation evaluationI = null;
            boolean built = false;
            boolean evalFail = false;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, multiInstance);
                if (nominalPredictor && !multiInstance) {
                    train.deleteAttributeAt(0);
                }
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing);
                }
                clusterers = AbstractClusterer.makeCopies(this.getClusterer(), 2);
                evaluationB = new ClusterEvaluation();
                evaluationI = new ClusterEvaluation();
                clusterers[0].buildClusterer(train);
                evaluationB.setClusterer(clusterers[0]);
                evaluationB.evaluateClusterer(train);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                for (int i = 0; i < train.numInstances(); ++i) {
                    train.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < train.numInstances() / 2; ++i) {
                    int inst = random.nextInt(train.numInstances());
                    int weight = random.nextInt(10) + 1;
                    train.instance(inst).setWeight(weight);
                }
                clusterers[1].buildClusterer(train);
                built = true;
                evaluationI.setClusterer(clusterers[1]);
                evaluationI.evaluateClusterer(train);
                if (evaluationB.equals(evaluationI)) {
                    evalFail = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block14;
                this.println("\n=== Full Report ===");
                if (evalFail) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println("\nboth methods\n");
                    this.println(evaluationB.clusterResultsToString());
                } else {
                    this.print("Problem during");
                    if (built) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + ex.getMessage() + "\n");
                }
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < train.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + train.instance(i).weight());
                }
            }
        }
        return result;
    }

    protected boolean[] datasetIntegrity(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, boolean predictorMissing) {
        boolean[] result;
        block6: {
            this.print("clusterer doesn't alter original datasets");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance);
            this.print("...");
            int numTrain = this.getNumInstances();
            int missingLevel = 20;
            result = new boolean[2];
            Instances train = null;
            Clusterer clusterer = null;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, multiInstance);
                if (nominalPredictor && !multiInstance) {
                    train.deleteAttributeAt(0);
                }
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing);
                }
                clusterer = AbstractClusterer.makeCopies(this.getClusterer(), 1)[0];
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                Instances trainCopy = new Instances(train);
                clusterer.buildClusterer(trainCopy);
                this.compareDatasets(train, trainCopy);
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block6;
                this.println("\n=== Full Report ===");
                this.print("Problem during training");
                this.println(": " + ex.getMessage() + "\n");
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
            }
        }
        return result;
    }

    protected boolean[] updatingEquality(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance) {
        this.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance);
        this.print("...");
        int numTrain = this.getNumInstances();
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        boolean[] result = new boolean[2];
        Instances train = null;
        Clusterer[] clusterers = null;
        ClusterEvaluation evaluationB = null;
        ClusterEvaluation evaluationI = null;
        boolean built = false;
        try {
            train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, multiInstance);
            if (missingLevel > 0) {
                this.addMissing(train, missingLevel, predictorMissing, classMissing);
            }
            clusterers = AbstractClusterer.makeCopies(this.getClusterer(), 2);
            evaluationB = new ClusterEvaluation();
            evaluationI = new ClusterEvaluation();
            clusterers[0].buildClusterer(train);
            evaluationB.setClusterer(clusterers[0]);
            evaluationB.evaluateClusterer(train);
        }
        catch (Exception ex) {
            throw new Error("Error setting up for tests: " + ex.getMessage());
        }
        try {
            clusterers[1].buildClusterer(new Instances(train, 0));
            for (int i = 0; i < train.numInstances(); ++i) {
                ((UpdateableClusterer)((Object)clusterers[1])).updateClusterer(train.instance(i));
            }
            built = true;
            evaluationI.setClusterer(clusterers[1]);
            evaluationI.evaluateClusterer(train);
            if (!evaluationB.equals(evaluationI)) {
                this.println("no");
                result[0] = false;
                if (this.m_Debug) {
                    this.println("\n=== Full Report ===");
                    this.println("Results differ between batch and incrementally built models.\nDepending on the classifier, this may be OK");
                    this.println("Here are the results:\n");
                    this.println("\nbatch built results\n" + evaluationB.clusterResultsToString());
                    this.println("\nincrementally built results\n" + evaluationI.clusterResultsToString());
                    this.println("Here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                }
            } else {
                this.println("yes");
                result[0] = true;
            }
        }
        catch (Exception ex) {
            result[0] = false;
            this.print("Problem during");
            if (built) {
                this.print(" testing");
            } else {
                this.print(" training");
            }
            this.println(": " + ex.getMessage() + "\n");
        }
        return result;
    }

    protected boolean[] runBasicTest(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int missingLevel, boolean predictorMissing, int numTrain, Vector<String> accepts) {
        boolean[] result;
        block10: {
            result = new boolean[2];
            Instances train = null;
            Clusterer clusterer = null;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, multiInstance);
                if (nominalPredictor && !multiInstance) {
                    train.deleteAttributeAt(0);
                }
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing);
                }
                clusterer = AbstractClusterer.makeCopies(this.getClusterer(), 1)[0];
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                clusterer.buildClusterer(train);
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                int i;
                boolean acceptable = false;
                String msg = ex.getMessage().toLowerCase();
                for (i = 0; i < accepts.size(); ++i) {
                    if (msg.indexOf(accepts.elementAt(i)) < 0) continue;
                    acceptable = true;
                }
                this.println("no" + (acceptable ? " (OK error message)" : ""));
                result[1] = acceptable;
                if (!this.m_Debug) break block10;
                this.println("\n=== Full Report ===");
                this.print("Problem during training");
                this.println(": " + ex.getMessage() + "\n");
                if (acceptable) break block10;
                if (accepts.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (i = 0; i < accepts.size(); ++i) {
                        if (i != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + accepts.elementAt(i) + '\"');
                    }
                }
                this.println("here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
            }
        }
        return result;
    }

    protected void addMissing(Instances data, int level, boolean predictorMissing) {
        Random random = new Random(1L);
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance current = data.instance(i);
            for (int j = 0; j < data.numAttributes(); ++j) {
                if (!predictorMissing || random.nextInt(100) >= level) continue;
                current.setMissing(j);
            }
        }
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numString, int numDate, int numRelational, boolean multiInstance) throws Exception {
        TestInstances dataset = new TestInstances();
        dataset.setSeed(seed);
        dataset.setNumInstances(numInstances);
        dataset.setNumNominal(numNominal);
        dataset.setNumNumeric(numNumeric);
        dataset.setNumString(numString);
        dataset.setNumDate(numDate);
        dataset.setNumRelational(numRelational);
        dataset.setClassIndex(-2);
        dataset.setMultiInstance(multiInstance);
        return dataset.generate();
    }

    protected void printAttributeSummary(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance) {
        String str = "";
        if (numericPredictor) {
            str = str + "numeric";
        }
        if (nominalPredictor) {
            if (str.length() > 0) {
                str = str + " & ";
            }
            str = str + "nominal";
        }
        if (stringPredictor) {
            if (str.length() > 0) {
                str = str + " & ";
            }
            str = str + "string";
        }
        if (datePredictor) {
            if (str.length() > 0) {
                str = str + " & ";
            }
            str = str + "date";
        }
        if (relationalPredictor) {
            if (str.length() > 0) {
                str = str + " & ";
            }
            str = str + "relational";
        }
        str = " (" + str + " predictors)";
        this.print(str);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11456 $");
    }

    public static void main(String[] args) {
        CheckClusterer.runCheck(new CheckClusterer(), args);
    }
}

