/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.part;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.rules.part.C45PruneableDecList;
import weka.classifiers.rules.part.ClassifierDecList;
import weka.classifiers.rules.part.PruneableDecList;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class MakeDecList
implements Serializable,
CapabilitiesHandler,
RevisionHandler {
    private static final long serialVersionUID = -1427481323245079123L;
    private Vector<ClassifierDecList> theRules;
    private double CF = 0.25;
    private final int minNumObj;
    private final ModelSelection toSelectModeL;
    private int numSetS = 3;
    private boolean reducedErrorPruning = false;
    private boolean unpruned = false;
    private int m_seed = 1;

    public MakeDecList(ModelSelection toSelectLocModel, int minNum) {
        this.toSelectModeL = toSelectLocModel;
        this.reducedErrorPruning = false;
        this.unpruned = true;
        this.minNumObj = minNum;
    }

    public MakeDecList(ModelSelection toSelectLocModel, double cf, int minNum) {
        this.toSelectModeL = toSelectLocModel;
        this.CF = cf;
        this.reducedErrorPruning = false;
        this.unpruned = false;
        this.minNumObj = minNum;
    }

    public MakeDecList(ModelSelection toSelectLocModel, int num, int minNum, int seed) {
        this.toSelectModeL = toSelectLocModel;
        this.numSetS = num;
        this.reducedErrorPruning = true;
        this.unpruned = false;
        this.minNumObj = minNum;
        this.m_seed = seed;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        Instances oldPruneData;
        Instances oldGrowData;
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.theRules = new Vector();
        if (this.reducedErrorPruning && !this.unpruned) {
            Random random = new Random(this.m_seed);
            data.randomize(random);
            data.stratify(this.numSetS);
            oldGrowData = data.trainCV(this.numSetS, this.numSetS - 1, random);
            oldPruneData = data.testCV(this.numSetS, this.numSetS - 1);
        } else {
            oldGrowData = data;
            oldPruneData = null;
        }
        while (Utils.gr(oldGrowData.numInstances(), 0.0)) {
            double currentWeight;
            Instance instance;
            ClassifierDecList currentRule;
            if (this.unpruned) {
                currentRule = new ClassifierDecList(this.toSelectModeL, this.minNumObj);
                currentRule.buildRule(oldGrowData);
            } else if (this.reducedErrorPruning) {
                currentRule = new PruneableDecList(this.toSelectModeL, this.minNumObj);
                ((PruneableDecList)currentRule).buildRule(oldGrowData, oldPruneData);
            } else {
                currentRule = new C45PruneableDecList(this.toSelectModeL, this.CF, this.minNumObj);
                ((C45PruneableDecList)currentRule).buildRule(oldGrowData);
            }
            Instances newGrowData = new Instances(oldGrowData, oldGrowData.numInstances());
            Enumeration<Instance> enu = oldGrowData.enumerateInstances();
            while (enu.hasMoreElements()) {
                instance = enu.nextElement();
                currentWeight = currentRule.weight(instance);
                if (!Utils.sm(currentWeight, 1.0)) continue;
                instance.setWeight(instance.weight() * (1.0 - currentWeight));
                newGrowData.add(instance);
            }
            newGrowData.compactify();
            oldGrowData = newGrowData;
            if (this.reducedErrorPruning && !this.unpruned) {
                Instances newPruneData = new Instances(oldPruneData, oldPruneData.numInstances());
                enu = oldPruneData.enumerateInstances();
                while (enu.hasMoreElements()) {
                    instance = enu.nextElement();
                    currentWeight = currentRule.weight(instance);
                    if (!Utils.sm(currentWeight, 1.0)) continue;
                    instance.setWeight(instance.weight() * (1.0 - currentWeight));
                    newPruneData.add(instance);
                }
                newPruneData.compactify();
                oldPruneData = newPruneData;
            }
            this.theRules.addElement(currentRule);
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.theRules.size(); ++i) {
            text.append(this.theRules.elementAt(i) + "\n");
        }
        text.append("Number of Rules  : \t" + this.theRules.size() + "\n");
        return text.toString();
    }

    public double classifyInstance(Instance instance) throws Exception {
        double maxProb = -1.0;
        int maxIndex = 0;
        double[] sumProbs = this.distributionForInstance(instance);
        for (int j = 0; j < sumProbs.length; ++j) {
            if (!Utils.gr(sumProbs[j], maxProb)) continue;
            maxIndex = j;
            maxProb = sumProbs[j];
        }
        return maxIndex;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] currentProbs = null;
        double weight = 1.0;
        double[] sumProbs = new double[instance.numClasses()];
        int i = 0;
        while (Utils.gr(weight, 0.0)) {
            double currentWeight = this.theRules.elementAt(i).weight(instance);
            if (Utils.gr(currentWeight, 0.0)) {
                currentProbs = this.theRules.elementAt(i).distributionForInstance(instance);
                for (int j = 0; j < sumProbs.length; ++j) {
                    int n = j;
                    sumProbs[n] = sumProbs[n] + weight * currentProbs[j];
                }
                weight *= 1.0 - currentWeight;
            }
            ++i;
        }
        return sumProbs;
    }

    public int numRules() {
        return this.theRules.size();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10166 $");
    }
}

