/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.googlecloudstorage.lifecycle;

import com.pentaho.googlecloudstorage.vfs.GoogleCloudStorageFileProvider;
import java.util.Arrays;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.vfs.KettleVFS;

@KettleLifecyclePlugin(id="GoogleCloudStoragePluginLifecycleListener", name="GoogleCloudStoragePluginLifecycleListener")
public class GoogleCloudStoragePluginLifecycleListener
implements KettleLifecycleListener {
    public void onEnvironmentInit() throws LifecycleException {
        try {
            FileSystemManager fsm = KettleVFS.getInstance().getFileSystemManager();
            if (fsm instanceof DefaultFileSystemManager && !Arrays.asList(fsm.getSchemes()).contains(GoogleCloudStorageFileProvider.SCHEME)) {
                ((DefaultFileSystemManager)fsm).addProvider(GoogleCloudStorageFileProvider.SCHEME, (FileProvider)new GoogleCloudStorageFileProvider());
            }
        }
        catch (FileSystemException e) {
            throw new LifecycleException(e.getMessage(), false);
        }
    }

    public void onEnvironmentShutdown() {
    }
}

