/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.fast;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public interface DeserializeRead {
    public TypeInfo[] typeInfos();

    public void set(byte[] var1, int var2, int var3);

    public boolean readCheckNull() throws IOException;

    public void extraFieldsCheck();

    public boolean readBeyondConfiguredFieldsWarned();

    public boolean readBeyondBufferRangeWarned();

    public boolean bufferRangeHasExtraDataWarned();

    public boolean readBoolean() throws IOException;

    public byte readByte() throws IOException;

    public short readShort() throws IOException;

    public int readInt() throws IOException;

    public long readLong() throws IOException;

    public float readFloat() throws IOException;

    public double readDouble() throws IOException;

    public ReadStringResults createReadStringResults();

    public void readString(ReadStringResults var1) throws IOException;

    public ReadHiveCharResults createReadHiveCharResults();

    public void readHiveChar(ReadHiveCharResults var1) throws IOException;

    public ReadHiveVarcharResults createReadHiveVarcharResults();

    public void readHiveVarchar(ReadHiveVarcharResults var1) throws IOException;

    public ReadBinaryResults createReadBinaryResults();

    public void readBinary(ReadBinaryResults var1) throws IOException;

    public ReadDateResults createReadDateResults();

    public void readDate(ReadDateResults var1) throws IOException;

    public ReadTimestampResults createReadTimestampResults();

    public void readTimestamp(ReadTimestampResults var1) throws IOException;

    public ReadIntervalYearMonthResults createReadIntervalYearMonthResults();

    public void readIntervalYearMonth(ReadIntervalYearMonthResults var1) throws IOException;

    public ReadIntervalDayTimeResults createReadIntervalDayTimeResults();

    public void readIntervalDayTime(ReadIntervalDayTimeResults var1) throws IOException;

    public ReadDecimalResults createReadDecimalResults();

    public void readHiveDecimal(ReadDecimalResults var1) throws IOException;

    public static abstract class ReadDecimalResults {
        protected DecimalTypeInfo decimalTypeInfo;

        public void init(DecimalTypeInfo decimalTypeInfo) {
            this.decimalTypeInfo = decimalTypeInfo;
        }

        public boolean isInit() {
            return this.decimalTypeInfo != null;
        }

        public abstract HiveDecimal getHiveDecimal();
    }

    public static abstract class ReadIntervalDayTimeResults {
        protected HiveIntervalDayTimeWritable hiveIntervalDayTimeWritable = new HiveIntervalDayTimeWritable();

        public HiveIntervalDayTime getHiveIntervalDayTime() {
            return this.hiveIntervalDayTimeWritable.getHiveIntervalDayTime();
        }
    }

    public static abstract class ReadIntervalYearMonthResults {
        protected HiveIntervalYearMonthWritable hiveIntervalYearMonthWritable = new HiveIntervalYearMonthWritable();

        public HiveIntervalYearMonth getHiveIntervalYearMonth() {
            return this.hiveIntervalYearMonthWritable.getHiveIntervalYearMonth();
        }
    }

    public static abstract class ReadTimestampResults {
        protected TimestampWritable timestampWritable = new TimestampWritable();

        public Timestamp getTimestamp() {
            return this.timestampWritable.getTimestamp();
        }
    }

    public static abstract class ReadDateResults {
        protected DateWritable dateWritable = new DateWritable();

        public Date getDate() {
            return this.dateWritable.get();
        }

        public int getDays() {
            return this.dateWritable.getDays();
        }
    }

    public static abstract class ReadBinaryResults
    extends ReadBytesResults {
    }

    public static abstract class ReadHiveVarcharResults
    extends ReadBytesResults {
        private VarcharTypeInfo varcharTypeInfo;
        private int maxLength;
        protected HiveVarcharWritable hiveVarcharWritable;

        public void init(VarcharTypeInfo varcharTypeInfo) {
            this.varcharTypeInfo = varcharTypeInfo;
            this.maxLength = varcharTypeInfo.getLength();
            this.hiveVarcharWritable = new HiveVarcharWritable();
        }

        public boolean isInit() {
            return this.varcharTypeInfo != null;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public HiveVarchar getHiveVarchar() {
            return this.hiveVarcharWritable.getHiveVarchar();
        }
    }

    public static abstract class ReadHiveCharResults
    extends ReadBytesResults {
        private CharTypeInfo charTypeInfo;
        private int maxLength;
        protected HiveCharWritable hiveCharWritable;

        public void init(CharTypeInfo charTypeInfo) {
            this.charTypeInfo = charTypeInfo;
            this.maxLength = charTypeInfo.getLength();
            this.hiveCharWritable = new HiveCharWritable();
        }

        public boolean isInit() {
            return this.charTypeInfo != null;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public HiveChar getHiveChar() {
            return this.hiveCharWritable.getHiveChar();
        }
    }

    public static abstract class ReadStringResults
    extends ReadBytesResults {
    }

    public static abstract class ReadBytesResults {
        public byte[] bytes = null;
        public int start = 0;
        public int length = 0;
    }
}

