/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hive.spark.counter.SparkCounters;

public class CounterStatsAggregatorSpark
implements StatsAggregator,
StatsCollectionTaskIndependent {
    private static final Log LOG = LogFactory.getLog(CounterStatsAggregatorSpark.class);
    private SparkCounters sparkCounters;

    @Override
    public boolean connect(StatsCollectionContext scc) {
        SparkTask task = (SparkTask)scc.getTask();
        this.sparkCounters = task.getSparkCounters();
        return this.sparkCounters != null;
    }

    @Override
    public String aggregateStats(String keyPrefix, String statType) {
        long value = this.sparkCounters.getValue(keyPrefix, statType);
        String result = String.valueOf(value);
        LOG.info((Object)String.format("Counter based stats for (%s, %s) are: %s", keyPrefix, statType, result));
        return result;
    }

    @Override
    public boolean closeConnection(StatsCollectionContext scc) {
        return true;
    }

    @Override
    public boolean cleanUp(String keyPrefix) {
        return true;
    }
}

