/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.FileFormatException;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.Metadata;
import org.apache.hadoop.hive.ql.io.orc.MetadataReader;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcTail;
import org.apache.hadoop.hive.ql.io.orc.OrcUtils;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.TypeDescription;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;

public class ReaderImpl
implements Reader {
    private static final Log LOG = LogFactory.getLog(ReaderImpl.class);
    private static final int DIRECTORY_SIZE_GUESS = 16384;
    private static final int DEFAULT_PROTOBUF_MESSAGE_LIMIT = 0x4000000;
    private static final int PROTOBUF_MESSAGE_MAX_LIMIT = 0x40000000;
    protected final FileSystem fileSystem;
    protected final Path path;
    protected final CompressionKind compressionKind;
    protected final CompressionCodec codec;
    protected final int bufferSize;
    private OrcProto.Metadata metadata = null;
    private final int metadataSize;
    private final TypeDescription schema;
    protected final OrcProto.Footer footer;
    private final ObjectInspector inspector;
    private long deserializedSize = -1L;
    protected final Configuration conf;
    private final List<Integer> versionList;
    private final OrcFile.WriterVersion writerVersion;
    private final ByteBuffer footerByteBuffer;
    private final OrcTail tail;

    @Override
    public long getNumberOfRows() {
        return this.footer.getNumberOfRows();
    }

    @Override
    public List<String> getMetadataKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            result.add(item.getName());
        }
        return result;
    }

    @Override
    public ByteBuffer getMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return item.getValue().asReadOnlyByteBuffer();
        }
        throw new IllegalArgumentException("Can't find user metadata " + key);
    }

    @Override
    public boolean hasMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompressionKind getCompression() {
        return this.compressionKind;
    }

    @Override
    public int getCompressionSize() {
        return this.bufferSize;
    }

    @Override
    public List<StripeInformation> getStripes() {
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>();
        for (OrcProto.StripeInformation info : this.footer.getStripesList()) {
            result.add(new StripeInformationImpl(info));
        }
        return result;
    }

    @Override
    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    @Override
    public long getContentLength() {
        return this.footer.getContentLength();
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return this.footer.getTypesList();
    }

    @Override
    public OrcFile.Version getFileVersion() {
        for (OrcFile.Version version : OrcFile.Version.values()) {
            if (version.getMajor() != this.versionList.get(0).intValue() || version.getMinor() != this.versionList.get(1).intValue()) continue;
            return version;
        }
        return OrcFile.Version.V_0_11;
    }

    @Override
    public OrcFile.WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    @Override
    public int getRowIndexStride() {
        return this.footer.getRowIndexStride();
    }

    @Override
    public ColumnStatistics[] getStatistics() {
        ColumnStatistics[] result = new ColumnStatistics[this.footer.getTypesCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ColumnStatisticsImpl.deserialize(this.footer.getStatistics(i));
        }
        return result;
    }

    @Override
    public TypeDescription getSchema() {
        return this.schema;
    }

    static void ensureOrcFooter(FSDataInputStream in, Path path, int psLen, ByteBuffer buffer) throws IOException {
        int magicLength = "ORC".length();
        int fullLength = magicLength + 1;
        if (psLen < fullLength || buffer.remaining() < fullLength) {
            throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript length " + psLen);
        }
        int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - fullLength;
        byte[] array = buffer.array();
        if (!Text.decode((byte[])array, (int)offset, (int)magicLength).equals("ORC")) {
            byte[] header = new byte[magicLength];
            in.readFully(0L, header, 0, magicLength);
            if (!Text.decode((byte[])header, (int)0, (int)magicLength).equals("ORC")) {
                throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript.");
            }
        }
    }

    private static String versionString(List<Integer> version) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < version.size(); ++i) {
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(version.get(i));
        }
        return buffer.toString();
    }

    static void checkOrcVersion(Log log, Path path, List<Integer> version) {
        if (version.size() >= 1) {
            int major = version.get(0);
            int minor = 0;
            if (version.size() >= 2) {
                minor = version.get(1);
            }
            if (major > OrcFile.Version.CURRENT.getMajor() || major == OrcFile.Version.CURRENT.getMajor() && minor > OrcFile.Version.CURRENT.getMinor()) {
                log.warn((Object)("ORC file " + path + " was written by a future Hive version " + ReaderImpl.versionString(version) + ". This file may not be readable by this version of Hive."));
            }
        }
    }

    public ReaderImpl(Path path, OrcFile.ReaderOptions options) throws IOException {
        FileSystem fs = options.getFilesystem();
        if (fs == null) {
            fs = path.getFileSystem(options.getConfiguration());
        }
        this.fileSystem = fs;
        this.path = path;
        this.conf = options.getConfiguration();
        OrcTail orcTail = options.getOrcTail();
        if (orcTail == null) {
            this.tail = ReaderImpl.extractFileTail(fs, path, options.getMaxLength());
            options.orcTail(this.tail);
        } else {
            this.tail = orcTail;
        }
        this.footerByteBuffer = this.tail.getSerializedTail();
        this.compressionKind = this.tail.getCompressionKind();
        this.codec = this.tail.getCompressionCodec();
        this.bufferSize = this.tail.getCompressionBufferSize();
        this.metadataSize = this.tail.getMetadataSize();
        this.versionList = this.tail.getPostScript().getVersionList();
        this.footer = this.tail.getFooter();
        this.writerVersion = this.tail.getWriterVersion();
        this.metadata = this.tail.getMetadata();
        this.inspector = OrcStruct.createObjectInspector(0, this.tail.getTypes());
        this.schema = OrcUtils.convertTypeFromProtobuf(this.tail.getTypes(), 0);
    }

    static OrcFile.WriterVersion getWriterVersion(int writerVersion) {
        for (OrcFile.WriterVersion version : OrcFile.WriterVersion.values()) {
            if (version.getId() != writerVersion) continue;
            return version;
        }
        return OrcFile.WriterVersion.ORIGINAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OrcTail extractFileTail(FileSystem fs, Path path, long maxFileLength) throws IOException {
        ByteBuffer buffer;
        long modificationTime;
        FSDataInputStream file = fs.open(path);
        OrcProto.FileTail.Builder fileTailBuilder = OrcProto.FileTail.newBuilder();
        try {
            long size;
            if (maxFileLength == Long.MAX_VALUE) {
                FileStatus fileStatus = fs.getFileStatus(path);
                size = fileStatus.getLen();
                modificationTime = fileStatus.getModificationTime();
            } else {
                size = maxFileLength;
                modificationTime = -1L;
            }
            fileTailBuilder.setFileLength(size);
            int readSize = (int)Math.min(size, 16384L);
            buffer = ByteBuffer.allocate(readSize);
            file.readFully(size - (long)readSize, buffer.array(), buffer.arrayOffset(), readSize);
            int psLen = buffer.get(readSize - 1) & 0xFF;
            ReaderImpl.ensureOrcFooter(file, path, psLen, buffer);
            int psOffset = readSize - 1 - psLen;
            CodedInputStream in = CodedInputStream.newInstance(buffer.array(), buffer.arrayOffset() + psOffset, psLen);
            OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(in);
            ReaderImpl.checkOrcVersion(LOG, path, ps.getVersionList());
            int footerSize = (int)ps.getFooterLength();
            int metadataSize = (int)ps.getMetadataLength();
            switch (ps.getCompression()) {
                case NONE: {
                    break;
                }
                case ZLIB: {
                    break;
                }
                case SNAPPY: {
                    break;
                }
                case LZO: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown compression");
                }
            }
            int extra = Math.max(0, psLen + 1 + footerSize + metadataSize - readSize);
            if (extra > 0) {
                ByteBuffer extraBuf = ByteBuffer.allocate(extra + readSize);
                file.readFully(size - (long)readSize - (long)extra, extraBuf.array(), extraBuf.arrayOffset() + extraBuf.position(), extra);
                extraBuf.position(extra);
                extraBuf.put(buffer);
                buffer = extraBuf;
                buffer.position(0);
                buffer.limit(footerSize + metadataSize);
                psOffset = (readSize += extra) - 1 - psLen;
            } else {
                buffer.position(psOffset - footerSize - metadataSize);
                buffer.limit(psOffset);
            }
            buffer.mark();
            int bufferSize = (int)ps.getCompressionBlockSize();
            CompressionCodec codec = WriterImpl.createCodec(CompressionKind.valueOf(ps.getCompression().name()));
            fileTailBuilder.setPostscriptLength(psLen).setPostscript(ps);
            int footerOffset = psOffset - footerSize;
            buffer.position(footerOffset);
            ByteBuffer footerBuffer = buffer.slice();
            buffer.reset();
            OrcProto.Footer footer = ReaderImpl.extractFooter(footerBuffer, 0, footerSize, codec, bufferSize);
            fileTailBuilder.setFooter(footer);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException ex) {
                LOG.error((Object)"Failed to close the file after another error", (Throwable)ex);
            }
        }
        return new OrcTail(fileTailBuilder.build(), buffer.slice(), modificationTime);
    }

    private static OrcProto.Footer extractFooter(ByteBuffer bb, int footerAbsPos, int footerSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(footerAbsPos);
        bb.limit(footerAbsPos + footerSize);
        CodedInputStream in = InStream.createCodedInputStream("footer", Lists.newArrayList(new RecordReaderImpl.BufferChunk(bb, 0L)), footerSize, codec, bufferSize);
        return OrcProto.Footer.parseFrom(in);
    }

    public static OrcProto.Metadata extractMetadata(ByteBuffer bb, int metadataAbsPos, int metadataSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(metadataAbsPos);
        bb.limit(metadataAbsPos + metadataSize);
        CodedInputStream in = InStream.createCodedInputStream("metadata", Lists.newArrayList(new RecordReaderImpl.BufferChunk(bb, 0L)), metadataSize, codec, bufferSize);
        return OrcProto.Metadata.parseFrom(in);
    }

    @Override
    public RecordReader rows() throws IOException {
        return this.rowsOptions(new Reader.Options());
    }

    @Override
    public RecordReader rowsOptions(Reader.Options options) throws IOException {
        LOG.info((Object)("Reading ORC rows from " + this.path + " with " + options));
        return new RecordReaderImpl(this, options);
    }

    @Override
    public RecordReader rows(boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include, SearchArgument sarg, String[] columnNames) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length).searchArgument(sarg, columnNames));
    }

    @Override
    public long getRawDataSize() {
        if (this.deserializedSize == -1L) {
            List<OrcProto.ColumnStatistics> stats = this.footer.getStatisticsList();
            ArrayList<Integer> indices = Lists.newArrayList();
            for (int i = 0; i < stats.size(); ++i) {
                indices.add(i);
            }
            this.deserializedSize = ReaderImpl.getRawDataSizeFromColIndices(indices, this.footer.getTypesList(), stats);
        }
        return this.deserializedSize;
    }

    @Override
    public OrcProto.FileTail getFileTail() {
        return this.tail.getFileTail();
    }

    @Override
    public ByteBuffer getSerializedFileFooter() {
        return this.tail.getSerializedTail();
    }

    public static long getRawDataSizeFromColIndices(List<Integer> colIndices, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats) {
        long result = 0L;
        for (int colIdx : colIndices) {
            result += ReaderImpl.getRawDataSizeOfColumn(colIdx, types, stats);
        }
        return result;
    }

    private static long getRawDataSizeOfColumn(int colIdx, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats) {
        OrcProto.ColumnStatistics colStat = stats.get(colIdx);
        long numVals = colStat.getNumberOfValues();
        OrcProto.Type type = types.get(colIdx);
        switch (type.getKind()) {
            case BINARY: {
                return colStat.getBinaryStatistics().getSum();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                numVals = numVals == 0L ? 1L : numVals;
                int avgStrLen = (int)(colStat.getStringStatistics().getSum() / numVals);
                return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgStrLen);
            }
            case TIMESTAMP: {
                return numVals * (long)JavaDataModel.get().lengthOfTimestamp();
            }
            case DATE: {
                return numVals * (long)JavaDataModel.get().lengthOfDate();
            }
            case DECIMAL: {
                return numVals * (long)JavaDataModel.get().lengthOfDecimal();
            }
            case DOUBLE: 
            case LONG: {
                return numVals * (long)JavaDataModel.get().primitive2();
            }
            case FLOAT: 
            case INT: 
            case SHORT: 
            case BOOLEAN: 
            case BYTE: {
                return numVals * (long)JavaDataModel.get().primitive1();
            }
        }
        LOG.debug((Object)("Unknown primitive category: " + type.getKind()));
        return 0L;
    }

    @Override
    public long getRawDataSizeOfColumns(List<String> colNames) {
        List<Integer> colIndices = this.getColumnIndicesFromNames(colNames);
        return ReaderImpl.getRawDataSizeFromColIndices(colIndices, this.tail.getTypes(), this.tail.getFooter().getStatisticsList());
    }

    @Override
    public long getRawDataSizeFromColIndices(List<Integer> colIds) {
        return ReaderImpl.getRawDataSizeFromColIndices(colIds, this.tail.getTypes(), this.tail.getFooter().getStatisticsList());
    }

    private List<Integer> getColumnIndicesFromNames(List<String> colNames) {
        OrcProto.Type type = this.footer.getTypesList().get(0);
        ArrayList<Integer> colIndices = Lists.newArrayList();
        List<String> fieldNames = type.getFieldNamesList();
        int fieldIdx = 0;
        for (String colName : colNames) {
            if (!fieldNames.contains(colName)) {
                String s = "Cannot find field for: " + colName + " in ";
                for (String fn : fieldNames) {
                    s = s + fn + ", ";
                }
                LOG.warn((Object)s);
                continue;
            }
            fieldIdx = fieldNames.indexOf(colName);
            int idxStart = type.getSubtypes(fieldIdx);
            int idxEnd = fieldIdx + 1 > fieldNames.size() - 1 ? this.getLastIdx() + 1 : type.getSubtypes(fieldIdx + 1);
            if (idxStart == idxEnd) {
                colIndices.add(idxStart);
                continue;
            }
            for (int i = idxStart; i < idxEnd; ++i) {
                colIndices.add(i);
            }
        }
        return colIndices;
    }

    private int getLastIdx() {
        HashSet<Integer> indices = Sets.newHashSet();
        for (OrcProto.Type type : this.footer.getTypesList()) {
            indices.addAll(type.getSubtypesList());
        }
        return (Integer)Collections.max(indices);
    }

    @Override
    public Metadata getMetadata() throws IOException {
        return new Metadata(this.metadata);
    }

    List<OrcProto.StripeStatistics> getOrcProtoStripeStatistics() {
        return this.metadata.getStripeStatsList();
    }

    public List<OrcProto.UserMetadataItem> getOrcProtoUserMetadata() {
        return this.footer.getMetadataList();
    }

    @Override
    public MetadataReader metadata() throws IOException {
        return new MetadataReader(this.fileSystem, this.path, this.codec, this.bufferSize, this.footer.getTypesCount());
    }

    static class StripeInformationImpl
    implements StripeInformation {
        private final OrcProto.StripeInformation stripe;

        StripeInformationImpl(OrcProto.StripeInformation stripe) {
            this.stripe = stripe;
        }

        @Override
        public long getOffset() {
            return this.stripe.getOffset();
        }

        @Override
        public long getLength() {
            return this.stripe.getDataLength() + this.getIndexLength() + this.getFooterLength();
        }

        @Override
        public long getDataLength() {
            return this.stripe.getDataLength();
        }

        @Override
        public long getFooterLength() {
            return this.stripe.getFooterLength();
        }

        @Override
        public long getIndexLength() {
            return this.stripe.getIndexLength();
        }

        @Override
        public long getNumberOfRows() {
            return this.stripe.getNumberOfRows();
        }

        public String toString() {
            return "offset: " + this.getOffset() + " data: " + this.getDataLength() + " rows: " + this.getNumberOfRows() + " tail: " + this.getFooterLength() + " index: " + this.getIndexLength();
        }
    }
}

