/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.ColumnarSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcTail;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;

public class OrcSplit
extends FileSplit
implements ColumnarSplit {
    private OrcTail orcTail;
    private boolean hasFooter;
    private boolean isOriginal;
    private boolean hasBase;
    private final List<AcidInputFormat.DeltaMetaData> deltas = new ArrayList<AcidInputFormat.DeltaMetaData>();
    private OrcFile.WriterVersion writerVersion;
    private long projColsUncompressedSize;
    private long fileLen;
    static final int BASE_FLAG = 4;
    static final int ORIGINAL_FLAG = 2;
    static final int FOOTER_FLAG = 1;

    protected OrcSplit() {
        super(null, 0L, 0L, (String[])null);
    }

    public OrcSplit(Path path, long offset, long length, String[] hosts, OrcTail orcTail, boolean isOriginal, boolean hasBase, List<AcidInputFormat.DeltaMetaData> deltas, long projectedDataSize, long fileLen) {
        super(path, offset, length, hosts);
        this.orcTail = orcTail;
        this.hasFooter = this.orcTail != null;
        this.isOriginal = isOriginal;
        this.hasBase = hasBase;
        this.deltas.addAll(deltas);
        this.projColsUncompressedSize = projectedDataSize <= 0L ? length : projectedDataSize;
        this.fileLen = fileLen <= 0L ? Long.MAX_VALUE : fileLen;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        int flags = (this.hasBase ? 4 : 0) | (this.isOriginal ? 2 : 0) | (this.hasFooter ? 1 : 0);
        out.writeByte(flags);
        out.writeInt(this.deltas.size());
        for (AcidInputFormat.DeltaMetaData delta : this.deltas) {
            delta.write(out);
        }
        if (this.hasFooter) {
            OrcProto.FileTail fileTail = this.orcTail.getMinimalFileTail();
            byte[] tailBuffer = fileTail.toByteArray();
            int tailLen = tailBuffer.length;
            WritableUtils.writeVInt((DataOutput)out, (int)tailLen);
            out.write(tailBuffer);
        }
        out.writeLong(this.fileLen);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte flags = in.readByte();
        this.hasFooter = (1 & flags) != 0;
        this.isOriginal = (2 & flags) != 0;
        this.hasBase = (4 & flags) != 0;
        this.deltas.clear();
        int numDeltas = in.readInt();
        for (int i = 0; i < numDeltas; ++i) {
            AcidInputFormat.DeltaMetaData dmd = new AcidInputFormat.DeltaMetaData();
            dmd.readFields(in);
            this.deltas.add(dmd);
        }
        if (this.hasFooter) {
            int tailLen = WritableUtils.readVInt((DataInput)in);
            byte[] tailBuffer = new byte[tailLen];
            in.readFully(tailBuffer);
            OrcProto.FileTail fileTail = OrcProto.FileTail.parseFrom(tailBuffer);
            this.orcTail = new OrcTail(fileTail, null);
        }
        this.fileLen = in.readLong();
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public List<AcidInputFormat.DeltaMetaData> getDeltas() {
        return this.deltas;
    }

    @Override
    public long getColumnarProjectionSize() {
        return this.projColsUncompressedSize;
    }

    public long getFileLength() {
        return this.fileLen;
    }

    public OrcTail getOrcTail() {
        return this.orcTail;
    }

    public String toString() {
        return "OrcSplit [" + this.getPath() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", isOriginal=" + this.isOriginal + ", fileLength=" + this.fileLen + ", hasFooter=" + this.hasFooter + ", hasBase=" + this.hasBase + ", deltas=" + (this.deltas == null ? 0 : this.deltas.size()) + "]";
    }
}

