/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;

public class MetadataReader {
    private final FSDataInputStream file;
    private final CompressionCodec codec;
    private final int bufferSize;
    private final int typeCount;

    public MetadataReader(FileSystem fileSystem, Path path, CompressionCodec codec, int bufferSize, int typeCount) throws IOException {
        this(fileSystem.open(path), codec, bufferSize, typeCount);
    }

    public MetadataReader(FSDataInputStream file, CompressionCodec codec, int bufferSize, int typeCount) {
        this.file = file;
        this.codec = codec;
        this.bufferSize = bufferSize;
        this.typeCount = typeCount;
    }

    public RecordReaderImpl.Index readRowIndex(StripeInformation stripe, OrcProto.StripeFooter footer, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
        if (footer == null) {
            footer = this.readStripeFooter(stripe);
        }
        if (indexes == null) {
            indexes = new OrcProto.RowIndex[this.typeCount];
        }
        if (bloomFilterIndices == null) {
            bloomFilterIndices = new OrcProto.BloomFilterIndex[this.typeCount];
        }
        long offset = stripe.getOffset();
        List<OrcProto.Stream> streams = footer.getStreamsList();
        for (int i = 0; i < streams.size(); ++i) {
            OrcProto.Stream stream = streams.get(i);
            OrcProto.Stream nextStream = null;
            if (i < streams.size() - 1) {
                nextStream = streams.get(i + 1);
            }
            int col = stream.getColumn();
            int len = (int)stream.getLength();
            if (stream.hasKind() && stream.getKind() == OrcProto.Stream.Kind.ROW_INDEX) {
                boolean readBloomFilter = false;
                if (sargColumns != null && sargColumns[col] && nextStream.getKind() == OrcProto.Stream.Kind.BLOOM_FILTER) {
                    len = (int)((long)len + nextStream.getLength());
                    ++i;
                    readBloomFilter = true;
                }
                if ((included == null || included[col]) && indexes[col] == null) {
                    byte[] buffer = new byte[len];
                    this.file.readFully(offset, buffer, 0, buffer.length);
                    ByteBuffer[] bb = new ByteBuffer[]{ByteBuffer.wrap(buffer)};
                    indexes[col] = OrcProto.RowIndex.parseFrom(InStream.create("index", bb, new long[]{0L}, stream.getLength(), this.codec, this.bufferSize));
                    if (readBloomFilter) {
                        bb[0].position((int)stream.getLength());
                        bloomFilterIndices[col] = OrcProto.BloomFilterIndex.parseFrom(InStream.create("bloom_filter", bb, new long[]{0L}, nextStream.getLength(), this.codec, this.bufferSize));
                    }
                }
            }
            offset += (long)len;
        }
        RecordReaderImpl.Index index = new RecordReaderImpl.Index(indexes, bloomFilterIndices);
        return index;
    }

    public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int tailLength = (int)stripe.getFooterLength();
        ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
        this.file.readFully(offset, tailBuf.array(), tailBuf.arrayOffset(), tailLength);
        return OrcProto.StripeFooter.parseFrom(InStream.createCodedInputStream("footer", Lists.newArrayList(new RecordReaderImpl.BufferChunk(tailBuf, 0L)), tailLength, this.codec, this.bufferSize));
    }

    public void close() throws IOException {
        this.file.close();
    }
}

