/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;

public final class TimestampUtils {
    static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    static final long NANOSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);

    public static long daysToNanoseconds(long daysSinceEpoch) {
        return DateWritable.daysToMillis((int)daysSinceEpoch) * NANOSECONDS_PER_MILLISECOND;
    }

    public static TimestampWritable timestampColumnVectorWritable(TimestampColumnVector timestampColVector, int elementNum, TimestampWritable timestampWritable) {
        timestampWritable.set(timestampColVector.asScratchTimestamp(elementNum));
        return timestampWritable;
    }

    public static HiveIntervalDayTimeWritable intervalDayTimeColumnVectorWritable(IntervalDayTimeColumnVector intervalDayTimeColVector, int elementNum, HiveIntervalDayTimeWritable intervalDayTimeWritable) {
        intervalDayTimeWritable.set(intervalDayTimeColVector.asScratchIntervalDayTime(elementNum));
        return intervalDayTimeWritable;
    }
}

