/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.jaas;

import java.security.Principal;
import org.springframework.security.core.GrantedAuthority;

public final class JaasGrantedAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 310L;
    private final String role;
    private final Principal principal;

    public JaasGrantedAuthority(String role, Principal principal) {
        this.role = role;
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getAuthority() {
        return this.role;
    }

    public int hashCode() {
        return 0x1F ^ this.principal.hashCode() ^ this.role.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JaasGrantedAuthority) {
            JaasGrantedAuthority jga = (JaasGrantedAuthority)obj;
            return this.role.equals(jga.role) && this.principal.equals(jga.principal);
        }
        return false;
    }

    public String toString() {
        return "Jaas Authority [" + this.role + "," + this.principal + "]";
    }
}

