/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ValueQueue<E> {
    private static final String REFILL_THREAD = ValueQueue.class.getName() + "_thread";
    private static final int LOCK_ARRAY_SIZE = 16;
    private static final int MASK = 15;
    private final LoadingCache<String, LinkedBlockingQueue<E>> keyQueues;
    private final List<ReadWriteLock> lockArray = new ArrayList<ReadWriteLock>(16);
    private final ThreadPoolExecutor executor;
    private final UniqueKeyBlockingQueue queue = new UniqueKeyBlockingQueue();
    private final QueueRefiller<E> refiller;
    private final SyncGenerationPolicy policy;
    private final int numValues;
    private final float lowWatermark;
    private volatile boolean executorThreadsStarted = false;

    private void readLock(String keyName) {
        this.getLock(keyName).readLock().lock();
    }

    private void readUnlock(String keyName) {
        this.getLock(keyName).readLock().unlock();
    }

    private void writeUnlock(String keyName) {
        this.getLock(keyName).writeLock().unlock();
    }

    private void writeLock(String keyName) {
        this.getLock(keyName).writeLock().lock();
    }

    private ReadWriteLock getLock(String keyName) {
        return this.lockArray.get(ValueQueue.indexFor(keyName));
    }

    private static int indexFor(String keyName) {
        return keyName.hashCode() & 0xF;
    }

    public ValueQueue(int numValues, float lowWatermark, long expiry, int numFillerThreads, SyncGenerationPolicy policy, final QueueRefiller<E> refiller) {
        Preconditions.checkArgument((numValues > 0 ? 1 : 0) != 0, (Object)"\"numValues\" must be > 0");
        Preconditions.checkArgument((lowWatermark > 0.0f && lowWatermark <= 1.0f ? 1 : 0) != 0, (Object)"\"lowWatermark\" must be > 0 and <= 1");
        final int watermarkValue = (int)((float)numValues * lowWatermark);
        Preconditions.checkArgument((watermarkValue > 0 ? 1 : 0) != 0, (Object)"(int) (\"numValues\" * \"lowWatermark\") must be > 0");
        Preconditions.checkArgument((expiry > 0L ? 1 : 0) != 0, (Object)"\"expiry\" must be > 0");
        Preconditions.checkArgument((numFillerThreads > 0 ? 1 : 0) != 0, (Object)"\"numFillerThreads\" must be > 0");
        Preconditions.checkNotNull((Object)((Object)policy), (Object)"\"policy\" must not be null");
        this.refiller = refiller;
        this.policy = policy;
        this.numValues = numValues;
        this.lowWatermark = lowWatermark;
        for (int i = 0; i < 16; ++i) {
            this.lockArray.add(i, new ReentrantReadWriteLock());
        }
        this.keyQueues = CacheBuilder.newBuilder().expireAfterAccess(expiry, TimeUnit.MILLISECONDS).build(new CacheLoader<String, LinkedBlockingQueue<E>>(){

            public LinkedBlockingQueue<E> load(String keyName) throws Exception {
                LinkedBlockingQueue keyQueue = new LinkedBlockingQueue();
                refiller.fillQueueForKey(keyName, keyQueue, watermarkValue);
                return keyQueue;
            }
        });
        this.executor = new ThreadPoolExecutor(numFillerThreads, numFillerThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.queue, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(REFILL_THREAD).build());
    }

    public ValueQueue(int numValues, float lowWaterMark, long expiry, int numFillerThreads, QueueRefiller<E> fetcher) {
        this(numValues, lowWaterMark, expiry, numFillerThreads, SyncGenerationPolicy.ALL, fetcher);
    }

    public void initializeQueuesForKeys(String ... keyNames) throws ExecutionException {
        for (String keyName : keyNames) {
            this.keyQueues.get((Object)keyName);
        }
    }

    public E getNext(String keyName) throws IOException, ExecutionException {
        return this.getAtMost(keyName, 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain(String keyName) {
        try {
            Runnable e;
            while ((e = this.queue.deleteByName(keyName)) != null) {
                this.executor.remove(e);
            }
            this.writeLock(keyName);
            try {
                ((LinkedBlockingQueue)this.keyQueues.get((Object)keyName)).clear();
            }
            finally {
                this.writeUnlock(keyName);
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(String keyName) {
        this.readLock(keyName);
        try {
            ImmutableMap map = this.keyQueues.getAllPresent(Arrays.asList(keyName));
            if (map.get(keyName) == null) {
                int n = 0;
                return n;
            }
            int n = ((LinkedBlockingQueue)map.get(keyName)).size();
            return n;
        }
        finally {
            this.readUnlock(keyName);
        }
    }

    public List<E> getAtMost(String keyName, int num) throws IOException, ExecutionException {
        LinkedBlockingQueue keyQueue = (LinkedBlockingQueue)this.keyQueues.get((Object)keyName);
        LinkedList ekvs = new LinkedList();
        try {
            for (int i = 0; i < num; ++i) {
                this.readLock(keyName);
                Object val = keyQueue.poll();
                this.readUnlock(keyName);
                if (val == null) {
                    int numToFill = 0;
                    switch (this.policy) {
                        case ATLEAST_ONE: {
                            numToFill = ekvs.size() < 1 ? 1 : 0;
                            break;
                        }
                        case LOW_WATERMARK: {
                            numToFill = Math.min(num, (int)(this.lowWatermark * (float)this.numValues)) - ekvs.size();
                            break;
                        }
                        case ALL: {
                            numToFill = num - ekvs.size();
                        }
                    }
                    if (numToFill > 0) {
                        this.refiller.fillQueueForKey(keyName, ekvs, numToFill);
                    }
                    if (i <= (int)(this.lowWatermark * (float)this.numValues)) {
                        this.submitRefillTask(keyName, keyQueue);
                    }
                    return ekvs;
                }
                ekvs.add(val);
            }
        }
        catch (Exception e) {
            throw new IOException("Exeption while contacting value generator ", e);
        }
        return ekvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRefillTask(final String keyName, final Queue<E> keyQueue) throws InterruptedException {
        if (!this.executorThreadsStarted) {
            ValueQueue valueQueue = this;
            synchronized (valueQueue) {
                this.executor.prestartAllCoreThreads();
                this.executorThreadsStarted = true;
            }
        }
        this.queue.put(new NamedRunnable(keyName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int cacheSize = ValueQueue.this.numValues;
                int threshold = (int)(ValueQueue.this.lowWatermark * (float)cacheSize);
                try {
                    ValueQueue.this.writeLock(keyName);
                    try {
                        if (keyQueue.size() < threshold && !this.isCanceled()) {
                            ValueQueue.this.refiller.fillQueueForKey(this.name, keyQueue, cacheSize - keyQueue.size());
                        }
                        if (this.isCanceled()) {
                            keyQueue.clear();
                        }
                    }
                    finally {
                        ValueQueue.this.writeUnlock(keyName);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    public static enum SyncGenerationPolicy {
        ATLEAST_ONE,
        LOW_WATERMARK,
        ALL;

    }

    private static class UniqueKeyBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = -2152747693695890371L;
        private HashMap<String, Runnable> keysInProgress = new HashMap();

        private UniqueKeyBlockingQueue() {
        }

        @Override
        public synchronized void put(Runnable e) throws InterruptedException {
            if (!this.keysInProgress.containsKey(((NamedRunnable)e).name)) {
                this.keysInProgress.put(((NamedRunnable)e).name, e);
                super.put(e);
            }
        }

        @Override
        public Runnable take() throws InterruptedException {
            Runnable k = (Runnable)super.take();
            if (k != null) {
                this.keysInProgress.remove(((NamedRunnable)k).name);
            }
            return k;
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            Runnable k = (Runnable)super.poll(timeout, unit);
            if (k != null) {
                this.keysInProgress.remove(((NamedRunnable)k).name);
            }
            return k;
        }

        public Runnable deleteByName(String name) {
            NamedRunnable e = (NamedRunnable)this.keysInProgress.remove(name);
            if (e != null) {
                e.cancel();
                super.remove(e);
            }
            return e;
        }
    }

    private static abstract class NamedRunnable
    implements Runnable {
        final String name;
        private AtomicBoolean canceled = new AtomicBoolean(false);

        private NamedRunnable(String keyName) {
            this.name = keyName;
        }

        public void cancel() {
            this.canceled.set(true);
        }

        public boolean isCanceled() {
            return this.canceled.get();
        }
    }

    public static interface QueueRefiller<E> {
        public void fillQueueForKey(String var1, Queue<E> var2, int var3) throws IOException;
    }
}

