/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.logical.expression.LogicalExpression;

public class LogicalSchema
implements Serializable {
    private List<LogicalFieldSchema> fields = new ArrayList<LogicalFieldSchema>();

    public void resetUid() {
        for (LogicalFieldSchema fs : this.fields) {
            fs.resetUid();
        }
    }

    public static boolean castable(LogicalSchema inSch, LogicalSchema outSch) {
        if (outSch == null && inSch == null) {
            return false;
        }
        if (outSch == null) {
            return false;
        }
        if (inSch == null) {
            return true;
        }
        if (outSch.size() > inSch.size()) {
            return false;
        }
        Iterator<LogicalFieldSchema> i = outSch.fields.iterator();
        Iterator<LogicalFieldSchema> j = inSch.fields.iterator();
        while (i.hasNext()) {
            LogicalFieldSchema outFs = i.next();
            LogicalFieldSchema inFs = j.next();
            if (LogicalFieldSchema.castable(inFs, outFs)) continue;
            return false;
        }
        return true;
    }

    public void addField(LogicalFieldSchema field) {
        this.fields.add(field);
    }

    public LogicalFieldSchema getField(String alias) throws FrontendException {
        LogicalFieldSchema result = null;
        for (LogicalFieldSchema fs : this.fields) {
            if (fs.alias == null || !fs.alias.equals(alias)) continue;
            if (result == null) {
                result = fs;
                continue;
            }
            StringBuilder sb = new StringBuilder("Found more than one match: " + result.alias + ", " + fs.alias);
            throw new FrontendException(sb.toString(), 1025);
        }
        if (result != null) {
            return result;
        }
        for (LogicalFieldSchema fs : this.fields) {
            if (fs.alias == null || !fs.alias.matches(".*::" + alias + "$")) continue;
            if (result == null) {
                result = fs;
                continue;
            }
            StringBuilder sb = new StringBuilder("Found more than one match: " + result.alias + ", " + fs.alias);
            throw new FrontendException(sb.toString(), 1025);
        }
        return result;
    }

    public LogicalFieldSchema getFieldSubNameMatch(String alias) throws FrontendException {
        if (alias == null) {
            return null;
        }
        LogicalFieldSchema fs = this.getField(alias);
        if (fs != null) {
            return fs;
        }
        String sep = "::";
        ArrayList<LogicalFieldSchema> matchedFieldSchemas = new ArrayList<LogicalFieldSchema>();
        if (alias.contains("::")) {
            for (LogicalFieldSchema field : this.fields) {
                if (!alias.endsWith("::" + field.alias)) continue;
                matchedFieldSchemas.add(field);
            }
        }
        if (matchedFieldSchemas.size() > 1) {
            boolean hasNext = false;
            StringBuilder sb = new StringBuilder("Found more than one sub alias name match: ");
            for (LogicalFieldSchema matchFs : matchedFieldSchemas) {
                if (hasNext) {
                    sb.append(", ");
                } else {
                    hasNext = true;
                }
                sb.append(matchFs.alias);
            }
            int errCode = 1116;
            throw new FrontendException(sb.toString(), errCode, 2);
        }
        if (matchedFieldSchemas.size() == 1) {
            fs = (LogicalFieldSchema)matchedFieldSchemas.get(0);
        }
        return fs;
    }

    public int getFieldPosition(String alias) {
        LogicalFieldSchema fs = null;
        try {
            fs = this.getField(alias);
        }
        catch (FrontendException frontendException) {
            // empty catch block
        }
        if (fs == null) {
            return -1;
        }
        return this.fields.indexOf(fs);
    }

    public LogicalFieldSchema getField(int fieldNum) {
        return this.fields.get(fieldNum);
    }

    public List<LogicalFieldSchema> getFields() {
        return this.fields;
    }

    public int size() {
        return this.fields.size();
    }

    public boolean isEqual(Object other) {
        return this.isEqual(other, false);
    }

    public boolean isEqual(Object other, boolean compareAlias) {
        if (other != null && other instanceof LogicalSchema) {
            LogicalSchema os = (LogicalSchema)other;
            if (this.size() != os.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getField(i).isEqual(os.getField(i), compareAlias)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int findField(long uid) {
        for (int i = 0; i < this.size(); ++i) {
            LogicalFieldSchema f = this.getField(i);
            if (f.uid == uid) {
                return i;
            }
            if (f.schema == null || f.schema.findField(uid) == -1) continue;
            return i;
        }
        return -1;
    }

    public static LogicalSchema merge(LogicalSchema s1, LogicalSchema s2, MergeMode mode) throws FrontendException {
        if (s1 == null || s2 == null) {
            if (mode == MergeMode.LoadForEach || mode == MergeMode.LoadForEachInner) {
                if (s1 != null) {
                    return s1.deepCopy();
                }
                if (s2 != null) {
                    return s2.deepCopy();
                }
                return null;
            }
            return null;
        }
        if (s1.size() != s2.size()) {
            if (mode == MergeMode.Union) {
                return null;
            }
            throw new FrontendException("Incompatable schema: left is \"" + s1.toString(false) + "\", right is \"" + s2.toString(false) + "\"", 1031);
        }
        LogicalSchema mergedSchema = new LogicalSchema();
        for (int i = 0; i < s1.size(); ++i) {
            LogicalFieldSchema fs1 = s1.getField(i);
            LogicalFieldSchema fs2 = s2.getField(i);
            LogicalFieldSchema mergedFS = LogicalFieldSchema.merge(fs1, fs2, mode);
            mergedSchema.addField(mergedFS);
        }
        return mergedSchema;
    }

    public String toString(boolean verbose) {
        StringBuilder str = new StringBuilder();
        for (LogicalFieldSchema field : this.fields) {
            str.append(field.toString(verbose) + ",");
        }
        if (this.fields.size() != 0) {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public LogicalSchema mergeUid(LogicalSchema uidOnlySchema) throws FrontendException {
        if (uidOnlySchema != null) {
            if (this.size() != uidOnlySchema.size()) {
                throw new FrontendException("Structure of schema change. Original: " + uidOnlySchema + " Now: " + this, 2239);
            }
            for (int i = 0; i < this.size(); ++i) {
                this.getField(i).mergeUid(uidOnlySchema.getField(i));
            }
            return uidOnlySchema;
        }
        LogicalSchema clonedUidOnlyCopy = new LogicalSchema();
        for (int i = 0; i < this.size(); ++i) {
            this.getField(i).stampFieldSchema();
            clonedUidOnlyCopy.addField(this.getField(i).cloneUid());
        }
        return clonedUidOnlyCopy;
    }

    public LogicalSchema deepCopy() {
        LogicalSchema newSchema = new LogicalSchema();
        for (int i = 0; i < this.size(); ++i) {
            newSchema.addField(this.getField(i).deepCopy());
        }
        return newSchema;
    }

    public static LogicalSchema mergeSchemasByAlias(List<LogicalSchema> schemas) throws FrontendException {
        LogicalSchema mergedSchema = null;
        ArrayList<LogicalSchema> mergedSchemas = new ArrayList<LogicalSchema>(schemas.size());
        for (LogicalSchema sch : schemas) {
            if (mergedSchema == null) {
                mergedSchema = sch.deepCopy();
                mergedSchemas.add(sch);
                continue;
            }
            try {
                mergedSchema = LogicalSchema.mergeSchemaByAlias(mergedSchema, sch);
                mergedSchemas.add(sch);
            }
            catch (FrontendException e) {
                String msg = "Error merging schema: (" + sch + ") with " + "merged schema: (" + mergedSchema + ")" + " of schemas : " + mergedSchemas;
                throw new FrontendException(msg, e);
            }
        }
        return mergedSchema;
    }

    public static LogicalSchema mergeSchemaByAlias(LogicalSchema schema1, LogicalSchema schema2) throws FrontendException {
        LogicalSchema mergedSchema = new LogicalSchema();
        HashSet<LogicalFieldSchema> schema2colsAdded = new HashSet<LogicalFieldSchema>();
        for (LogicalFieldSchema fs1 : schema1.getFields()) {
            LogicalSchema.checkNullAlias(fs1, schema1);
            LogicalFieldSchema fs2 = schema2.getFieldSubNameMatch(fs1.alias);
            if (fs2 != null) {
                if (schema2colsAdded.contains(fs2)) {
                    schema1.getFieldSubNameMatch(fs2.alias);
                }
                schema2colsAdded.add(fs2);
                LogicalFieldSchema mergedFs = LogicalFieldSchema.merge(fs1, fs2, MergeMode.Union);
                mergedFs.alias = LogicalSchema.mergeNameSpacedAlias(fs1.alias, fs2.alias);
                if (mergedFs.alias == null) {
                    mergedFs.alias = fs1.alias;
                }
                mergedSchema.addField(mergedFs);
                continue;
            }
            mergedSchema.addField(new LogicalFieldSchema(fs1));
        }
        for (LogicalFieldSchema fs2 : schema2.getFields()) {
            LogicalSchema.checkNullAlias(fs2, schema2);
            if (schema2colsAdded.contains(fs2)) continue;
            mergedSchema.addField(new LogicalFieldSchema(fs2));
        }
        return mergedSchema;
    }

    private static void checkNullAlias(LogicalFieldSchema fs, LogicalSchema schema) throws FrontendException {
        if (fs.alias == null) {
            throw new FrontendException("Schema having field with null alias cannot be merged using alias. Schema :" + schema);
        }
    }

    private static String mergeNameSpacedAlias(String alias1, String alias2) throws FrontendException {
        if (alias1.equals(alias2)) {
            return alias1;
        }
        if (alias1.endsWith("::" + alias2)) {
            return alias2;
        }
        if (alias2.endsWith("::" + alias1)) {
            return alias1;
        }
        return null;
    }

    public static boolean equals(LogicalSchema schema, LogicalSchema other, boolean relaxInner, boolean relaxAlias) {
        if (schema == null && other == null) {
            return true;
        }
        if (schema == null || other == null) {
            return false;
        }
        if (schema.size() != other.size()) {
            return false;
        }
        Iterator<LogicalFieldSchema> i = schema.fields.iterator();
        Iterator<LogicalFieldSchema> j = other.fields.iterator();
        while (i.hasNext()) {
            LogicalFieldSchema myFs = i.next();
            LogicalFieldSchema otherFs = j.next();
            if (!(relaxAlias || myFs.alias == null && otherFs.alias == null)) {
                if (myFs.alias == null) {
                    return false;
                }
                if (!myFs.alias.equals(otherFs.alias)) {
                    return false;
                }
            }
            if (myFs.type != otherFs.type) {
                return false;
            }
            if (relaxInner || LogicalFieldSchema.equals(myFs, otherFs, false, relaxAlias)) continue;
            return false;
        }
        return true;
    }

    public void normalize() {
        for (LogicalFieldSchema fs : this.getFields()) {
            fs.normalize();
        }
    }

    public static enum MergeMode {
        LoadForEach,
        LoadForEachInner,
        Union,
        UnionInner;

    }

    public static class LogicalFieldSchema
    implements Serializable {
        public String alias;
        public byte type;
        public long uid;
        public LogicalSchema schema;

        public LogicalFieldSchema(String alias, LogicalSchema schema, byte type) {
            this(alias, schema, type, -1L);
        }

        public LogicalFieldSchema(LogicalFieldSchema fs) {
            this(fs.alias, fs.schema, fs.type, fs.uid);
        }

        public LogicalFieldSchema(String alias, LogicalSchema schema, byte type, long uid) {
            this.alias = alias;
            this.type = type;
            this.schema = schema;
            this.uid = uid;
        }

        public boolean isEqual(Object other) {
            return this.isEqual(other, false);
        }

        public boolean isEqual(Object other, boolean compareAlias) {
            if (other instanceof LogicalFieldSchema) {
                LogicalFieldSchema ofs = (LogicalFieldSchema)other;
                if (compareAlias && this.alias != null && !this.alias.equals(ofs.alias)) {
                    return false;
                }
                if (this.type != ofs.type) {
                    return false;
                }
                if (this.schema == null && ofs.schema == null) {
                    return true;
                }
                if (this.schema == null) {
                    return false;
                }
                return this.schema.isEqual(ofs.schema, compareAlias);
            }
            return false;
        }

        public String toString(boolean verbose) {
            String uidString = "";
            if (verbose) {
                uidString = "#" + this.uid;
            }
            String aliasToPrint = "";
            if (this.alias != null) {
                aliasToPrint = this.alias;
            }
            if (this.type == 120) {
                if (this.schema == null) {
                    return aliasToPrint + uidString + ":bag{}";
                }
                return aliasToPrint + uidString + ":bag{" + this.schema.toString(verbose) + "}";
            }
            if (this.type == 110) {
                if (this.schema == null) {
                    return aliasToPrint + uidString + ":tuple()";
                }
                return aliasToPrint + uidString + ":tuple(" + this.schema.toString(verbose) + ")";
            }
            if (this.type == 100) {
                if (this.schema == null) {
                    return aliasToPrint + uidString + ":map";
                }
                return aliasToPrint + uidString + ":map(" + this.schema.toString(verbose) + ")";
            }
            return aliasToPrint + uidString + ":" + DataType.findTypeName(this.type);
        }

        public String toString() {
            return this.toString(true);
        }

        public void stampFieldSchema() {
            if (this.uid == -1L) {
                this.uid = LogicalExpression.getNextUid();
            }
            if (this.schema != null) {
                for (LogicalFieldSchema fs : this.schema.getFields()) {
                    fs.stampFieldSchema();
                }
            }
        }

        private boolean compatible(LogicalFieldSchema uidOnlyFieldSchema) {
            if (uidOnlyFieldSchema == null) {
                return false;
            }
            if (this.schema == null && uidOnlyFieldSchema.schema != null || this.schema != null && uidOnlyFieldSchema.schema == null) {
                return false;
            }
            if (this.schema != null) {
                if (this.schema.size() != uidOnlyFieldSchema.schema.size()) {
                    return false;
                }
                for (int i = 0; i < this.schema.size(); ++i) {
                    boolean comp = this.schema.getField(i).compatible(uidOnlyFieldSchema.schema.getField(i));
                    if (comp) continue;
                    return false;
                }
            }
            return true;
        }

        public LogicalFieldSchema mergeUid(LogicalFieldSchema uidOnlyFieldSchema) throws FrontendException {
            if (uidOnlyFieldSchema != null && this.compatible(uidOnlyFieldSchema)) {
                this.uid = uidOnlyFieldSchema.uid;
                if (this.schema != null) {
                    for (int i = 0; i < this.schema.size(); ++i) {
                        this.schema.getField(i).mergeUid(uidOnlyFieldSchema.schema.getField(i));
                    }
                }
                return uidOnlyFieldSchema;
            }
            if (uidOnlyFieldSchema == null) {
                this.stampFieldSchema();
            } else {
                this.uid = uidOnlyFieldSchema.uid;
                if (this.schema != null) {
                    for (int i = 0; i < this.schema.size(); ++i) {
                        this.schema.getField(i).stampFieldSchema();
                    }
                }
            }
            LogicalFieldSchema clonedUidOnlyCopy = this.cloneUid();
            return clonedUidOnlyCopy;
        }

        public void resetUid() {
            this.uid = -1L;
            if (this.schema != null) {
                this.schema.resetUid();
            }
        }

        public LogicalFieldSchema cloneUid() {
            LogicalFieldSchema resultFs = null;
            if (this.schema == null) {
                resultFs = new LogicalFieldSchema(null, null, this.type, this.uid);
            } else {
                LogicalSchema newSchema = new LogicalSchema();
                resultFs = new LogicalFieldSchema(null, newSchema, this.type, this.uid);
                for (int i = 0; i < this.schema.size(); ++i) {
                    LogicalFieldSchema fs = this.schema.getField(i).cloneUid();
                    newSchema.addField(fs);
                }
            }
            return resultFs;
        }

        public LogicalFieldSchema deepCopy() {
            LogicalFieldSchema newFs = new LogicalFieldSchema(this.alias != null ? this.alias : null, this.schema != null ? this.schema.deepCopy() : null, this.type, this.uid);
            return newFs;
        }

        public static boolean equals(LogicalFieldSchema fschema, LogicalFieldSchema fother, boolean relaxInner, boolean relaxAlias) {
            if (fschema == null || fother == null) {
                return false;
            }
            if (fschema.type != fother.type) {
                return false;
            }
            if (!(relaxAlias || fschema.alias == null && fother.alias == null)) {
                if (fschema.alias == null) {
                    return false;
                }
                if (!fschema.alias.equals(fother.alias)) {
                    return false;
                }
            }
            return relaxInner || !DataType.isSchemaType(fschema.type) || fschema.schema == null && fother.schema == null || LogicalSchema.equals(fschema.schema, fother.schema, false, relaxAlias);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean castable(LogicalFieldSchema inFs, LogicalFieldSchema outFs) {
            if (outFs == null && inFs == null) {
                return false;
            }
            if (outFs == null) {
                return false;
            }
            if (inFs == null) {
                return false;
            }
            byte inType = inFs.type;
            byte outType = outFs.type;
            if (DataType.isSchemaType(outFs.type)) {
                if (inType == 50) return true;
                if (inType != outType) return false;
                if (inFs.schema == null || inFs.schema.size() == 0 || outFs.schema == null && inFs.schema == null || LogicalSchema.castable(inFs.schema, outFs.schema)) return true;
                return false;
            }
            if (inType == outType || inType == 5 && (outType == 55 || outType == 50 || DataType.isNumberType(outType)) || DataType.isNumberType(inType) && (outType == 55 || outType == 50 || DataType.isNumberType(outType)) || outType == 5 || inType == 55 && (outType == 50 || DataType.isNumberType(outType)) || outType == 5 || inType == 50) return true;
            return false;
        }

        public static LogicalFieldSchema merge(LogicalFieldSchema fs1, LogicalFieldSchema fs2, MergeMode mode) throws FrontendException {
            String mergedAlias;
            LogicalSchema mergedSubSchema;
            int mergedType;
            block44: {
                if (mode == MergeMode.LoadForEach) {
                    if (fs1 == null) {
                        throw new FrontendException("We cannot cast into null", 1031);
                    }
                    if (fs2 == null) {
                        return fs1.deepCopy();
                    }
                } else if (mode == MergeMode.LoadForEachInner) {
                    if (fs1 == null) {
                        return null;
                    }
                    if (fs2 == null) {
                        return fs1.deepCopy();
                    }
                } else if (fs1 == null || fs2 == null) {
                    return null;
                }
                mergedType = 0;
                mergedSubSchema = null;
                if (mode == MergeMode.UnionInner) {
                    if (fs1.type != fs2.type) {
                        throw new FrontendException("Incompatable field schema: left is \"" + fs1.toString(false) + "\", right is \"" + fs2.toString(false) + "\"", 1031);
                    }
                    mergedType = fs1.type;
                } else if (mode == MergeMode.LoadForEach || mode == MergeMode.LoadForEachInner) {
                    if (fs1.type == 1 || fs1.type == 50) {
                        mergedType = fs2.type;
                    } else {
                        if (!DataType.castable(fs1.type, fs2.type)) {
                            throw new FrontendException("Incompatable field schema: declared is \"" + fs1.toString(false) + "\", infered is \"" + fs2.toString(false) + "\"", 1031);
                        }
                        mergedType = fs1.type;
                    }
                } else if (fs1.type == 50) {
                    mergedType = fs2.type;
                } else if (fs2.type == 50) {
                    mergedType = fs1.type;
                } else {
                    mergedType = DataType.mergeType(fs1.type, fs2.type);
                    if (mergedType == -1) {
                        mergedType = 50;
                    }
                }
                if (fs1.alias == null) {
                    mergedAlias = fs2.alias;
                } else if (fs2.alias == null) {
                    mergedAlias = fs1.alias;
                } else {
                    mergedAlias = LogicalSchema.mergeNameSpacedAlias(fs1.alias, fs2.alias);
                    if (mergedAlias == null) {
                        mergedAlias = fs1.alias;
                    }
                }
                if (DataType.isSchemaType((byte)mergedType)) {
                    if (mode == MergeMode.Union) {
                        try {
                            if (fs1.type == 50) {
                                if (fs2.schema != null) {
                                    mergedSubSchema = fs2.schema.deepCopy();
                                }
                                break block44;
                            }
                            if (fs2.type == 50) {
                                if (fs1.schema != null) {
                                    mergedSubSchema = fs1.schema.deepCopy();
                                }
                                break block44;
                            }
                            mergedSubSchema = LogicalSchema.merge(fs1.schema, fs2.schema, MergeMode.UnionInner);
                        }
                        catch (FrontendException e) {
                            if (fs1.type == 120 && fs2.type == 120) {
                                mergedSubSchema = new LogicalSchema();
                                mergedSubSchema.addField(new LogicalFieldSchema(null, new LogicalSchema(), 110));
                            } else if (fs1.type == 110 && fs2.type == 110) {
                                mergedSubSchema = new LogicalSchema();
                            }
                            break block44;
                        }
                    }
                    if (mode == MergeMode.UnionInner) {
                        mergedSubSchema = LogicalSchema.merge(fs1.schema, fs2.schema, MergeMode.UnionInner);
                    } else if (fs1.type == 50) {
                        mergedSubSchema = fs2.schema;
                    } else {
                        try {
                            mergedSubSchema = LogicalSchema.merge(fs1.schema, fs2.schema, MergeMode.LoadForEachInner);
                        }
                        catch (FrontendException e) {
                            throw new FrontendException("Incompatable field schema: left is \"" + fs1.toString(false) + "\", right is \"" + fs2.toString(false) + "\"", 1031);
                        }
                    }
                }
            }
            LogicalFieldSchema mergedFS = new LogicalFieldSchema(mergedAlias, mergedSubSchema, (byte)mergedType);
            return mergedFS;
        }

        public void normalize() {
            if (this.type == 120 && this.schema != null && (this.schema.size() != 1 || this.schema.getField((int)0).type != 110)) {
                LogicalSchema tupleSchema = new LogicalSchema();
                for (LogicalFieldSchema innerFs : this.schema.getFields()) {
                    tupleSchema.addField(innerFs);
                }
                this.schema = new LogicalSchema();
                this.schema.addField(new LogicalFieldSchema(null, tupleSchema, 110));
            }
            if (this.schema != null) {
                for (LogicalFieldSchema fs : this.schema.getFields()) {
                    fs.normalize();
                }
            }
        }
    }
}

