/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigCounters;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.SelfSpillBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class InternalCachedBag
extends SelfSpillBag {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(InternalCachedBag.class);
    private transient DataOutputStream out;
    private transient boolean addDone;
    private transient TupleFactory factory;
    private transient int numTuplesSpilled = 0;
    private static final InterSedes SEDES = InterSedesFactory.getInterSedesInstance();

    public InternalCachedBag() {
        this(1, -1.0f);
    }

    public InternalCachedBag(int bagCount) {
        this(bagCount, -1.0f);
    }

    public InternalCachedBag(int bagCount, float percent) {
        super(bagCount, percent);
        this.init();
    }

    private void init() {
        this.factory = TupleFactory.getInstance();
        this.mContents = new ArrayList();
        this.addDone = false;
    }

    @Override
    public void add(Tuple t) {
        if (this.addDone) {
            throw new IllegalStateException("InternalCachedBag is closed for adding new tuples");
        }
        if (this.mContents.size() < this.memLimit.getCacheLimit()) {
            this.mContents.add(t);
            if (this.mContents.size() < 100) {
                this.memLimit.addNewObjSize(t.getMemorySize());
            }
        } else {
            try {
                if (this.out == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Memory can hold " + this.mContents.size() + " records, put the rest in spill file."));
                    }
                    this.out = this.getSpillFile();
                    this.incSpillCount(PigCounters.PROACTIVE_SPILL_COUNT_BAGS);
                }
                SEDES.writeDatum(this.out, t, (byte)110);
                ++this.numTuplesSpilled;
                if (this.numTuplesSpilled > 1000) {
                    this.updateSpillRecCounter();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ++this.mSize;
    }

    private void updateSpillRecCounter() {
        this.incSpillCount(PigCounters.PROACTIVE_SPILL_COUNT_RECS, this.numTuplesSpilled);
        this.numTuplesSpilled = 0;
    }

    private void addDone() {
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.numTuplesSpilled > 0) {
            this.updateSpillRecCounter();
        }
        this.addDone = true;
    }

    @Override
    public void clear() {
        if (!this.addDone) {
            this.addDone();
        }
        super.clear();
        this.addDone = false;
        this.out = null;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (!this.addDone) {
            this.addDone();
        }
        return new CachedBagIterator();
    }

    @Override
    public long spill() {
        throw new RuntimeException("InternalCachedBag.spill() should not be called");
    }

    private class CachedBagIterator
    implements Iterator<Tuple> {
        Iterator<Tuple> iter;
        DataInputStream in;
        Tuple next;
        long numTuplesRead = 0L;

        public CachedBagIterator() {
            this.iter = InternalCachedBag.this.mContents.iterator();
            if (InternalCachedBag.this.mSpillFiles != null && InternalCachedBag.this.mSpillFiles.size() > 0) {
                File file = (File)InternalCachedBag.this.mSpillFiles.get(0);
                try {
                    this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                }
                catch (FileNotFoundException fnfe) {
                    String msg = "Unable to find our spill file.";
                    throw new RuntimeException(msg, fnfe);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.iter.hasNext()) {
                this.next = this.iter.next();
                return true;
            }
            if (this.in == null) {
                return false;
            }
            try {
                Tuple t;
                this.next = t = (Tuple)SEDES.readDatum(this.in);
                return true;
            }
            catch (EOFException eof) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.in = null;
                return false;
            }
            catch (IOException e) {
                String msg = "Unable to read our spill file.";
                throw new RuntimeException(msg, e);
            }
        }

        @Override
        public Tuple next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException("No more elements from iterator");
            }
            Tuple t = this.next;
            this.next = null;
            ++this.numTuplesRead;
            if ((this.numTuplesRead & 0x3FFFL) == 0L) {
                InternalCachedBag.this.reportProgress();
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported for CachedBagIterator");
        }
    }
}

