/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.UnaryComparisonOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.UnaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.DotPOPrinter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PlanPrinter;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

public class PhysicalPlan
extends OperatorPlan<PhysicalOperator>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public boolean endOfAllInput = false;
    private MultiMap<PhysicalOperator, PhysicalOperator> opmap = null;

    public void attachInput(Tuple t) {
        List roots = this.getRoots();
        for (PhysicalOperator operator : roots) {
            operator.attachInput(t);
        }
    }

    public void detachInput() {
        for (PhysicalOperator op : this.getRoots()) {
            op.detachInput();
        }
    }

    public void explain(OutputStream out) {
        this.explain(out, true);
    }

    public void explain(OutputStream out, boolean verbose) {
        PlanPrinter mpp = new PlanPrinter(this);
        mpp.setVerbose(verbose);
        try {
            mpp.print(out);
        }
        catch (VisitorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void explain(PrintStream ps, String format, boolean verbose) {
        if (format.equals("xml")) {
            ps.println("<physicalPlan>XML Not Supported</physicalPlan>");
            return;
        }
        ps.println("#-----------------------------------------------");
        ps.println("# Physical Plan:");
        ps.println("#-----------------------------------------------");
        if (format.equals("text")) {
            this.explain(ps, verbose);
            ps.println("");
        } else if (format.equals("dot")) {
            DotPOPrinter pp = new DotPOPrinter(this, ps);
            pp.setVerbose(verbose);
            pp.dump();
        }
        ps.println("");
    }

    @Override
    public void connect(PhysicalOperator from, PhysicalOperator to) throws PlanException {
        super.connect(from, to);
        to.setInputs(this.getPredecessors(to));
    }

    @Override
    public void remove(PhysicalOperator op) {
        op.setInputs(null);
        List<PhysicalOperator> sucs = this.getSuccessors(op);
        if (sucs != null && sucs.size() != 0) {
            for (PhysicalOperator suc : sucs) {
                List<PhysicalOperator> succInputs = suc.getInputs();
                succInputs.remove(op);
                if (succInputs.size() == 0) {
                    suc.setInputs(null);
                    continue;
                }
                suc.setInputs(succInputs);
            }
        }
        super.remove(op);
    }

    @Override
    public void replace(PhysicalOperator oldNode, PhysicalOperator newNode) throws PlanException {
        List<PhysicalOperator> oldNodeSuccessors = this.getSuccessors(oldNode);
        super.replace(oldNode, newNode);
        if (oldNodeSuccessors != null) {
            for (PhysicalOperator preds : oldNodeSuccessors) {
                List<PhysicalOperator> inputs = preds.getInputs();
                for (int i = 0; i < inputs.size(); ++i) {
                    if (inputs.get(i) != oldNode) continue;
                    inputs.set(i, newNode);
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.mOps.size() == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty Plan!";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.explain(baos, true);
        return baos.toString();
    }

    public PhysicalPlan clone() throws CloneNotSupportedException {
        PhysicalPlan clone = new PhysicalPlan();
        HashMap<PhysicalOperator, PhysicalOperator> matches = new HashMap<PhysicalOperator, PhysicalOperator>(this.mOps.size());
        ArrayList opsToClone = new ArrayList(this.mOps.keySet());
        Collections.sort(opsToClone);
        for (PhysicalOperator op : opsToClone) {
            PhysicalOperator c = op.clone();
            clone.add(c);
            if (this.opmap != null) {
                this.opmap.put(op, c);
            }
            matches.put(op, c);
        }
        for (PhysicalOperator op : this.mFromEdges.keySet()) {
            PhysicalOperator cloneFrom = (PhysicalOperator)matches.get(op);
            if (cloneFrom == null) {
                String msg = "Unable to find clone for op " + op.name();
                throw new CloneNotSupportedException(msg);
            }
            List toOps = this.mFromEdges.get(op);
            for (PhysicalOperator toOp : toOps) {
                PhysicalOperator cloneTo = (PhysicalOperator)matches.get(toOp);
                if (cloneTo == null) {
                    String msg = "Unable to find clone for op " + toOp.name();
                    throw new CloneNotSupportedException(msg);
                }
                try {
                    clone.connect(cloneFrom, cloneTo);
                }
                catch (PlanException pe) {
                    CloneNotSupportedException cnse = new CloneNotSupportedException();
                    cnse.initCause(pe);
                    throw cnse;
                }
            }
        }
        for (PhysicalOperator op : this.mOps.keySet()) {
            List<PhysicalOperator> inputs = op.getInputs();
            if (inputs == null || inputs.size() == 0) continue;
            ArrayList<PhysicalOperator> newInputs = new ArrayList<PhysicalOperator>(inputs.size());
            PhysicalOperator cloneOp = (PhysicalOperator)matches.get(op);
            if (cloneOp == null) {
                String msg = "Unable to find clone for op " + op.name();
                throw new CloneNotSupportedException(msg);
            }
            for (PhysicalOperator iOp : inputs) {
                PhysicalOperator cloneIOp = (PhysicalOperator)matches.get(iOp);
                if (cloneIOp == null) {
                    String msg = "Unable to find clone for op " + iOp.name();
                    throw new CloneNotSupportedException(msg);
                }
                newInputs.add(cloneIOp);
            }
            cloneOp.setInputs(newInputs);
        }
        for (PhysicalOperator op : this.mOps.keySet()) {
            ExpressionOperator cloneOp;
            ExpressionOperator orig;
            if (op instanceof UnaryComparisonOperator) {
                orig = (UnaryComparisonOperator)op;
                cloneOp = (UnaryComparisonOperator)matches.get(op);
                ((UnaryExpressionOperator)cloneOp).setExpr((ExpressionOperator)matches.get(((UnaryExpressionOperator)orig).getExpr()));
                ((UnaryComparisonOperator)cloneOp).setOperandType(((UnaryComparisonOperator)orig).getOperandType());
                continue;
            }
            if (op instanceof BinaryExpressionOperator) {
                orig = (BinaryExpressionOperator)op;
                cloneOp = (BinaryExpressionOperator)matches.get(op);
                ((BinaryExpressionOperator)cloneOp).setRhs((ExpressionOperator)matches.get(((BinaryExpressionOperator)orig).getRhs()));
                ((BinaryExpressionOperator)cloneOp).setLhs((ExpressionOperator)matches.get(((BinaryExpressionOperator)orig).getLhs()));
                continue;
            }
            if (!(op instanceof POBinCond)) continue;
            orig = (POBinCond)op;
            cloneOp = (POBinCond)matches.get(op);
            ((POBinCond)cloneOp).setRhs((ExpressionOperator)matches.get(((POBinCond)orig).getRhs()));
            ((POBinCond)cloneOp).setLhs((ExpressionOperator)matches.get(((POBinCond)orig).getLhs()));
            ((POBinCond)cloneOp).setCond((ExpressionOperator)matches.get(((POBinCond)orig).getCond()));
        }
        return clone;
    }

    public void setOpMap(MultiMap<PhysicalOperator, PhysicalOperator> opmap) {
        this.opmap = opmap;
    }

    public void resetOpMap() {
        this.opmap = null;
    }
}

