/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.regionserver.wal.DamagedWALException;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.FailedSyncBeforeLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.RingBufferTruck;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.DrainBarrier;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALPrettyPrinter;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.htrace.NullScope;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

@InterfaceAudience.Private
public class FSHLog
implements WAL {
    static final Log LOG = LogFactory.getLog(FSHLog.class);
    private static final int DEFAULT_SLOW_SYNC_TIME_MS = 100;
    private final Disruptor<RingBufferTruck> disruptor;
    private static final int DEFAULT_WAL_SYNC_TIMEOUT_MS = 300000;
    private final ExecutorService appendExecutor;
    private final RingBufferEventHandler ringBufferEventHandler;
    private final Map<Thread, SyncFuture> syncFuturesByHandler;
    private volatile long highestUnsyncedSequence = -1L;
    private final AtomicLong highestSyncedSequence = new AtomicLong(0L);
    protected final FileSystem fs;
    private final Path fullPathLogDir;
    private final Path fullPathArchiveDir;
    private final PathFilter ourFiles;
    private final String logFilePrefix;
    private final String logFileSuffix;
    private final String prefixPathStr;
    private final WALCoprocessorHost coprocessorHost;
    protected final Configuration conf;
    private final List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
    private FSDataOutputStream hdfs_out;
    private final int minTolerableReplication;
    private final Method getNumCurrentReplicas;
    private final Method getPipeLine;
    private final int slowSyncNs;
    private static final Object[] NO_ARGS = new Object[0];
    private final long walSyncTimeout;
    private final AtomicInteger consecutiveLogRolls = new AtomicInteger(0);
    private final int lowReplicationRollLimit;
    private volatile boolean lowReplicationRollEnabled = true;
    volatile WALProvider.Writer writer;
    private final DrainBarrier closeBarrier = new DrainBarrier();
    private final ReentrantLock rollWriterLock = new ReentrantLock(true);
    private volatile boolean closed = false;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicLong filenum = new AtomicLong(-1L);
    private final AtomicInteger numEntries = new AtomicInteger(0);
    private final long logrollsize;
    private AtomicLong totalLogSize = new AtomicLong(0L);
    private final int maxLogs;
    private final int closeErrorsTolerated;
    private final AtomicInteger closeErrorCount = new AtomicInteger();
    private final Object regionSequenceIdLock = new Object();
    private final ConcurrentMap<byte[], ConcurrentMap<byte[], Long>> oldestUnflushedStoreSequenceIds = new ConcurrentSkipListMap<byte[], ConcurrentMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], Map<byte[], Long>> lowestFlushingStoreSequenceIds = new TreeMap<byte[], Map<byte[], Long>>(Bytes.BYTES_COMPARATOR);
    private Map<byte[], Long> highestRegionSequenceIds = new HashMap<byte[], Long>();
    final Comparator<Path> LOG_NAME_COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path o1, Path o2) {
            long t2;
            long t1 = FSHLog.this.getFileNumFromFileName(o1);
            if (t1 == (t2 = FSHLog.this.getFileNumFromFileName(o2))) {
                return 0;
            }
            return t1 > t2 ? 1 : -1;
        }
    };
    private NavigableMap<Path, Map<byte[], Long>> byWalRegionSequenceIds = new ConcurrentSkipListMap<Path, Map<byte[], Long>>(this.LOG_NAME_COMPARATOR);
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + ClassSize.ATOMIC_INTEGER + 4 + 24));

    @Override
    public void registerWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unregisterWALActionsListener(WALActionsListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public WALCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    public FSHLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
        this(fs, root, logDir, "oldWALs", conf, null, true, null, null);
    }

    public FSHLog(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
        FileStatus[] walFiles;
        this.fs = fs;
        this.fullPathLogDir = new Path(rootDir, logDir);
        this.fullPathArchiveDir = new Path(rootDir, archiveDir);
        this.conf = conf;
        if (!fs.exists(this.fullPathLogDir) && !fs.mkdirs(this.fullPathLogDir)) {
            throw new IOException("Unable to mkdir " + this.fullPathLogDir);
        }
        if (!fs.exists(this.fullPathArchiveDir) && !fs.mkdirs(this.fullPathArchiveDir)) {
            throw new IOException("Unable to mkdir " + this.fullPathArchiveDir);
        }
        String string = this.logFilePrefix = prefix == null || prefix.isEmpty() ? "wal" : URLEncoder.encode(prefix, "UTF8");
        if (suffix != null && !suffix.isEmpty() && !suffix.startsWith(".")) {
            throw new IllegalArgumentException("WAL suffix must start with '.' but instead was '" + suffix + "'");
        }
        FSUtils.setStoragePolicy(fs, conf, this.fullPathLogDir, "hbase.wal.storage.policy", "NONE");
        this.logFileSuffix = suffix == null ? "" : URLEncoder.encode(suffix, "UTF8");
        this.prefixPathStr = new Path(this.fullPathLogDir, this.logFilePrefix + ".").toString();
        this.ourFiles = new PathFilter(){

            public boolean accept(Path fileName) {
                String fileNameString = fileName.toString();
                if (!fileNameString.startsWith(FSHLog.this.prefixPathStr)) {
                    return false;
                }
                if (FSHLog.this.logFileSuffix.isEmpty()) {
                    return StringUtils.isNumeric((String)fileNameString.substring(FSHLog.this.prefixPathStr.length()));
                }
                return fileNameString.endsWith(FSHLog.this.logFileSuffix);
            }
        };
        if (failIfWALExists && null != (walFiles = FSUtils.listStatus(fs, this.fullPathLogDir, this.ourFiles)) && 0 != walFiles.length) {
            throw new IOException("Target WAL already exists within directory " + this.fullPathLogDir);
        }
        if (listeners != null) {
            for (WALActionsListener i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.coprocessorHost = new WALCoprocessorHost(this, conf);
        long blocksize = this.conf.getLong("hbase.regionserver.hlog.blocksize", FSUtils.getDefaultBlockSize(this.fs, this.fullPathLogDir));
        this.logrollsize = (long)((float)blocksize * conf.getFloat("hbase.regionserver.logroll.multiplier", 0.95f));
        this.maxLogs = conf.getInt("hbase.regionserver.maxlogs", 32);
        this.minTolerableReplication = conf.getInt("hbase.regionserver.hlog.tolerable.lowreplication", (int)FSUtils.getDefaultReplication(fs, this.fullPathLogDir));
        this.lowReplicationRollLimit = conf.getInt("hbase.regionserver.hlog.lowreplication.rolllimit", 5);
        this.closeErrorsTolerated = conf.getInt("hbase.regionserver.logroll.errors.tolerated", 0);
        int maxHandlersCount = conf.getInt("hbase.regionserver.handler.count", 200);
        LOG.info((Object)("WAL configuration: blocksize=" + org.apache.hadoop.util.StringUtils.byteDesc((long)blocksize) + ", rollsize=" + org.apache.hadoop.util.StringUtils.byteDesc((long)this.logrollsize) + ", prefix=" + this.logFilePrefix + ", suffix=" + this.logFileSuffix + ", logDir=" + this.fullPathLogDir + ", archiveDir=" + this.fullPathArchiveDir));
        this.rollWriter();
        this.slowSyncNs = 1000000 * conf.getInt("hbase.regionserver.hlog.slowsync.ms", 100);
        this.walSyncTimeout = conf.getLong("hbase.regionserver.hlog.sync.timeout", 300000L);
        this.getNumCurrentReplicas = this.getGetNumCurrentReplicas(this.hdfs_out);
        this.getPipeLine = this.getGetPipeline(this.hdfs_out);
        String hostingThreadName = Thread.currentThread().getName();
        this.appendExecutor = Executors.newSingleThreadExecutor(Threads.getNamedThreadFactory((String)(hostingThreadName + ".append")));
        int preallocatedEventCount = this.conf.getInt("hbase.regionserver.wal.disruptor.event.count", 16384);
        this.disruptor = new Disruptor(RingBufferTruck.EVENT_FACTORY, preallocatedEventCount, (Executor)this.appendExecutor, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.getRingBuffer().next();
        this.ringBufferEventHandler = new RingBufferEventHandler(conf.getInt("hbase.regionserver.hlog.syncer.count", 5), maxHandlersCount);
        this.disruptor.handleExceptionsWith((ExceptionHandler)new RingBufferExceptionHandler());
        this.disruptor.handleEventsWith((EventHandler[])new RingBufferEventHandler[]{this.ringBufferEventHandler});
        this.syncFuturesByHandler = new ConcurrentHashMap<Thread, SyncFuture>(maxHandlersCount);
        this.disruptor.start();
    }

    protected FileStatus[] getFiles() throws IOException {
        return FSUtils.listStatus(this.fs, this.fullPathLogDir, this.ourFiles);
    }

    @VisibleForTesting
    OutputStream getOutputStream() {
        FSDataOutputStream fsdos = this.hdfs_out;
        if (fsdos == null) {
            return null;
        }
        return fsdos.getWrappedStream();
    }

    @Override
    public byte[][] rollWriter() throws FailedLogCloseException, IOException {
        return this.rollWriter(false);
    }

    private Path getNewPath() throws IOException {
        this.filenum.set(System.currentTimeMillis());
        Path newPath = this.getCurrentFileName();
        while (this.fs.exists(newPath)) {
            this.filenum.incrementAndGet();
            newPath = this.getCurrentFileName();
        }
        return newPath;
    }

    Path getOldPath() {
        long currentFilenum = this.filenum.get();
        Path oldPath = null;
        if (currentFilenum > 0L) {
            oldPath = this.computeFilename(currentFilenum);
        }
        return oldPath;
    }

    private void tellListenersAboutPreLogRoll(Path oldPath, Path newPath) throws IOException {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogRoll(oldPath, newPath);
            }
        }
    }

    private void tellListenersAboutPostLogRoll(Path oldPath, Path newPath) throws IOException {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogRoll(oldPath, newPath);
            }
        }
    }

    private void preemptiveSync(ProtobufLogWriter nextWriter) {
        long startTimeNanos = System.nanoTime();
        try {
            nextWriter.sync();
            this.postSync(System.nanoTime() - startTimeNanos, 0);
        }
        catch (IOException e) {
            LOG.warn((Object)"pre-sync failed but an optimization so keep going", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
        this.rollWriterLock.lock();
        try {
            if (!force && this.writer != null && this.numEntries.get() <= 0) {
                byte[][] byArray = null;
                return byArray;
            }
            byte[][] regionsToFlush = null;
            if (this.closed) {
                LOG.debug((Object)"WAL closed. Skipping rolling of writer");
                byte[][] byArray = regionsToFlush;
                return byArray;
            }
            if (!this.closeBarrier.beginOp()) {
                LOG.debug((Object)"WAL closing. Skipping rolling of writer");
                byte[][] byArray = regionsToFlush;
                return byArray;
            }
            TraceScope scope = Trace.startSpan((String)"FSHLog.rollWriter");
            try {
                Path oldPath = this.getOldPath();
                Path newPath = this.getNewPath();
                WALProvider.Writer nextWriter = this.createWriterInstance(newPath);
                FSDataOutputStream nextHdfsOut = null;
                if (nextWriter instanceof ProtobufLogWriter) {
                    nextHdfsOut = ((ProtobufLogWriter)nextWriter).getStream();
                    this.preemptiveSync((ProtobufLogWriter)nextWriter);
                }
                this.tellListenersAboutPreLogRoll(oldPath, newPath);
                newPath = this.replaceWriter(oldPath, newPath, nextWriter, nextHdfsOut);
                this.tellListenersAboutPostLogRoll(oldPath, newPath);
                if (this.getNumRolledLogFiles() > 0) {
                    this.cleanOldLogs();
                    regionsToFlush = this.findRegionsToForceFlush();
                }
            }
            finally {
                this.closeBarrier.endOp();
                assert (scope == NullScope.INSTANCE || !scope.isDetached());
                scope.close();
            }
            byte[][] byArray = regionsToFlush;
            return byArray;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
        return DefaultWALProvider.createWriter(this.conf, this.fs, path, false);
    }

    private long getLowestSeqId(Map<byte[], Long> seqIdMap) {
        long result = -1L;
        for (Long seqNum : seqIdMap.values()) {
            if (result != -1L && seqNum >= result) continue;
            result = seqNum;
        }
        return result;
    }

    private <T extends Map<byte[], Long>> Map<byte[], Long> copyMapWithLowestSeqId(Map<byte[], T> mapToCopy) {
        HashMap copied = Maps.newHashMap();
        for (Map.Entry<byte[], T> entry : mapToCopy.entrySet()) {
            long lowestSeqId = this.getLowestSeqId((Map)entry.getValue());
            if (lowestSeqId == -1L) continue;
            copied.put(entry.getKey(), lowestSeqId);
        }
        return copied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOldLogs() throws IOException {
        Map<byte[], Long> lowestFlushingRegionSequenceIdsLocal = null;
        Map<byte[], Long> oldestUnflushedRegionSequenceIdsLocal = null;
        ArrayList<Path> logsToArchive = new ArrayList<Path>();
        Object object = this.regionSequenceIdLock;
        synchronized (object) {
            lowestFlushingRegionSequenceIdsLocal = this.copyMapWithLowestSeqId(this.lowestFlushingStoreSequenceIds);
            oldestUnflushedRegionSequenceIdsLocal = this.copyMapWithLowestSeqId(this.oldestUnflushedStoreSequenceIds);
        }
        for (Map.Entry e : this.byWalRegionSequenceIds.entrySet()) {
            Path log = (Path)e.getKey();
            Map sequenceNums = (Map)e.getValue();
            if (!FSHLog.areAllRegionsFlushed(sequenceNums, lowestFlushingRegionSequenceIdsLocal, oldestUnflushedRegionSequenceIdsLocal)) continue;
            logsToArchive.add(log);
            LOG.debug((Object)("WAL file ready for archiving " + log));
        }
        for (Path p : logsToArchive) {
            this.totalLogSize.addAndGet(-this.fs.getFileStatus(p).getLen());
            this.archiveLogFile(p);
            this.byWalRegionSequenceIds.remove(p);
        }
    }

    static boolean areAllRegionsFlushed(Map<byte[], Long> sequenceNums, Map<byte[], Long> oldestFlushingMap, Map<byte[], Long> oldestUnflushedMap) {
        for (Map.Entry<byte[], Long> regionSeqIdEntry : sequenceNums.entrySet()) {
            long oldestUnFlushed;
            long oldestFlushing = oldestFlushingMap.containsKey(regionSeqIdEntry.getKey()) ? oldestFlushingMap.get(regionSeqIdEntry.getKey()) : Long.MAX_VALUE;
            long minSeqNum = Math.min(oldestFlushing, oldestUnFlushed = oldestUnflushedMap.containsKey(regionSeqIdEntry.getKey()) ? oldestUnflushedMap.get(regionSeqIdEntry.getKey()) : Long.MAX_VALUE);
            if (minSeqNum > regionSeqIdEntry.getValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] findEligibleMemstoresToFlush(Map<byte[], Long> regionsSequenceNums) {
        ArrayList<byte[]> regionsToFlush = null;
        Object object = this.regionSequenceIdLock;
        synchronized (object) {
            for (Map.Entry<byte[], Long> e : regionsSequenceNums.entrySet()) {
                long unFlushedVal;
                ConcurrentMap m = (ConcurrentMap)this.oldestUnflushedStoreSequenceIds.get(e.getKey());
                if (m == null || (unFlushedVal = ((Long)Collections.min(m.values())).longValue()) == -1L || unFlushedVal > e.getValue()) continue;
                if (regionsToFlush == null) {
                    regionsToFlush = new ArrayList<byte[]>();
                }
                regionsToFlush.add(e.getKey());
            }
        }
        return regionsToFlush == null ? (byte[][])null : (byte[][])regionsToFlush.toArray((T[])new byte[][]{HConstants.EMPTY_BYTE_ARRAY});
    }

    byte[][] findRegionsToForceFlush() throws IOException {
        byte[][] regions = null;
        int logCount = this.getNumRolledLogFiles();
        if (logCount > this.maxLogs && logCount > 0) {
            Map.Entry<Path, Map<byte[], Long>> firstWALEntry = this.byWalRegionSequenceIds.firstEntry();
            regions = this.findEligibleMemstoresToFlush(firstWALEntry.getValue());
        }
        if (regions != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Bytes.toStringBinary((byte[])regions[i]));
            }
            LOG.info((Object)("Too many wals: logs=" + logCount + ", maxlogs=" + this.maxLogs + "; forcing flush of " + regions.length + " regions(s): " + sb.toString()));
        }
        return regions;
    }

    @VisibleForTesting
    protected void afterCreatingZigZagLatch() {
    }

    @VisibleForTesting
    protected void beforeWaitOnSafePoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path replaceWriter(Path oldPath, Path newPath, WALProvider.Writer nextWriter, FSDataOutputStream nextHdfsOut) throws IOException {
        SyncFuture syncFuture = null;
        SafePointZigZagLatch zigzagLatch = null;
        long sequence = -1L;
        if (this.ringBufferEventHandler != null) {
            sequence = this.getSequenceOnRingBuffer();
            zigzagLatch = this.ringBufferEventHandler.attainSafePoint();
        }
        this.afterCreatingZigZagLatch();
        TraceScope scope = Trace.startSpan((String)"FSHFile.replaceWriter");
        try {
            String newPathString;
            try {
                if (zigzagLatch != null) {
                    assert (sequence > 0L) : "Failed to get sequence from ring buffer";
                    Trace.addTimelineAnnotation((String)"awaiting safepoint");
                    syncFuture = zigzagLatch.waitSafePoint(this.publishSyncOnRingBuffer(sequence));
                }
            }
            catch (FailedSyncBeforeLogCloseException e) {
                if (this.isUnflushedEntries()) {
                    throw e;
                }
                LOG.warn((Object)("Failed sync-before-close but no outstanding appends; closing WAL: " + e.getMessage()));
            }
            try {
                if (this.writer != null) {
                    Trace.addTimelineAnnotation((String)"closing writer");
                    this.writer.close();
                    Trace.addTimelineAnnotation((String)"writer closed");
                }
                this.closeErrorCount.set(0);
            }
            catch (IOException ioe) {
                int errors = this.closeErrorCount.incrementAndGet();
                if (!this.isUnflushedEntries() && errors <= this.closeErrorsTolerated) {
                    LOG.warn((Object)("Riding over failed WAL close of " + oldPath + ", cause=\"" + ioe.getMessage() + "\", errors=" + errors + "; THIS FILE WAS NOT CLOSED BUT ALL EDITS SYNCED SO SHOULD BE OK"));
                }
                throw ioe;
            }
            this.writer = nextWriter;
            this.hdfs_out = nextHdfsOut;
            int oldNumEntries = this.numEntries.get();
            this.numEntries.set(0);
            String string = newPathString = null == newPath ? null : FSUtils.getPath(newPath);
            if (oldPath != null) {
                this.byWalRegionSequenceIds.put(oldPath, this.highestRegionSequenceIds);
                this.highestRegionSequenceIds = new HashMap<byte[], Long>();
                long oldFileLen = this.fs.getFileStatus(oldPath).getLen();
                this.totalLogSize.addAndGet(oldFileLen);
                LOG.info((Object)("Rolled WAL " + FSUtils.getPath(oldPath) + " with entries=" + oldNumEntries + ", filesize=" + org.apache.hadoop.util.StringUtils.byteDesc((long)oldFileLen) + "; new WAL " + newPathString));
            } else {
                LOG.info((Object)("New WAL " + newPathString));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            long count = this.getUnflushedEntriesCount();
            LOG.error((Object)("Failed close of WAL writer " + oldPath + ", unflushedEntries=" + count), (Throwable)e);
            throw new FailedLogCloseException(oldPath + ", unflushedEntries=" + count, (Throwable)e);
        }
        finally {
            try {
                if (zigzagLatch != null) {
                    zigzagLatch.releaseSafePoint();
                    if (syncFuture != null) {
                        try {
                            this.blockOnSync(syncFuture);
                        }
                        catch (IOException ioe) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)"Stale sync exception", (Throwable)ioe);
                            }
                        }
                    }
                }
            }
            finally {
                scope.close();
            }
        }
        return newPath;
    }

    long getUnflushedEntriesCount() {
        long highestSynced = this.highestSyncedSequence.get();
        return highestSynced > this.highestUnsyncedSequence ? 0L : this.highestUnsyncedSequence - highestSynced;
    }

    boolean isUnflushedEntries() {
        return this.getUnflushedEntriesCount() > 0L;
    }

    public static Path getWALArchivePath(Path archiveDir, Path p) {
        return new Path(archiveDir, p.getName());
    }

    private void archiveLogFile(Path p) throws IOException {
        Path newPath = FSHLog.getWALArchivePath(this.fullPathArchiveDir, p);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogArchive(p, newPath);
            }
        }
        LOG.info((Object)("Archiving " + p + " to " + newPath));
        if (!FSUtils.renameAndSetModifyTime(this.fs, p, newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(p, newPath);
            }
        }
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("WAL file number can't be < 0");
        }
        String child = this.logFilePrefix + "." + filenum + this.logFileSuffix;
        return new Path(this.fullPathLogDir, child);
    }

    public Path getCurrentFileName() {
        return this.computeFilename(this.filenum.get());
    }

    public long getFilenum() {
        return this.filenum.get();
    }

    @Override
    public String toString() {
        return "FSHLog " + this.logFilePrefix + ":" + this.logFileSuffix + "(num " + this.filenum + ")";
    }

    protected long getFileNumFromFileName(Path fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("file name can't be null");
        }
        if (!this.ourFiles.accept(fileName)) {
            throw new IllegalArgumentException("The log file " + fileName + " doesn't belong to this WAL. (" + this.toString() + ")");
        }
        String fileNameString = fileName.toString();
        String chompedPath = fileNameString.substring(this.prefixPathStr.length(), fileNameString.length() - this.logFileSuffix.length());
        return Long.parseLong(chompedPath);
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
        FileStatus[] files = this.getFiles();
        if (null != files && 0 != files.length) {
            for (FileStatus file : files) {
                Path p = FSHLog.getWALArchivePath(this.fullPathArchiveDir, file.getPath());
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogArchive(file.getPath(), p);
                    }
                }
                if (!FSUtils.renameAndSetModifyTime(this.fs, file.getPath(), p)) {
                    throw new IOException("Unable to rename " + file.getPath() + " to " + p);
                }
                if (this.listeners.isEmpty()) continue;
                for (WALActionsListener i : this.listeners) {
                    i.postLogArchive(file.getPath(), p);
                }
            }
            LOG.debug((Object)("Moved " + files.length + " WAL file(s) to " + FSUtils.getPath(this.fullPathArchiveDir)));
        }
        LOG.info((Object)("Closed WAL: " + this.toString()));
    }

    @Override
    public void shutdown() throws IOException {
        if (this.shutdown.compareAndSet(false, true)) {
            try {
                this.closeBarrier.stopAndDrainOps();
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Exception while waiting for cache flushes and log rolls", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (this.disruptor != null) {
                long timeoutms = this.conf.getLong("hbase.wal.disruptor.shutdown.timeout.ms", 60000L);
                try {
                    this.disruptor.shutdown(timeoutms, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    LOG.warn((Object)("Timed out bringing down disruptor after " + timeoutms + "ms; forcing halt " + "(It is a problem if this is NOT an ABORT! -- DATALOSS!!!!)"));
                    this.disruptor.halt();
                    this.disruptor.shutdown();
                }
            }
            if (this.appendExecutor != null) {
                this.appendExecutor.shutdown();
            }
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener i : this.listeners) {
                    i.logCloseRequested();
                }
            }
            this.closed = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing WAL writer in " + FSUtils.getPath(this.fullPathLogDir)));
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    protected WALKey makeKey(byte[] encodedRegionName, TableName tableName, long seqnum, long now, List<UUID> clusterIds, long nonceGroup, long nonce) {
        return new HLogKey(encodedRegionName, tableName, seqnum, now, clusterIds, nonceGroup, nonce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_EXCEPTION"}, justification="Will never be null")
    public long append(HTableDescriptor htd, HRegionInfo hri, WALKey key, WALEdit edits, AtomicLong sequenceId, boolean inMemstore, List<Cell> memstoreCells) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        TraceScope scope = Trace.startSpan((String)"FSHLog.append");
        FSWALEntry entry = null;
        long sequence = this.disruptor.getRingBuffer().next();
        try {
            RingBufferTruck truck = (RingBufferTruck)this.disruptor.getRingBuffer().get(sequence);
            entry = new FSWALEntry(sequence, key, edits, sequenceId, inMemstore, htd, hri, (List<Cell>)(memstoreCells != null ? memstoreCells : (edits == null ? null : edits.getCells())));
            truck.loadPayload(entry, scope.detach());
        }
        finally {
            this.disruptor.getRingBuffer().publish(sequence);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkLogRoll() {
        boolean lowReplication;
        if (!this.rollWriterLock.tryLock()) {
            return;
        }
        try {
            lowReplication = this.checkLowReplication();
        }
        finally {
            this.rollWriterLock.unlock();
        }
        try {
            if (lowReplication || this.writer != null && this.writer.getLength() > this.logrollsize) {
                this.requestLogRoll(lowReplication);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Writer.getLength() failed; continuing", (Throwable)e);
        }
    }

    private boolean checkLowReplication() {
        boolean logRollNeeded = false;
        try {
            int numCurrentReplicas = this.getLogReplication();
            if (numCurrentReplicas != 0 && numCurrentReplicas < this.minTolerableReplication) {
                if (this.lowReplicationRollEnabled) {
                    if (this.consecutiveLogRolls.get() < this.lowReplicationRollLimit) {
                        LOG.warn((Object)("HDFS pipeline error detected. Found " + numCurrentReplicas + " replicas but expecting no less than " + this.minTolerableReplication + " replicas. " + " Requesting close of WAL. current pipeline: " + Arrays.toString(this.getPipeLine())));
                        logRollNeeded = true;
                        this.consecutiveLogRolls.getAndIncrement();
                    } else {
                        LOG.warn((Object)"Too many consecutive RollWriter requests, it's a sign of the total number of live datanodes is lower than the tolerable replicas.");
                        this.consecutiveLogRolls.set(0);
                        this.lowReplicationRollEnabled = false;
                    }
                }
            } else if (numCurrentReplicas >= this.minTolerableReplication && !this.lowReplicationRollEnabled) {
                if (this.numEntries.get() <= 1) {
                    return logRollNeeded;
                }
                this.lowReplicationRollEnabled = true;
                LOG.info((Object)"LowReplication-Roller was enabled.");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("DFSOutputStream.getNumCurrentReplicas failed because of " + e + ", continuing..."));
        }
        return logRollNeeded;
    }

    private SyncFuture publishSyncOnRingBuffer(long sequence) {
        return this.publishSyncOnRingBuffer(sequence, null);
    }

    private long getSequenceOnRingBuffer() {
        return this.disruptor.getRingBuffer().next();
    }

    private SyncFuture publishSyncOnRingBuffer(Span span) {
        long sequence = this.disruptor.getRingBuffer().next();
        return this.publishSyncOnRingBuffer(sequence, span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncFuture publishSyncOnRingBuffer(long sequence, Span span) {
        SyncFuture syncFuture = this.getSyncFuture(sequence, span);
        try {
            RingBufferTruck truck = (RingBufferTruck)this.disruptor.getRingBuffer().get(sequence);
            truck.loadPayload(syncFuture);
        }
        finally {
            this.disruptor.getRingBuffer().publish(sequence);
        }
        return syncFuture;
    }

    private Span publishSyncThenBlockOnCompletion(Span span) throws IOException {
        return this.blockOnSync(this.publishSyncOnRingBuffer(span));
    }

    private Span blockOnSync(SyncFuture syncFuture) throws IOException {
        try {
            syncFuture.get(this.walSyncTimeout);
            return syncFuture.getSpan();
        }
        catch (TimeoutIOException tioe) {
            this.syncFuturesByHandler.remove(Thread.currentThread());
            throw tioe;
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)"Interrupted", (Throwable)ie);
            throw this.convertInterruptedExceptionToIOException(ie);
        }
        catch (ExecutionException e) {
            throw FSHLog.ensureIOException(e.getCause());
        }
    }

    private IOException convertInterruptedExceptionToIOException(InterruptedException ie) {
        Thread.currentThread().interrupt();
        InterruptedIOException ioe = new InterruptedIOException();
        ioe.initCause(ie);
        return ioe;
    }

    private SyncFuture getSyncFuture(long sequence, Span span) {
        SyncFuture syncFuture = this.syncFuturesByHandler.get(Thread.currentThread());
        if (syncFuture == null) {
            syncFuture = new SyncFuture();
            this.syncFuturesByHandler.put(Thread.currentThread(), syncFuture);
        }
        return syncFuture.reset(sequence, span);
    }

    private void postSync(long timeInNanos, int handlerSyncs) {
        if (timeInNanos > (long)this.slowSyncNs) {
            String msg = "Slow sync cost: " + timeInNanos / 1000000L + " ms, current pipeline: " + Arrays.toString(this.getPipeLine());
            Trace.addTimelineAnnotation((String)msg);
            LOG.info((Object)msg);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener listener : this.listeners) {
                listener.postSync(timeInNanos, handlerSyncs);
            }
        }
    }

    private long postAppend(WAL.Entry e, long elapsedTime) throws IOException {
        long len = 0L;
        if (!this.listeners.isEmpty()) {
            for (Cell cell : e.getEdit().getCells()) {
                len += (long)CellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
            for (WALActionsListener listener : this.listeners) {
                listener.postAppend(len, elapsedTime, e.getKey(), e.getEdit());
            }
        }
        return len;
    }

    private Method getGetNumCurrentReplicas(FSDataOutputStream os) {
        Method m = null;
        if (os != null) {
            Class<?> wrappedStreamClass = os.getWrappedStream().getClass();
            try {
                m = wrappedStreamClass.getDeclaredMethod("getNumCurrentReplicas", new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Object)("FileSystem's output stream doesn't support getNumCurrentReplicas; HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()));
            }
            catch (SecurityException e) {
                LOG.info((Object)("No access to getNumCurrentReplicas on FileSystems's output stream; HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()), (Throwable)e);
                m = null;
            }
        }
        if (m != null && LOG.isTraceEnabled()) {
            LOG.trace((Object)"Using getNumCurrentReplicas");
        }
        return m;
    }

    @VisibleForTesting
    int getLogReplication() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object repl;
        OutputStream stream = this.getOutputStream();
        if (this.getNumCurrentReplicas != null && stream != null && (repl = this.getNumCurrentReplicas.invoke((Object)stream, NO_ARGS)) instanceof Integer) {
            return (Integer)repl;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        TraceScope scope = Trace.startSpan((String)"FSHLog.sync");
        try {
            scope = Trace.continueSpan((Span)this.publishSyncThenBlockOnCompletion(scope.detach()));
        }
        finally {
            assert (scope == NullScope.INSTANCE || !scope.isDetached());
            scope.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(long txid) throws IOException {
        if (this.highestSyncedSequence.get() >= txid) {
            return;
        }
        TraceScope scope = Trace.startSpan((String)"FSHLog.sync");
        try {
            scope = Trace.continueSpan((Span)this.publishSyncThenBlockOnCompletion(scope.detach()));
        }
        finally {
            assert (scope == NullScope.INSTANCE || !scope.isDetached());
            scope.close();
        }
    }

    public void requestLogRoll() {
        this.requestLogRoll(false);
    }

    private void requestLogRoll(boolean tooFewReplicas) {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logRollRequested(tooFewReplicas);
            }
        }
    }

    public int getNumRolledLogFiles() {
        return this.byWalRegionSequenceIds.size();
    }

    public int getNumLogFiles() {
        return this.getNumRolledLogFiles() + 1;
    }

    public long getLogFileSize() {
        return this.totalLogSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> flushedFamilyNames) {
        TreeMap oldStoreSeqNum = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        if (!this.closeBarrier.beginOp()) {
            LOG.info((Object)("Flush will not be started for " + Bytes.toString((byte[])encodedRegionName) + " - because the server is closing."));
            return null;
        }
        long oldestUnflushedSequenceId = -1L;
        Object object = this.regionSequenceIdLock;
        synchronized (object) {
            ConcurrentMap oldestUnflushedStoreSequenceIdsOfRegion = (ConcurrentMap)this.oldestUnflushedStoreSequenceIds.get(encodedRegionName);
            if (oldestUnflushedStoreSequenceIdsOfRegion != null) {
                for (byte[] familyName : flushedFamilyNames) {
                    Long seqId = (Long)oldestUnflushedStoreSequenceIdsOfRegion.remove(familyName);
                    if (seqId == null) continue;
                    oldStoreSeqNum.put(familyName, seqId);
                }
                if (!oldStoreSeqNum.isEmpty()) {
                    Map<byte[], Long> oldValue = this.lowestFlushingStoreSequenceIds.put(encodedRegionName, oldStoreSeqNum);
                    assert (oldValue == null) : "Flushing map not cleaned up for " + Bytes.toString((byte[])encodedRegionName);
                }
                if (oldestUnflushedStoreSequenceIdsOfRegion.isEmpty()) {
                    this.oldestUnflushedStoreSequenceIds.remove(encodedRegionName);
                } else {
                    oldestUnflushedSequenceId = (Long)Collections.min(oldestUnflushedStoreSequenceIdsOfRegion.values());
                }
            }
        }
        if (oldStoreSeqNum.isEmpty()) {
            LOG.warn((Object)("Couldn't find oldest seqNum for the region we are about to flush: [" + Bytes.toString((byte[])encodedRegionName) + "]"));
        }
        return oldestUnflushedSequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeCacheFlush(byte[] encodedRegionName) {
        Object object = this.regionSequenceIdLock;
        synchronized (object) {
            this.lowestFlushingStoreSequenceIds.remove(encodedRegionName);
        }
        this.closeBarrier.endOp();
    }

    private ConcurrentMap<byte[], Long> getOrCreateOldestUnflushedStoreSequenceIdsOfRegion(byte[] encodedRegionName) {
        ConcurrentSkipListMap oldestUnflushedStoreSequenceIdsOfRegion = (ConcurrentSkipListMap)this.oldestUnflushedStoreSequenceIds.get(encodedRegionName);
        if (oldestUnflushedStoreSequenceIdsOfRegion != null) {
            return oldestUnflushedStoreSequenceIdsOfRegion;
        }
        oldestUnflushedStoreSequenceIdsOfRegion = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
        ConcurrentMap alreadyPut = this.oldestUnflushedStoreSequenceIds.putIfAbsent(encodedRegionName, oldestUnflushedStoreSequenceIdsOfRegion);
        return alreadyPut == null ? oldestUnflushedStoreSequenceIdsOfRegion : alreadyPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortCacheFlush(byte[] encodedRegionName) {
        Map<byte[], Long> storeSeqNumsBeforeFlushStarts;
        TreeMap<byte[], Long> currentStoreSeqNums = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        Object object = this.regionSequenceIdLock;
        synchronized (object) {
            storeSeqNumsBeforeFlushStarts = this.lowestFlushingStoreSequenceIds.remove(encodedRegionName);
            if (storeSeqNumsBeforeFlushStarts != null) {
                ConcurrentMap<byte[], Long> oldestUnflushedStoreSequenceIdsOfRegion = this.getOrCreateOldestUnflushedStoreSequenceIdsOfRegion(encodedRegionName);
                for (Map.Entry<byte[], Long> familyNameAndSeqId : storeSeqNumsBeforeFlushStarts.entrySet()) {
                    currentStoreSeqNums.put(familyNameAndSeqId.getKey(), oldestUnflushedStoreSequenceIdsOfRegion.put(familyNameAndSeqId.getKey(), familyNameAndSeqId.getValue()));
                }
            }
        }
        this.closeBarrier.endOp();
        if (storeSeqNumsBeforeFlushStarts != null) {
            for (Map.Entry<byte[], Long> familyNameAndSeqId : storeSeqNumsBeforeFlushStarts.entrySet()) {
                Long currentSeqNum = (Long)currentStoreSeqNums.get(familyNameAndSeqId.getKey());
                if (currentSeqNum == null || currentSeqNum > familyNameAndSeqId.getValue()) continue;
                String errorStr = "Region " + Bytes.toString((byte[])encodedRegionName) + " family " + Bytes.toString((byte[])familyNameAndSeqId.getKey()) + " acquired edits out of order current memstore seq=" + currentSeqNum + ", previous oldest unflushed id=" + familyNameAndSeqId.getValue();
                LOG.error((Object)errorStr);
                Runtime.getRuntime().halt(1);
            }
        }
    }

    @VisibleForTesting
    boolean isLowReplicationRollEnabled() {
        return this.lowReplicationRollEnabled;
    }

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = FSUtils.getWALFileSystem(conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.getFileStatus(p).isDirectory()) {
            throw new IOException(p + " is not a directory");
        }
        Path baseDir = FSUtils.getWALRootDir(conf);
        Path archiveDir = new Path(baseDir, "oldWALs");
        WALSplitter.split(baseDir, p, archiveDir, fs, conf, WALFactory.getInstance(conf));
    }

    @Override
    public long getEarliestMemstoreSeqNum(byte[] encodedRegionName) {
        ConcurrentMap oldestUnflushedStoreSequenceIdsOfRegion = (ConcurrentMap)this.oldestUnflushedStoreSequenceIds.get(encodedRegionName);
        return oldestUnflushedStoreSequenceIdsOfRegion != null ? this.getLowestSeqId(oldestUnflushedStoreSequenceIdsOfRegion) : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEarliestMemstoreSeqNum(byte[] encodedRegionName, byte[] familyName) {
        Object object = this.regionSequenceIdLock;
        synchronized (object) {
            Long earlist;
            Map m = this.lowestFlushingStoreSequenceIds.get(encodedRegionName);
            if (m != null && (earlist = m.get(familyName)) != null) {
                return earlist;
            }
            m = (Map)this.oldestUnflushedStoreSequenceIds.get(encodedRegionName);
            if (m != null && (earlist = (Long)m.get(familyName)) != null) {
                return earlist;
            }
        }
        return -1L;
    }

    @VisibleForTesting
    void atHeadOfRingBufferEventHandlerAppend() {
    }

    private static IOException ensureIOException(Throwable t) {
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    private static void usage() {
        System.err.println("Usage: FSHLog <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: FSHLog --dump hdfs://example.com:9000/hbase/.logs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: FSHLog --split hdfs://example.com:9000/hbase/.logs/DIR");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            FSHLog.usage();
            System.exit(-1);
        }
        if (args[0].compareTo("--dump") == 0) {
            WALPrettyPrinter.run(Arrays.copyOfRange(args, 1, args.length));
        } else if (args[0].compareTo("--perf") == 0) {
            LOG.fatal((Object)"Please use the WALPerformanceEvaluation tool instead. i.e.:");
            LOG.fatal((Object)("\thbase org.apache.hadoop.hbase.wal.WALPerformanceEvaluation --iterations " + args[1]));
            System.exit(-1);
        } else if (args[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args.length; ++i) {
                try {
                    Path logPath = new Path(args[i]);
                    FSUtils.setFsDefault(conf, logPath);
                    FSHLog.split(conf, logPath);
                    continue;
                }
                catch (IOException t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            FSHLog.usage();
            System.exit(-1);
        }
    }

    private Method getGetPipeline(FSDataOutputStream os) {
        Method m = null;
        if (os != null) {
            Class<?> wrappedStreamClass = os.getWrappedStream().getClass();
            try {
                m = wrappedStreamClass.getDeclaredMethod("getPipeline", new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Object)("FileSystem's output stream doesn't support getPipeline; not available; fsOut=" + wrappedStreamClass.getName()));
            }
            catch (SecurityException e) {
                LOG.info((Object)("Doesn't have access to getPipeline on FileSystems's output stream ; fsOut=" + wrappedStreamClass.getName()), (Throwable)e);
                m = null;
            }
        }
        return m;
    }

    @VisibleForTesting
    DatanodeInfo[] getPipeLine() {
        if (this.getPipeLine != null && this.hdfs_out != null) {
            try {
                Object repl = this.getPipeLine.invoke((Object)this.getOutputStream(), NO_ARGS);
                if (repl instanceof DatanodeInfo[]) {
                    return (DatanodeInfo[])repl;
                }
            }
            catch (Exception e) {
                LOG.info((Object)"Get pipeline failed", (Throwable)e);
            }
        }
        return new DatanodeInfo[0];
    }

    class RingBufferEventHandler
    implements EventHandler<RingBufferTruck>,
    LifecycleAware {
        private final SyncRunner[] syncRunners;
        private final SyncFuture[] syncFutures;
        private volatile int syncFuturesCount = 0;
        private volatile SafePointZigZagLatch zigzagLatch;
        private Exception exception = null;
        private final Object safePointWaiter = new Object();
        private volatile boolean shutdown = false;
        private int syncRunnerIndex;

        RingBufferEventHandler(int syncRunnerCount, int maxHandlersCount) {
            this.syncFutures = new SyncFuture[maxHandlersCount];
            this.syncRunners = new SyncRunner[syncRunnerCount];
            for (int i = 0; i < syncRunnerCount; ++i) {
                this.syncRunners[i] = new SyncRunner("sync." + i, maxHandlersCount);
            }
        }

        private void cleanupOutstandingSyncsOnException(long sequence, Exception e) {
            for (int i = 0; i < this.syncFuturesCount; ++i) {
                this.syncFutures[i].done(sequence, e);
            }
            this.syncFuturesCount = 0;
        }

        private boolean isOutstandingSyncs() {
            for (int i = 0; i < this.syncFuturesCount; ++i) {
                if (this.syncFutures[i].isDone()) continue;
                return true;
            }
            return false;
        }

        private boolean isOutstandingSyncsFromRunners() {
            for (SyncRunner syncRunner : this.syncRunners) {
                if (!syncRunner.isAlive() || syncRunner.areSyncFuturesReleased()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(RingBufferTruck truck, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (truck.hasSyncFuturePayload()) {
                    this.syncFutures[this.syncFuturesCount++] = truck.unloadSyncFuturePayload();
                    if (this.syncFuturesCount == this.syncFutures.length) {
                        endOfBatch = true;
                    }
                } else if (truck.hasFSWALEntryPayload()) {
                    TraceScope scope = Trace.continueSpan((Span)truck.unloadSpanPayload());
                    try {
                        FSWALEntry entry = truck.unloadFSWALEntryPayload();
                        if (this.exception != null) {
                            entry.stampRegionSequenceId();
                            return;
                        }
                        this.append(entry);
                    }
                    catch (Exception e) {
                        this.exception = e;
                        this.cleanupOutstandingSyncsOnException(sequence, (Exception)(this.exception instanceof DamagedWALException ? this.exception : new DamagedWALException("On sync", this.exception)));
                        return;
                    }
                    finally {
                        assert (scope == NullScope.INSTANCE || !scope.isDetached());
                        scope.close();
                    }
                } else {
                    this.cleanupOutstandingSyncsOnException(sequence, new IllegalStateException("Neither append nor sync"));
                    return;
                }
                if (!endOfBatch || this.syncFuturesCount <= 0) {
                    return;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Sequence=" + sequence + ", syncCount=" + this.syncFuturesCount));
                }
                if (this.exception == null) {
                    this.syncRunnerIndex = (this.syncRunnerIndex + 1) % this.syncRunners.length;
                    try {
                        this.syncRunners[this.syncRunnerIndex].offer(sequence, this.syncFutures, this.syncFuturesCount);
                    }
                    catch (Exception e) {
                        FSHLog.this.requestLogRoll();
                        this.exception = new DamagedWALException("Failed offering sync", e);
                    }
                }
                if (this.exception != null) {
                    this.cleanupOutstandingSyncsOnException(sequence, (Exception)((Object)new DamagedWALException("On sync", this.exception)));
                }
                this.attainSafePoint(sequence);
                this.syncFuturesCount = 0;
            }
            catch (Throwable t) {
                LOG.error((Object)("UNEXPECTED!!! syncFutures.length=" + this.syncFutures.length), t);
            }
        }

        SafePointZigZagLatch attainSafePoint() {
            this.zigzagLatch = new SafePointZigZagLatch();
            return this.zigzagLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attainSafePoint(long currentSequence) {
            if (this.zigzagLatch == null || !this.zigzagLatch.isCocked()) {
                return;
            }
            FSHLog.this.beforeWaitOnSafePoint();
            try {
                while (!this.shutdown && this.zigzagLatch.isCocked() && FSHLog.this.highestSyncedSequence.get() < currentSequence && this.isOutstandingSyncs() || this.isOutstandingSyncsFromRunners()) {
                    Object object = this.safePointWaiter;
                    synchronized (object) {
                        this.safePointWaiter.wait(0L, 1);
                    }
                }
                this.exception = null;
                this.zigzagLatch.safePointAttained();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }

        private void updateOldestUnflushedSequenceIds(byte[] encodedRegionName, Set<byte[]> familyNameSet, Long lRegionSequenceId) {
            ConcurrentMap oldestUnflushedStoreSequenceIdsOfRegion = FSHLog.this.getOrCreateOldestUnflushedStoreSequenceIdsOfRegion(encodedRegionName);
            for (byte[] familyName : familyNameSet) {
                oldestUnflushedStoreSequenceIdsOfRegion.putIfAbsent(familyName, lRegionSequenceId);
            }
        }

        void append(FSWALEntry entry) throws Exception {
            FSHLog.this.atHeadOfRingBufferEventHandlerAppend();
            long start = EnvironmentEdgeManager.currentTime();
            byte[] encodedRegionName = entry.getKey().getEncodedRegionName();
            long regionSequenceId = -1L;
            try {
                regionSequenceId = entry.stampRegionSequenceId();
                if (entry.getEdit().isEmpty()) {
                    return;
                }
                if (!FSHLog.this.coprocessorHost.preWALWrite(entry.getHRegionInfo(), entry.getKey(), entry.getEdit()) && entry.getEdit().isReplay()) {
                    entry.getKey().setScopes(null);
                }
                if (!FSHLog.this.listeners.isEmpty()) {
                    for (WALActionsListener i : FSHLog.this.listeners) {
                        i.visitLogEntryBeforeWrite(entry.getHTableDescriptor(), entry.getKey(), entry.getEdit());
                    }
                }
                FSHLog.this.writer.append(entry);
                assert (FSHLog.this.highestUnsyncedSequence < entry.getSequence());
                FSHLog.this.highestUnsyncedSequence = entry.getSequence();
                Long lRegionSequenceId = regionSequenceId;
                FSHLog.this.highestRegionSequenceIds.put(encodedRegionName, lRegionSequenceId);
                if (entry.isInMemstore()) {
                    this.updateOldestUnflushedSequenceIds(encodedRegionName, entry.getFamilyNames(), lRegionSequenceId);
                }
                FSHLog.this.coprocessorHost.postWALWrite(entry.getHRegionInfo(), entry.getKey(), entry.getEdit());
                FSHLog.this.postAppend(entry, EnvironmentEdgeManager.currentTime() - start);
            }
            catch (Exception e) {
                String msg = "Failed appending " + regionSequenceId + ", requesting roll of WAL";
                LOG.warn((Object)msg, (Throwable)e);
                FSHLog.this.requestLogRoll();
                throw new DamagedWALException(msg, e);
            }
            FSHLog.this.numEntries.incrementAndGet();
        }

        public void onStart() {
            for (SyncRunner syncRunner : this.syncRunners) {
                syncRunner.start();
            }
        }

        public void onShutdown() {
            for (SyncRunner syncRunner : this.syncRunners) {
                syncRunner.interrupt();
            }
        }
    }

    static class SafePointZigZagLatch {
        private volatile CountDownLatch safePointAttainedLatch = new CountDownLatch(1);
        private volatile CountDownLatch safePointReleasedLatch = new CountDownLatch(1);

        SafePointZigZagLatch() {
        }

        SyncFuture waitSafePoint(SyncFuture syncFuture) throws InterruptedException, FailedSyncBeforeLogCloseException {
            while (!this.safePointAttainedLatch.await(1L, TimeUnit.NANOSECONDS)) {
                if (!syncFuture.isThrowable()) continue;
                throw new FailedSyncBeforeLogCloseException(syncFuture.getThrowable());
            }
            return syncFuture;
        }

        void safePointAttained() throws InterruptedException {
            this.safePointAttainedLatch.countDown();
            this.safePointReleasedLatch.await();
        }

        void releaseSafePoint() {
            this.safePointReleasedLatch.countDown();
        }

        boolean isCocked() {
            return this.safePointAttainedLatch.getCount() > 0L && this.safePointReleasedLatch.getCount() > 0L;
        }
    }

    private class SyncRunner
    extends HasThread {
        private volatile long sequence;
        private final BlockingQueue<SyncFuture> syncFutures;
        private volatile SyncFuture takeSyncFuture;

        SyncRunner(String name, int maxHandlersCount) {
            super(name);
            this.takeSyncFuture = null;
            this.syncFutures = new LinkedBlockingQueue<SyncFuture>(maxHandlersCount * 3);
        }

        void offer(long sequence, SyncFuture[] syncFutures, int syncFutureCount) {
            this.sequence = sequence;
            for (int i = 0; i < syncFutureCount; ++i) {
                this.syncFutures.add(syncFutures[i]);
            }
        }

        private int releaseSyncFuture(SyncFuture syncFuture, long currentSequence, Throwable t) {
            if (!syncFuture.done(currentSequence, t)) {
                throw new IllegalStateException();
            }
            return 1;
        }

        private int releaseSyncFutures(long currentSequence, Throwable t) {
            SyncFuture syncFuture;
            int syncCount = 0;
            while ((syncFuture = (SyncFuture)this.syncFutures.peek()) != null && syncFuture.getRingBufferSequence() <= currentSequence) {
                this.releaseSyncFuture(syncFuture, currentSequence, t);
                if (!this.syncFutures.remove(syncFuture)) {
                    throw new IllegalStateException(syncFuture.toString());
                }
                ++syncCount;
            }
            return syncCount;
        }

        private long updateHighestSyncedSequence(long sequence) {
            long currentHighestSyncedSequence;
            do {
                if ((currentHighestSyncedSequence = FSHLog.this.highestSyncedSequence.get()) < sequence) continue;
                sequence = currentHighestSyncedSequence;
                break;
            } while (!FSHLog.this.highestSyncedSequence.compareAndSet(currentHighestSyncedSequence, sequence));
            return sequence;
        }

        boolean areSyncFuturesReleased() {
            return this.syncFutures.size() <= 0 && this.takeSyncFuture == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                int syncCount = 0;
                try {
                    long currentSequence;
                    while (true) {
                        this.takeSyncFuture = null;
                        this.takeSyncFuture = this.syncFutures.take();
                        currentSequence = this.sequence;
                        long syncFutureSequence = this.takeSyncFuture.getRingBufferSequence();
                        if (syncFutureSequence > currentSequence) {
                            throw new IllegalStateException("currentSequence=" + syncFutureSequence + ", syncFutureSequence=" + syncFutureSequence);
                        }
                        long currentHighestSyncedSequence = FSHLog.this.highestSyncedSequence.get();
                        if (currentSequence >= currentHighestSyncedSequence) break;
                        syncCount += this.releaseSyncFuture(this.takeSyncFuture, currentHighestSyncedSequence, null);
                    }
                    TraceScope scope = Trace.continueSpan((Span)this.takeSyncFuture.getSpan());
                    long start = System.nanoTime();
                    Exception lastException = null;
                    try {
                        Trace.addTimelineAnnotation((String)"syncing writer");
                        FSHLog.this.writer.sync();
                        Trace.addTimelineAnnotation((String)"writer synced");
                        currentSequence = this.updateHighestSyncedSequence(currentSequence);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error syncing, request close of WAL", (Throwable)e);
                        lastException = e;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"UNEXPECTED", (Throwable)e);
                        lastException = e;
                    }
                    finally {
                        this.takeSyncFuture.setSpan(scope.detach());
                        syncCount += this.releaseSyncFuture(this.takeSyncFuture, currentSequence, lastException);
                        syncCount += this.releaseSyncFutures(currentSequence, lastException);
                        if (lastException != null) {
                            FSHLog.this.requestLogRoll();
                        } else {
                            FSHLog.this.checkLogRoll();
                        }
                    }
                    FSHLog.this.postSync(System.nanoTime() - start, syncCount);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    LOG.warn((Object)"UNEXPECTED, continuing", t);
                }
            }
        }
    }

    static class RingBufferExceptionHandler
    implements ExceptionHandler {
        RingBufferExceptionHandler() {
        }

        public void handleEventException(Throwable ex, long sequence, Object event) {
            LOG.error((Object)("Sequence=" + sequence + ", event=" + event), ex);
            throw new RuntimeException(ex);
        }

        public void handleOnStartException(Throwable ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }

        public void handleOnShutdownException(Throwable ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }
}

