/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DateTieredMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.AbstractMultiOutputCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public class DateTieredCompactor
extends AbstractMultiOutputCompactor<DateTieredMultiFileWriter> {
    private static final Log LOG = LogFactory.getLog(DateTieredCompactor.class);

    public DateTieredCompactor(Configuration conf, Store store) {
        super(conf, store);
    }

    private boolean needEmptyFile(CompactionRequest request) {
        return StoreFile.getMaxSequenceIdInList(request.getFiles()) == this.store.getMaxSequenceId();
    }

    public List<Path> compact(final CompactionRequest request, final List<Long> lowerBoundaries, CompactionThroughputController throughputController, User user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing compaction with " + lowerBoundaries.size() + "windows, lower boundaries: " + lowerBoundaries));
        }
        return this.compact(request, this.defaultScannerFactory, new Compactor.CellSinkFactory<DateTieredMultiFileWriter>(){

            @Override
            public DateTieredMultiFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
                DateTieredMultiFileWriter writer = new DateTieredMultiFileWriter(lowerBoundaries, DateTieredCompactor.this.needEmptyFile(request));
                DateTieredCompactor.this.initMultiWriter(writer, scanner, fd, shouldDropBehind);
                return writer;
            }
        }, throughputController, user);
    }

    @Override
    protected List<Path> commitWriter(DateTieredMultiFileWriter writer, Compactor.FileDetails fd, CompactionRequest request) throws IOException {
        return writer.commitWriters(fd.maxSeqId, request.isAllFiles());
    }
}

