/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;

@InterfaceAudience.Private
public class MobCompactionChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(MobCompactionChore.class);
    private HMaster master;
    private TableLockManager tableLockManager;
    private ExecutorService pool;

    public MobCompactionChore(HMaster master, int period) {
        super(master.getServerName() + "-MobCompactionChore", (Stoppable)master, period, (long)period, TimeUnit.SECONDS);
        this.master = master;
        this.tableLockManager = master.getTableLockManager();
        this.pool = MobUtils.createMobCompactorThreadPool(master.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, HTableDescriptor> map = htds.getAll();
            for (HTableDescriptor htd : map.values()) {
                if (!this.master.getAssignmentManager().getTableStateManager().isTableState(htd.getTableName(), ZooKeeperProtos.Table.State.ENABLED)) continue;
                boolean reported = false;
                try {
                    for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
                        if (!hcd.isMobEnabled()) continue;
                        if (!reported) {
                            this.master.reportMobCompactionStart(htd.getTableName());
                            reported = true;
                        }
                        MobUtils.doMobCompaction(this.master.getConfiguration(), this.master.getFileSystem(), htd.getTableName(), hcd, this.pool, this.tableLockManager, false);
                    }
                }
                finally {
                    if (!reported) continue;
                    this.master.reportMobCompactionEnd(htd.getTableName());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to compact mob files", (Throwable)e);
        }
    }

    protected void cleanup() {
        super.cleanup();
        this.pool.shutdown();
    }
}

