/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.backup.impl.BackupCommands;
import org.apache.hadoop.hbase.backup.impl.BackupRestoreConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.LogUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BackupDriver
extends AbstractHBaseTool {
    private static final Log LOG = LogFactory.getLog(BackupDriver.class);
    private CommandLine cmd;

    public BackupDriver() throws IOException {
        this.init();
    }

    protected void init() throws IOException {
        this.addOptNoArg("debug", "Enable debug loggings");
        this.addOptNoArg("all", "All tables");
        this.addOptWithArg("t", "Table name");
        this.addOptWithArg("b", "Bandwidth (MB/s)");
        this.addOptWithArg("w", "Number of workers");
        this.addOptWithArg("n", "History length");
        this.addOptWithArg("set", "Backup set name");
        LogUtils.disableUselessLoggers(LOG);
    }

    private int parseAndRun(String[] args) throws IOException {
        String cmd = null;
        String[] remainArgs = null;
        if (args == null || args.length == 0) {
            BackupCommands.createCommand((Configuration)this.getConf(), (BackupRestoreConstants.BackupCommand)BackupRestoreConstants.BackupCommand.HELP, null).execute();
        } else {
            cmd = args[0];
            remainArgs = new String[args.length - 1];
            if (args.length > 1) {
                System.arraycopy(args, 1, remainArgs, 0, args.length - 1);
            }
        }
        BackupRestoreConstants.BackupCommand type = BackupRestoreConstants.BackupCommand.HELP;
        if (BackupRestoreConstants.BackupCommand.CREATE.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.CREATE;
        } else if (BackupRestoreConstants.BackupCommand.HELP.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.HELP;
        } else if (BackupRestoreConstants.BackupCommand.DELETE.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.DELETE;
        } else if (BackupRestoreConstants.BackupCommand.DESCRIBE.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.DESCRIBE;
        } else if (BackupRestoreConstants.BackupCommand.HISTORY.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.HISTORY;
        } else if (BackupRestoreConstants.BackupCommand.PROGRESS.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.PROGRESS;
        } else if (BackupRestoreConstants.BackupCommand.SET.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.SET;
        } else {
            System.out.println("Unsupported command for backup: " + cmd);
            return -1;
        }
        Logger backupClientLogger = Logger.getLogger((String)"org.apache.hadoop.hbase.backup");
        if (this.cmd.hasOption("debug")) {
            backupClientLogger.setLevel(Level.DEBUG);
        } else {
            backupClientLogger.setLevel(Level.INFO);
        }
        BackupCommands.Command command = BackupCommands.createCommand((Configuration)this.getConf(), (BackupRestoreConstants.BackupCommand)type, (CommandLine)this.cmd);
        if (type == BackupRestoreConstants.BackupCommand.CREATE && this.conf != null) {
            ((BackupCommands.CreateCommand)command).setConf(this.conf);
        }
        command.execute();
        return 0;
    }

    @Override
    protected void addOptions() {
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Override
    protected int doWork() throws Exception {
        return this.parseAndRun(this.cmd.getArgs());
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new BackupDriver(), (String[])args);
        System.exit(ret);
    }
}

