/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DataSourceService;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceServiceException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;

public class JndiDataSourceProvider
implements DataSourceProvider {
    private String connectionPath;
    private transient DataSourceService dataSourceService;

    public JndiDataSourceProvider(String connectionPath) {
        if (connectionPath == null) {
            throw new NullPointerException();
        }
        this.dataSourceService = (DataSourceService)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceService.class);
        this.connectionPath = connectionPath;
    }

    public String getConnectionPath() {
        return this.connectionPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiDataSourceProvider that = (JndiDataSourceProvider)o;
        return !(this.connectionPath != null ? !this.connectionPath.equals(that.connectionPath) : that.connectionPath != null);
    }

    public int hashCode() {
        return this.connectionPath != null ? this.connectionPath.hashCode() : 0;
    }

    @Override
    public DataSource getDataSource() throws SQLException {
        if (this.connectionPath == null) {
            throw new SQLException("JNDI DataSource is invalid; no connection path is defined.");
        }
        try {
            return this.dataSourceService.getDataSource(this.connectionPath);
        }
        catch (DatasourceServiceException ne) {
            throw new SQLException("Failed to access the JNDI system", ne);
        }
    }

    @Override
    public Object getConnectionHash() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getClass().getName());
        list.add(this.connectionPath);
        return list;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dataSourceService = (DataSourceService)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceService.class);
    }
}

