/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.pushdown;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.sql.SQLCondition;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownType;
import org.pentaho.metastore.persist.MetaStoreAttribute;

public class ParameterPushdown
implements PushDownType {
    static final String NAME = "Parameter Capture";
    public static final String DEFINITIONS_LIST_ATTRIBUTE = "definitions_list";
    public static final String PARAMETER_ATTRIBUTE = "parameter_name";
    public static final String FIELD_NAME_ATTRIBUTE = "column_name";
    public static final String FORMAT_ATTRIBUTE = "parameter_format";
    public static final String DEFAULT_FORMAT = "%s";
    public static final String PARAMETER_PREFIX = "_QUERY";
    private static final Joiner.MapJoiner mapJoiner = Joiner.on((char)'\n').withKeyValueSeparator(" = ").useForNull("");
    @MetaStoreAttribute(key="definitions_list")
    private final List<Definition> definitions = Lists.newArrayList();
    private static final ImmutableSet<Integer> ALLOWED_FUNCTIONS = ImmutableSet.of((Object)0);
    private static final ImmutableSet<Integer> ALLOWED_OPERATORS = ImmutableSet.of((Object)0, (Object)2);

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    public Definition createDefinition() {
        Definition definition = new Definition();
        this.definitions.add(definition);
        return definition;
    }

    @Override
    public void init(TransMeta transMeta, DataServiceMeta dataService, PushDownOptimizationMeta optMeta) {
        optMeta.setStepName(dataService.getStepname());
        Iterator<Definition> iterator = this.definitions.iterator();
        while (iterator.hasNext()) {
            Definition definition = iterator.next();
            if (definition.isValid()) {
                try {
                    transMeta.addParameterDefinition(definition.getParameter(), "", "Data Service Field Parameter");
                }
                catch (DuplicateParamException duplicateParamException) {}
                continue;
            }
            iterator.remove();
        }
        transMeta.activateParameters();
    }

    @Override
    public ListenableFuture<Boolean> activate(DataServiceExecutor executor, PushDownOptimizationMeta meta) {
        Map<String, String> parameterValues = this.captureParameterValues(executor.getSql());
        executor.getParameters().putAll(parameterValues);
        return Futures.immediateFuture((Object)(!parameterValues.isEmpty() ? 1 : 0));
    }

    @VisibleForTesting
    protected Map<String, String> captureParameterValues(SQL sql) {
        Optional whereCondition = Optional.fromNullable((Object)sql.getWhereCondition());
        ImmutableListMultimap conditionMap = FluentIterable.from((Iterable)whereCondition.asSet()).transformAndConcat((Function)new Function<SQLCondition, Iterable<Condition>>(){

            public Iterable<Condition> apply(SQLCondition sqlCondition) {
                Condition condition = sqlCondition.getCondition();
                condition.simplify();
                if (!condition.isComposite()) {
                    return Collections.singleton(condition);
                }
                for (Condition child : condition.getChildren()) {
                    if (ALLOWED_OPERATORS.contains((Object)child.getOperator())) continue;
                    return Collections.emptySet();
                }
                return condition.getChildren();
            }
        }).filter((Predicate)new Predicate<Condition>(){

            public boolean apply(Condition condition) {
                return !condition.isComposite() && !condition.isNegated() && condition.getRightExact() != null && ALLOWED_FUNCTIONS.contains((Object)condition.getFunction());
            }
        }).index((Function)new Function<Condition, String>(){

            public String apply(Condition condition) {
                return condition.getLeftValuename();
            }
        });
        LinkedHashMap builder = Maps.newLinkedHashMap();
        for (Definition definition : this.definitions) {
            for (Condition condition : conditionMap.get((Object)definition.getFieldName())) {
                builder.put(definition.getParameter(), definition.format(condition));
            }
        }
        return ImmutableMap.copyOf((Map)builder);
    }

    @Override
    public OptimizationImpactInfo preview(DataServiceExecutor executor, PushDownOptimizationMeta meta) {
        OptimizationImpactInfo impactInfo = new OptimizationImpactInfo(meta.getStepName());
        try {
            TransMeta serviceTrans = executor.getServiceTransMeta();
            LinkedHashMap defaults = Maps.newLinkedHashMap();
            for (Definition definition : this.definitions) {
                String defaultValue = serviceTrans.getParameterDefault(definition.getParameter());
                defaults.put(definition.getParameter(), Objects.firstNonNull((Object)defaultValue, (Object)""));
            }
            LinkedHashMap parameterValues = Maps.newLinkedHashMap((Map)defaults);
            parameterValues.putAll(this.captureParameterValues(executor.getSql()));
            impactInfo.setQueryBeforeOptimization(mapJoiner.join((Map)defaults));
            impactInfo.setQueryAfterOptimization(mapJoiner.join((Map)parameterValues));
            impactInfo.setModified(!parameterValues.equals(defaults));
        }
        catch (Exception e) {
            impactInfo.setErrorMsg(e);
        }
        return impactInfo;
    }

    public static class Definition {
        @MetaStoreAttribute(key="parameter_name")
        private String parameter;
        @MetaStoreAttribute(key="parameter_format")
        private String format = "%s";
        @MetaStoreAttribute(key="column_name")
        private String fieldName;

        public String getFieldName() {
            return this.fieldName;
        }

        public Definition setFieldName(String column) {
            this.fieldName = column;
            return this;
        }

        public String getParameter() {
            return this.parameter;
        }

        public Definition setParameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public String getFormat() {
            if (Strings.isNullOrEmpty((String)this.format)) {
                this.format = ParameterPushdown.DEFAULT_FORMAT;
            }
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        private String format(Condition condition) {
            return String.format(this.getFormat(), condition.getRightExact().getValueData().toString().trim());
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("fieldName", (Object)this.getFieldName()).add("parameter", (Object)this.getParameter()).add("format", (Object)this.getFormat()).toString();
        }

        public boolean isValid() {
            return !Strings.isNullOrEmpty((String)this.getParameter()) && !Strings.isNullOrEmpty((String)this.getFieldName());
        }
    }
}

