/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import java.util.Collections;
import java.util.function.Supplier;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.IDataServiceMetaFactory;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.resolvers.TransientResolver;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.spoon.Spoon;

public class DataServiceMetaFactory
implements IDataServiceMetaFactory {
    private Supplier<Spoon> spoonSupplier;
    private PushDownFactory cacheFactory;

    public DataServiceMetaFactory() {
        this.spoonSupplier = Spoon::getInstance;
    }

    public DataServiceMetaFactory(Supplier<Spoon> spoonSupplier) {
        this.spoonSupplier = spoonSupplier;
    }

    @Override
    public PushDownFactory getCacheFactory() {
        return this.cacheFactory;
    }

    @Override
    public void setCacheFactory(PushDownFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    @Override
    public DataServiceMeta createDataService(StepMeta step) throws KettleException {
        return this.createDataService(step, null);
    }

    @Override
    public DataServiceMeta createDataService(StepMeta step, Integer rowLimit) throws KettleException {
        TransMeta transformation = step.getParentTransMeta();
        DataServiceMeta dataServiceMeta = new DataServiceMeta(transformation);
        dataServiceMeta.setName(this.createDataServiceName(step, rowLimit, false));
        dataServiceMeta.setStepname(step.getName());
        dataServiceMeta.setRowLimit(rowLimit != null ? rowLimit : 0);
        PushDownOptimizationMeta pushDownMeta = new PushDownOptimizationMeta();
        pushDownMeta.setStepName(step.getName());
        pushDownMeta.setType(this.getCacheFactory().createPushDown());
        dataServiceMeta.setPushDownOptimizationMeta(Collections.singletonList(pushDownMeta));
        return dataServiceMeta;
    }

    private String createDataServiceName(StepMeta step, Integer rowLimit, boolean streaming) throws KettleException {
        String path;
        TransMeta transMeta = step.getParentTransMeta();
        String fullFileName = !Utils.isEmpty((CharSequence)transMeta.getFilename()) && transMeta.getObjectId() == null ? transMeta.getFilename() : (transMeta.getRepositoryDirectory() != null ? ((path = transMeta.getRepositoryDirectory().getPath()).endsWith("/") ? path + transMeta.getName() : path + "/" + transMeta.getName()) : transMeta.getName());
        String local = this.isLocal(transMeta) ? "local:" : "";
        String stream = streaming ? "streaming:" : "";
        return TransientResolver.buildTransient(fullFileName, local + stream + step.getName(), rowLimit);
    }

    private boolean isLocal(TransMeta transMeta) {
        return this.spoonSupplier.get() != null && this.spoonSupplier.get().getActiveTransformation().equals((Object)transMeta);
    }
}

