/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.controller;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.MetricsRegistry;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.sql.SQLField;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.clients.AnnotationsQueryService;
import org.pentaho.di.trans.dataservice.clients.Query;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;
import org.pentaho.di.trans.dataservice.ui.BindingConverters;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestCallback;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestDialog;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceTestModel;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulGroupbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class DataServiceTestController
extends AbstractXulEventHandler {
    public static final int POLL_DELAY_MILLIS = 500;
    public static final int POLL_PERIOD_MILLIS = 500;
    public static Class<?> PKG = DataServiceTestDialog.class;
    private final DataServiceTestModel model;
    private static final String NAME = "dataServiceTestController";
    private final String transName;
    private DataServiceTestCallback callback;
    private final DataServiceMeta dataService;
    private final TransMeta transMeta;
    private final NamedParams startingParameterValues = new NamedParamsDefault();
    private XulMenuList<String> logLevels;
    private Timer completionPollTimer;
    private DataServiceExecutor dataServiceExec;
    private boolean stopQuery = false;
    private DataServiceContext context;
    private BindingFactory bindingFactory;
    private XulMenuList<String> maxRows;
    private AnnotationsQueryService annotationsQueryService;
    private IDisposableObserver<List<RowMetaAndData>> pushObserver;

    public DataServiceTestController(DataServiceTestModel model, DataServiceMeta dataService, DataServiceContext context) throws KettleException {
        this(model, dataService, (BindingFactory)new DefaultBindingFactory(), context);
    }

    public DataServiceTestController(DataServiceTestModel model, DataServiceMeta dataService, BindingFactory bindingFactory, DataServiceContext context) throws KettleException {
        this.model = model;
        this.dataService = dataService;
        this.transMeta = dataService.getServiceTrans();
        this.bindingFactory = bindingFactory;
        this.transName = this.transMeta.getName();
        this.context = context;
        model.setSql(this.getDefaultSql());
        this.initStartingParameterValues();
        this.setName(NAME);
    }

    void initStartingParameterValues() {
        this.startingParameterValues.copyParametersFrom((NamedParams)this.transMeta);
    }

    public void init() throws InvocationTargetException, XulException {
        this.bindingFactory.setDocument(this.getXulDomContainer().getDocumentRoot());
        this.bindLogLevelsCombo(this.bindingFactory);
        this.bindSqlText(this.bindingFactory);
        this.bindStreamingWindowParameters(this.bindingFactory);
        this.bindButtons(this.bindingFactory);
        this.bindMaxRowsCombo(this.bindingFactory);
        this.bindErrorAlert(this.bindingFactory);
        this.bindOptImpactInfo(this.bindingFactory);
    }

    public boolean hideStreaming() {
        return !this.dataService.isStreaming();
    }

    private void bindButtons(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        this.bindExecutingButton(bindingFactory, (XulButton)this.document.getElementById("preview-opt-btn"));
        XulButton execButton = (XulButton)this.document.getElementById("exec-sql-btn");
        if (this.dataService.isStreaming()) {
            bindingFactory.createBinding((Object)this.model, "streaming", (Object)execButton, "label", new BindingConvertor[]{new BindingConvertor<Boolean, String>(){

                public String sourceToTarget(Boolean value) {
                    return BaseMessages.getString(PKG, (String)(value != false ? "DataServiceTest.Execute.Stop.Button" : "DataServiceTest.Execute.Button"), (String[])new String[0]);
                }

                public Boolean targetToSource(String value) {
                    return false;
                }
            }});
        } else {
            this.bindExecutingButton(bindingFactory, execButton);
        }
    }

    private void bindExecutingButton(BindingFactory bindingFactory, XulButton button) throws XulException, InvocationTargetException {
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        Binding binding = bindingFactory.createBinding((Object)this.model, "executing", (Object)button, "disabled", new BindingConvertor[0]);
        binding.initialize();
        binding.fireSourceChanged();
    }

    private void bindErrorAlert(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        XulLabel errorAlert = (XulLabel)this.document.getElementById("error-alert");
        this.model.setAlertMessage("");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        Binding binding = bindingFactory.createBinding((Object)this.model, "alertMessage", (Object)errorAlert, "value", new BindingConvertor[0]);
        binding.initialize();
        binding.fireSourceChanged();
    }

    private void bindOptImpactInfo(BindingFactory bindingFactory) {
        XulTextbox maxRows = (XulTextbox)this.document.getElementById("optimization-impact-info");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        Binding binding = bindingFactory.createBinding((Object)this.model, "optimizationImpactDescription", (Object)maxRows, "value", new BindingConvertor[0]);
        binding.initialize();
    }

    private void bindMaxRowsCombo(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        this.bindMaxRowsComboValues(bindingFactory);
        this.bindSelectedMaxRows(bindingFactory);
    }

    private void bindMaxRowsComboValues(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        assert (this.document.getElementById("maxrows-combo") instanceof XulMenuList);
        this.maxRows = (XulMenuList)this.document.getElementById("maxrows-combo");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        if (!this.dataService.isStreaming()) {
            bindingFactory.createBinding((Object)this.model, "allMaxRows", this.maxRows, "elements", new BindingConvertor[0]).fireSourceChanged();
        }
        this.maxRows.setDisabled(this.dataService.isStreaming());
    }

    private void bindSelectedMaxRows(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        Binding binding = bindingFactory.createBinding((Object)this.model, "maxRows", this.maxRows, "selectedItem", new BindingConvertor[0]);
        binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
        BindingConvertor<Integer, Integer> maxRowsConverter = new BindingConvertor<Integer, Integer>(){

            public Integer sourceToTarget(Integer value) {
                return DataServiceTestModel.MAXROWS_CHOICES.indexOf(value);
            }

            public Integer targetToSource(Integer value) {
                return DataServiceTestModel.MAXROWS_CHOICES.indexOf(value);
            }
        };
        binding.setConversion((BindingConvertor)maxRowsConverter);
        binding.initialize();
        binding.fireSourceChanged();
    }

    private void bindLogLevelsCombo(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        this.bindLogLevelComboValues(bindingFactory);
        this.bindSelectedLogLevel(bindingFactory);
    }

    private void bindLogLevelComboValues(BindingFactory bindingFactory) throws XulException, InvocationTargetException {
        assert (this.document.getElementById("log-levels") instanceof XulMenuList);
        this.logLevels = (XulMenuList)this.document.getElementById("log-levels");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        bindingFactory.createBinding((Object)this.model, "allLogLevels", this.logLevels, "elements", new BindingConvertor[0]).fireSourceChanged();
    }

    private void bindSelectedLogLevel(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        Binding logBinding = bindingFactory.createBinding((Object)this.model, "logLevel", this.logLevels, "selectedItem", new BindingConvertor[0]);
        logBinding.setBindingType(Binding.Type.BI_DIRECTIONAL);
        BindingConvertor<LogLevel, String> logLevelConverter = new BindingConvertor<LogLevel, String>(){

            public String sourceToTarget(LogLevel value) {
                return value.getDescription();
            }

            public LogLevel targetToSource(String value) {
                for (LogLevel level : LogLevel.values()) {
                    if (!level.getDescription().equals(value)) continue;
                    return level;
                }
                throw new IllegalArgumentException(String.format("'%s' does not correspond to a valid LogLevel value.", value));
            }
        };
        logBinding.setConversion((BindingConvertor)logLevelConverter);
        logBinding.initialize();
        logBinding.fireSourceChanged();
    }

    private void bindSqlText(BindingFactory bindingFactory) {
        assert (this.document.getElementById("sql-textbox") instanceof XulTextbox);
        XulTextbox sqlTextBox = (XulTextbox)this.document.getElementById("sql-textbox");
        String initSql = this.getDefaultSql();
        this.model.setSql(initSql);
        sqlTextBox.setValue(initSql);
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindingFactory.createBinding((Object)this.model, "sql", (Object)sqlTextBox, "value", new BindingConvertor[0]);
    }

    private void bindStreamingWindowParameters(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        assert (this.document.getElementById("streaming-groupbox") instanceof XulGroupbox);
        assert (this.document.getElementById("time-based-radio") instanceof XulRadio);
        assert (this.document.getElementById("row-based-radio") instanceof XulRadio);
        assert (this.document.getElementById("window-size") instanceof XulTextbox);
        assert (this.document.getElementById("window-every") instanceof XulTextbox);
        assert (this.document.getElementById("window-limit") instanceof XulTextbox);
        assert (this.document.getElementById("window-size-time-unit") instanceof XulLabel);
        assert (this.document.getElementById("window-every-time-unit") instanceof XulLabel);
        assert (this.document.getElementById("window-limit-time-unit") instanceof XulLabel);
        assert (this.document.getElementById("window-size-row-unit") instanceof XulLabel);
        assert (this.document.getElementById("window-every-row-unit") instanceof XulLabel);
        assert (this.document.getElementById("window-limit-row-unit") instanceof XulLabel);
        XulGroupbox streamingGroupBox = (XulGroupbox)this.document.getElementById("streaming-groupbox");
        streamingGroupBox.setVisible(this.dataService.isStreaming());
        XulRadio timeBasedRadio = (XulRadio)this.document.getElementById("time-based-radio");
        XulRadio rowBasedRadio = (XulRadio)this.document.getElementById("row-based-radio");
        XulTextbox sizeTextBox = (XulTextbox)this.document.getElementById("window-size");
        XulTextbox everyTextBox = (XulTextbox)this.document.getElementById("window-every");
        XulTextbox limitTextBox = (XulTextbox)this.document.getElementById("window-limit");
        XulLabel sizeTimeUnitLabel = (XulLabel)this.document.getElementById("window-size-time-unit");
        XulLabel everyTimeUnitLabel = (XulLabel)this.document.getElementById("window-every-time-unit");
        XulLabel limitTimeUnitLabel = (XulLabel)this.document.getElementById("window-limit-time-unit");
        XulLabel sizeRowUnitLabel = (XulLabel)this.document.getElementById("window-size-row-unit");
        XulLabel everyRowUnitLabel = (XulLabel)this.document.getElementById("window-every-row-unit");
        XulLabel limitRowUnitLabel = (XulLabel)this.document.getElementById("window-limit-row-unit");
        this.model.setWindowMode(IDataServiceClientService.StreamingMode.TIME_BASED);
        timeBasedRadio.setSelected(true);
        rowBasedRadio.setSelected(false);
        sizeTimeUnitLabel.setVisible(true);
        everyTimeUnitLabel.setVisible(true);
        limitTimeUnitLabel.setVisible(false);
        sizeRowUnitLabel.setVisible(false);
        everyRowUnitLabel.setVisible(false);
        limitRowUnitLabel.setVisible(true);
        sizeTextBox.setValue("");
        everyTextBox.setValue("");
        limitTextBox.setValue("");
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindingFactory.createBinding((Object)this.model, "windowSize", (Object)sizeTextBox, "value", new BindingConvertor[]{BindingConverters.longToStringEmptyZero()});
        bindingFactory.createBinding((Object)this.model, "windowEvery", (Object)everyTextBox, "value", new BindingConvertor[]{BindingConverters.longToStringEmptyZero()});
        bindingFactory.createBinding((Object)this.model, "windowLimit", (Object)limitTextBox, "value", new BindingConvertor[]{BindingConverters.longToStringEmptyZero()});
        bindingFactory.createBinding((Object)this.model, "timeBased", (Object)timeBasedRadio, "selected", new BindingConvertor[0]).fireSourceChanged();
        bindingFactory.createBinding((Object)this.model, "rowBased", (Object)rowBasedRadio, "selected", new BindingConvertor[0]).fireSourceChanged();
        bindingFactory.createBinding((Object)timeBasedRadio, "selected", (Object)sizeTimeUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)timeBasedRadio, "selected", (Object)everyTimeUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)timeBasedRadio, "!selected", (Object)limitTimeUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)timeBasedRadio, "!selected", (Object)sizeRowUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)timeBasedRadio, "!selected", (Object)everyRowUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)timeBasedRadio, "selected", (Object)limitRowUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)rowBasedRadio, "!selected", (Object)sizeTimeUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)rowBasedRadio, "!selected", (Object)everyTimeUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)rowBasedRadio, "selected", (Object)limitTimeUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)rowBasedRadio, "selected", (Object)sizeRowUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)rowBasedRadio, "selected", (Object)everyRowUnitLabel, "visible", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)rowBasedRadio, "!selected", (Object)limitRowUnitLabel, "visible", new BindingConvertor[0]);
    }

    private String getDefaultSql() {
        return "SELECT * FROM \"" + this.dataService.getName() + "\"";
    }

    public void executeSql() throws KettleException {
        if (this.model.isStreaming()) {
            this.stopStreaming();
            return;
        }
        this.resetMetrics();
        this.dataServiceExec = this.getNewDataServiceExecutor(true);
        if (!this.dataServiceExec.getServiceTrans().isRunning()) {
            this.updateOptimizationImpact(this.dataServiceExec);
        }
        this.updateModel(this.dataServiceExec);
        AnnotationsQueryService annotationsQuery = this.getAnnotationsQueryService();
        Query query = this.dataService.isStreaming() ? annotationsQuery.prepareQuery(this.model.getSql(), this.model.getWindowMode(), this.model.getWindowSize(), this.model.getWindowEvery(), this.model.getWindowLimit(), (Map<String, String>)ImmutableMap.of()) : annotationsQuery.prepareQuery(this.model.getSql(), this.model.getMaxRows(), (Map<String, String>)ImmutableMap.of());
        if (null != query) {
            this.writeAnnotations(query);
            this.handleCompletion(this.dataServiceExec);
        } else {
            this.callback.onLogChannelUpdate();
            this.stopQuery = false;
            if (this.dataService.isStreaming()) {
                if (this.dataServiceExec.executeStreamingQuery(this.getDataServicePushObserver(), false) == null) {
                    this.handleCompletion(this.dataServiceExec);
                }
            } else if (this.dataServiceExec.executeQuery(this.getDataServiceObserver()) != null) {
                this.pollForCompletion(this.dataServiceExec);
            } else {
                this.handleCompletion(this.dataServiceExec);
            }
        }
    }

    private void stopStreaming() {
        this.model.setStreaming(false);
        this.model.setExecuting(false);
        if (this.pushObserver != null) {
            this.pushObserver.dispose();
        }
    }

    private void pollForCompletion(final DataServiceExecutor dataServiceExec) {
        final Trans svcTrans = dataServiceExec.getServiceTrans();
        final Trans genTrans = dataServiceExec.getGenTrans();
        this.completionPollTimer = new Timer("DataServiceTesterTimer");
        final long startMillis = System.currentTimeMillis();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                DataServiceTestController.this.document.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DataServiceTestController.this.model.isExecuting()) {
                            DataServiceTestController.this.checkMaxRows(dataServiceExec);
                            DataServiceTestController.this.checkForFailures(dataServiceExec);
                            DataServiceTestController.this.updateExecutingMessage(startMillis, dataServiceExec);
                            if (DataServiceTestController.this.stopQuery || DataServiceTestController.this.anyTransErrors(dataServiceExec) || DataServiceTestController.this.transDone(svcTrans, genTrans)) {
                                DataServiceTestController.this.handleCompletion(dataServiceExec);
                                DataServiceTestController.this.completionPollTimer.cancel();
                            }
                        }
                    }
                });
            }
        };
        this.completionPollTimer.schedule(task, 500L, 500L);
    }

    private boolean transDone(Trans svcTrans, Trans genTrans) {
        return this.dataService.isStreaming() ? genTrans.isFinished() : svcTrans.isFinishedOrStopped() && genTrans.isFinishedOrStopped();
    }

    private boolean anyTransErrors(DataServiceExecutor dataServiceExec) {
        return dataServiceExec.getServiceTrans().getErrors() > 0 || dataServiceExec.getGenTrans().getErrors() > 0;
    }

    private void checkForFailures(DataServiceExecutor dataServiceExec) {
        if (this.anyTransErrors(dataServiceExec)) {
            this.setErrorAlertMessage();
            this.stopDataService(dataServiceExec);
        }
    }

    private void checkMaxRows(DataServiceExecutor dataServiceExec) {
        if (!this.dataService.isStreaming() && this.model.getMaxRows() > 0 && this.model.getMaxRows() <= this.model.getResultRows().size()) {
            this.stopDataService(dataServiceExec);
        }
    }

    private void stopDataService(DataServiceExecutor dataServiceExec) {
        dataServiceExec.stop(true);
    }

    private void updateExecutingMessage(long start, DataServiceExecutor dataServiceExec) {
        if (!this.anyTransErrors(dataServiceExec)) {
            this.model.setAlertMessage(BaseMessages.getString(PKG, (String)"DataServiceTest.RowsReturned.Text", (Object[])new Object[]{this.model.getResultRows().size(), System.currentTimeMillis() - start}));
        }
    }

    private void handleCompletion(DataServiceExecutor dataServiceExec) {
        this.maybeSetErrorAlert(dataServiceExec);
        this.transMeta.setName(this.transName);
        this.model.setExecuting(false);
        this.callback.onExecuteComplete();
    }

    private void resetMetrics() {
        this.resetMetrics(this.model.getServiceTransLogChannel());
        this.resetMetrics(this.model.getGenTransLogChannel());
    }

    private void resetMetrics(LogChannelInterface logChannel) {
        LoggingRegistry loggingRegistry = LoggingRegistry.getInstance();
        MetricsRegistry metricsRegistry = MetricsRegistry.getInstance();
        if (logChannel != null) {
            for (String channelId : loggingRegistry.getLogChannelChildren(logChannel.getLogChannelId())) {
                metricsRegistry.getSnapshotLists().remove(channelId);
            }
        }
    }

    public void previewQueries() throws KettleException {
        DataServiceExecutor dataServiceExec = this.getNewDataServiceExecutor(false);
        if (!dataServiceExec.getServiceTrans().isRunning()) {
            this.updateOptimizationImpact(dataServiceExec);
        }
    }

    private void updateOptimizationImpact(DataServiceExecutor dataServiceExec) {
        this.model.clearOptimizationImpact();
        for (PushDownOptimizationMeta optMeta : this.dataService.getPushDownOptimizationMeta()) {
            this.model.addOptimizationImpact(optMeta.preview(dataServiceExec));
        }
    }

    private void maybeSetErrorAlert(DataServiceExecutor dataServiceExec) {
        if (dataServiceExec.getGenTrans().getErrors() > 0 || dataServiceExec.getServiceTrans() != null && dataServiceExec.getServiceTrans().getErrors() > 0) {
            this.setErrorAlertMessage();
        }
    }

    private void setErrorAlertMessage() {
        this.model.setAlertMessage(BaseMessages.getString(PKG, (String)"DataServiceTest.Errors.Label", (String[])new String[0]));
    }

    protected DataServiceExecutor getNewDataServiceExecutor(boolean enableMetrics) throws KettleException {
        try {
            this.resetVariablesAndParameters();
            DataServiceExecutor.Builder builder = this.dataService.isStreaming() ? new DataServiceExecutor.Builder(new SQL(this.model.getSql()), this.dataService, this.context).rowLimit(this.dataService.getRowLimit()).timeLimit(this.dataService.getTimeLimit()).logLevel(this.model.getLogLevel()).enableMetrics(enableMetrics).windowMode(this.model.getWindowMode()).windowSize(this.model.getWindowSize()).windowEvery(this.model.getWindowEvery()).windowLimit(this.model.getWindowLimit()) : new DataServiceExecutor.Builder(new SQL(this.model.getSql()), this.dataService, this.context).rowLimit(this.model.getMaxRows()).logLevel(this.model.getLogLevel()).enableMetrics(enableMetrics);
            return builder.build();
        }
        catch (KettleException e) {
            this.model.setAlertMessage(e.getMessage());
            throw e;
        }
    }

    private void resetVariablesAndParameters() throws KettleException {
        for (StepMeta stepMeta : this.transMeta.getSteps()) {
            DatabaseMeta dbMeta;
            if (!(stepMeta.getStepMetaInterface() instanceof TableInputMeta) || (dbMeta = ((TableInputMeta)stepMeta.getStepMetaInterface()).getDatabaseMeta()) == null) continue;
            dbMeta.copyVariablesFrom((VariableSpace)this.transMeta);
        }
        if (this.startingParameterValues.listParameters().length > 0) {
            this.transMeta.copyParametersFrom(this.startingParameterValues);
        }
    }

    private void updateModel(DataServiceExecutor dataServiceExec) throws KettleException {
        this.model.setExecuting(true);
        this.model.setResultRowMeta(this.sqlFieldsToRowMeta(dataServiceExec));
        this.model.clearResultRows();
        this.model.setAlertMessage("");
        this.model.setServiceTransLogChannel(dataServiceExec.getServiceTrans().getLogChannel());
        this.model.setGenTransLogChannel(dataServiceExec.getGenTrans().getLogChannel());
    }

    private RowMetaInterface sqlFieldsToRowMeta(DataServiceExecutor dataServiceExec) throws KettleException {
        List fields = dataServiceExec.getSql().getSelectFields().getFields();
        RowMetaInterface rowMeta = dataServiceExec.getSql().getRowMeta();
        RowMeta sqlFieldsRowMeta = new RowMeta();
        List<String> fieldNames = Arrays.asList(rowMeta.getFieldNames());
        for (SQLField field : fields) {
            int indexOfField = fieldNames.indexOf(field.getField());
            sqlFieldsRowMeta.addValueMeta(rowMeta.getValueMeta(indexOfField));
        }
        return sqlFieldsRowMeta;
    }

    private IDisposableObserver<List<RowMetaAndData>> getDataServicePushObserver() {
        if (this.pushObserver == null) {
            this.pushObserver = new IDisposableObserver<List<RowMetaAndData>>(){
                private Disposable toDispose;
                long start;
                final Object rowsMutex = new Object();
                private boolean updating;
                private boolean first;

                public void onSubscribe(Disposable d) {
                    this.toDispose = d;
                    DataServiceTestController.this.document.invokeLater(() -> DataServiceTestController.this.model.setStreaming(true));
                    this.start = System.currentTimeMillis();
                    this.updating = false;
                    this.first = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNext(List<RowMetaAndData> rowsList) {
                    Object object = this.rowsMutex;
                    synchronized (object) {
                        DataServiceTestController.this.model.clearResultRows();
                        if (!rowsList.isEmpty()) {
                            DataServiceTestController.this.model.setResultRowMeta(rowsList.get(0).getRowMeta());
                            rowsList.stream().map(RowMetaAndData::getData).forEach(DataServiceTestController.this.model::addResultRow);
                        }
                        long batchStart = this.start;
                        this.start = System.currentTimeMillis();
                        if (!this.updating) {
                            this.updating = true;
                            DataServiceTestController.this.document.invokeLater(() -> {
                                Object object = this.rowsMutex;
                                synchronized (object) {
                                    if (this.isDisposed()) {
                                        return;
                                    }
                                    DataServiceTestController.this.updateExecutingMessage(batchStart, DataServiceTestController.this.dataServiceExec);
                                    DataServiceTestController.this.maybeSetErrorAlert(DataServiceTestController.this.dataServiceExec);
                                    if (this.first) {
                                        this.first = false;
                                        DataServiceTestController.this.callback.onExecuteComplete();
                                    } else {
                                        DataServiceTestController.this.callback.onUpdate(DataServiceTestController.this.model.getResultRows());
                                    }
                                    this.updating = false;
                                }
                            });
                        }
                    }
                }

                public void onError(Throwable e) {
                    DataServiceTestController.this.document.invokeLater(() -> DataServiceTestController.this.model.setStreaming(false));
                }

                public void onComplete() {
                    DataServiceTestController.this.document.invokeLater(() -> DataServiceTestController.this.model.setStreaming(false));
                }

                public void dispose() {
                    if (this.toDispose != null) {
                        this.toDispose.dispose();
                    }
                }

                public boolean isDisposed() {
                    return this.toDispose != null && this.toDispose.isDisposed();
                }
            };
        }
        return this.pushObserver;
    }

    private Observer<RowMetaAndData> getDataServiceObserver() {
        PublishSubject consumer = PublishSubject.create();
        consumer.doOnComplete(() -> {
            this.stopQuery = true;
        }).subscribe(rowMetaAndData -> {
            this.model.addResultRow(rowMetaAndData.getData());
            this.model.setResultRowMeta(rowMetaAndData.getRowMeta());
        });
        return consumer;
    }

    public void close() throws KettleException {
        this.cleanupCurrentExec();
        this.resetVariablesAndParameters();
        this.clearLogLines();
        this.callback.onClose();
    }

    private void cleanupCurrentExec() {
        if (this.completionPollTimer != null) {
            this.completionPollTimer.cancel();
        }
        if (this.dataServiceExec != null) {
            this.stopDataService(this.dataServiceExec);
            String streamingServiceName = this.dataService.getName();
            this.context.removeServiceTransExecutor(streamingServiceName);
        }
        this.model.setExecuting(false);
        this.model.setStreaming(false);
        if (this.pushObserver != null && !this.pushObserver.isDisposed()) {
            this.pushObserver.dispose();
        }
    }

    private void clearLogLines() {
        if (this.model.getGenTransLogChannel() != null) {
            KettleLogStore.discardLines((String)this.model.getGenTransLogChannel().getLogChannelId(), (boolean)true);
        }
        if (this.model.getServiceTransLogChannel() != null) {
            KettleLogStore.discardLines((String)this.model.getServiceTransLogChannel().getLogChannelId(), (boolean)true);
        }
    }

    public void setCallback(DataServiceTestCallback callback) {
        this.callback = callback;
    }

    public void setAnnotationsQueryService(AnnotationsQueryService annotationsQueryService) {
        this.annotationsQueryService = annotationsQueryService;
    }

    public AnnotationsQueryService getAnnotationsQueryService() {
        if (null == this.annotationsQueryService) {
            this.annotationsQueryService = new AnnotationsQueryService(new MetastoreLocator(){

                public IMetaStore getMetastore(String providerKey) {
                    return null;
                }

                public IMetaStore getMetastore() {
                    return null;
                }

                public String setEmbeddedMetastore(IMetaStore metastore) {
                    return null;
                }

                public void disposeMetastoreProvider(String providerKey) {
                }

                public IMetaStore getExplicitMetastore(String providerKey) {
                    return null;
                }
            }, new TestResolver());
        }
        return this.annotationsQueryService;
    }

    private void writeAnnotations(Query query) throws KettleException {
        this.model.clearResultRows();
        ByteArrayOutputStream annoStream = new ByteArrayOutputStream();
        String annoString = null;
        try {
            query.writeTo(annoStream);
            List annoList = IOUtils.readLines((InputStream)new ByteArrayInputStream(annoStream.toByteArray()));
            int startIndex = annoList.indexOf("<annotations> ");
            annoString = annoList.subList(startIndex, annoList.size()).stream().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            this.model.setAlertMessage(BaseMessages.getString(PKG, (String)"DataServiceTest.UnableToRetrieveAnnotations.Message", (String[])new String[0]));
            throw new KettleException(BaseMessages.getString(PKG, (String)"DataServiceTest.UnableToRetrieveAnnotations.Message", (String[])new String[0]));
        }
        ValueMetaString valueMeta = new ValueMetaString("annotations");
        valueMeta.setStorageType(1);
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("annotations"));
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        this.model.setResultRowMeta((RowMetaInterface)rowMeta);
        if (null != annoString) {
            Object[] row = null;
            try {
                row = new Object[]{annoString.getBytes(Charset.forName("UTF-8"))};
            }
            catch (NullPointerException e) {
                this.model.setAlertMessage(BaseMessages.getString(PKG, (String)"DataServiceTest.UnableToRetrieveAnnotations.Message", (String[])new String[0]));
                throw new KettleException(BaseMessages.getString(PKG, (String)"DataServiceTest.UnableToRetrieveAnnotations.Message", (String[])new String[0]));
            }
            if (null != row) {
                this.model.addResultRow(row);
            }
        }
    }

    class TestResolver
    implements DataServiceResolver {
        TestResolver() {
        }

        @Override
        public DataServiceMeta getDataService(String dataServiceName) {
            return DataServiceTestController.this.dataService;
        }

        @Override
        public List<DataServiceMeta> getDataServices(Function<Exception, Void> logger) {
            return null;
        }

        @Override
        public List<DataServiceMeta> getDataServices(String dataServiceName, Function<Exception, Void> logger) {
            return null;
        }

        @Override
        public List<String> getDataServiceNames() {
            return null;
        }

        @Override
        public List<String> getDataServiceNames(String dataServiceName) {
            return null;
        }

        @Override
        public DataServiceExecutor.Builder createBuilder(SQL sql) throws KettleException {
            return null;
        }
    }

    private static interface IDisposableObserver<T>
    extends Disposable,
    Observer<T> {
    }
}

