/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.resolvers;

import com.google.common.base.Function;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;

public class DataServiceResolverDelegate
implements DataServiceResolver {
    private List<DataServiceResolver> resolvers;

    public DataServiceResolverDelegate() {
        this.resolvers = new ArrayList<DataServiceResolver>();
    }

    public DataServiceResolverDelegate(List<DataServiceResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public void addResolver(DataServiceResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void removeResolver(DataServiceResolver resolver) {
        this.resolvers.remove(resolver);
    }

    @Override
    public List<DataServiceMeta> getDataServices(Function<Exception, Void> logger) {
        ArrayList<DataServiceMeta> dataServiceMetas = new ArrayList<DataServiceMeta>();
        for (DataServiceResolver resolver : this.resolvers) {
            dataServiceMetas.addAll(resolver.getDataServices(logger));
        }
        return dataServiceMetas;
    }

    @Override
    public List<DataServiceMeta> getDataServices(String dataServiceName, Function<Exception, Void> logger) {
        ArrayList<DataServiceMeta> dataServiceMetas = new ArrayList<DataServiceMeta>();
        for (DataServiceResolver resolver : this.resolvers) {
            dataServiceMetas.addAll(resolver.getDataServices(dataServiceName, logger));
        }
        return dataServiceMetas;
    }

    @Override
    public DataServiceMeta getDataService(String dataServiceName) {
        for (DataServiceResolver resolver : this.resolvers) {
            DataServiceMeta dataServiceMeta = resolver.getDataService(dataServiceName);
            if (dataServiceMeta == null) continue;
            return dataServiceMeta;
        }
        return null;
    }

    @Override
    public List<String> getDataServiceNames(String dataServiceName) {
        ArrayList<String> dataServiceNames = new ArrayList<String>();
        for (DataServiceResolver resolver : this.resolvers) {
            dataServiceNames.addAll(resolver.getDataServiceNames(dataServiceName));
        }
        return dataServiceNames;
    }

    @Override
    public DataServiceExecutor.Builder createBuilder(SQL sql) throws KettleException {
        boolean foundDataService = false;
        for (DataServiceResolver resolver : this.resolvers) {
            DataServiceExecutor.Builder builder = resolver.createBuilder(sql);
            if (builder != null) {
                return builder;
            }
            foundDataService = foundDataService || resolver.getDataService(sql.getServiceName()) != null;
        }
        throw new KettleException(foundDataService ? "Error when creating builder for sql query" : MessageFormat.format("Data Service {0} was not found", sql.getServiceName()));
    }

    @Override
    public List<String> getDataServiceNames() {
        ArrayList<String> dataServiceNames = new ArrayList<String>();
        for (DataServiceResolver resolver : this.resolvers) {
            dataServiceNames.addAll(resolver.getDataServiceNames());
        }
        return dataServiceNames;
    }
}

