/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.mongod;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.HashMap;
import java.util.Map;

public enum MongoOp {
    AND(2){

        @Override
        public void apply(QueryBuilder queryBuilder, DBObject ... ands) {
            queryBuilder.and(ands);
        }
    }
    ,
    OR(1){

        @Override
        public void apply(QueryBuilder queryBuilder, DBObject ... ors) {
            queryBuilder.or(ors);
        }
    };

    private final int kettleOpCode;
    private static final Map<Integer, MongoOp> kettleToMongo;

    public static MongoOp getMongoOp(int kettleOpCode) {
        return kettleToMongo.get(kettleOpCode);
    }

    private MongoOp(int kettleOperator) {
        this.kettleOpCode = kettleOperator;
    }

    public abstract void apply(QueryBuilder var1, DBObject ... var2);

    static {
        kettleToMongo = new HashMap<Integer, MongoOp>();
        for (MongoOp op : MongoOp.values()) {
            kettleToMongo.put(op.kettleOpCode, op);
        }
    }
}

