/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3n.vfs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class S3NDataContent {
    private static final String TEMP_FILE_PREFIX = "s3vfs";
    private static final String S3VFS_USE_TEMPORARY_FILE_ON_UPLOAD_DATA = "s3.vfs.useTempFileOnUploadData";
    private boolean useTempFileOnUploadData = "Y".equals(System.getProperty("s3.vfs.useTempFileOnUploadData", "N"));
    private Path dataFile;
    private OutputStream dataStream;
    private boolean isLoaded;

    static Path createTempFile() throws IOException {
        Path tmpFile = Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]);
        tmpFile.toFile().deleteOnExit();
        return tmpFile;
    }

    public void load() throws IOException {
        if (!this.isLoaded) {
            OutputStream output = null;
            Path tmpFile = null;
            if (this.useTempFileOnUploadData) {
                tmpFile = S3NDataContent.createTempFile();
                output = Files.newOutputStream(tmpFile, StandardOpenOption.APPEND);
            } else {
                output = new ByteArrayOutputStream();
            }
            this.dataFile = tmpFile;
            this.dataStream = output;
            this.isLoaded = true;
        }
    }

    public File asFile() {
        return this.dataFile != null ? this.dataFile.toFile() : null;
    }

    public ByteArrayOutputStream asByteArrayStream() {
        if (this.dataStream instanceof ByteArrayOutputStream) {
            return (ByteArrayOutputStream)this.dataStream;
        }
        return null;
    }

    public boolean isUseTempFileOnUploadData() {
        return this.useTempFileOnUploadData;
    }

    public OutputStream getDataToUpload() throws IOException {
        return this.dataStream;
    }
}

