/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.manager.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.pentaho.osgi.manager.resource.api.ResourceHandler;
import org.pentaho.osgi.manager.resource.api.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedResourceHandler
implements ResourceHandler {
    private ResourceProvider managedResourceProvider;
    private Logger logger = LoggerFactory.getLogger(ManagedResourceHandler.class);
    public static String BUNDLE_MANAGED_RESOURCES_DIR = "/managed-resources";

    public void setManagedResourceProvider(ResourceProvider resourceProvider) {
        this.managedResourceProvider = resourceProvider;
    }

    @Override
    public boolean hasManagedResources(Bundle bundle) {
        try {
            return bundle.getResources(BUNDLE_MANAGED_RESOURCES_DIR) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void handleManagedResources(Bundle blueprintBundle) {
        File to = this.getOutputDirectory(blueprintBundle);
        this.writeFilesToDisk(blueprintBundle, BUNDLE_MANAGED_RESOURCES_DIR, to);
    }

    protected File getOutputDirectory(Bundle blueprintBundle) {
        File managedResourcesFolder = this.managedResourceProvider.getManagedResourceFolder();
        File to = Paths.get(managedResourcesFolder.getAbsolutePath(), blueprintBundle.getSymbolicName()).toFile();
        if (!to.exists()) {
            to.mkdirs();
        }
        return to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeFilesToDisk(Bundle bundle, String bundleSource, File to) {
        InputStream in = null;
        OutputStream out = null;
        try {
            Enumeration fileUrls = bundle.findEntries(bundleSource, null, true);
            if (fileUrls == null || !fileUrls.hasMoreElements()) {
                boolean bl = false;
                return bl;
            }
            while (fileUrls.hasMoreElements()) {
                URL url = (URL)fileUrls.nextElement();
                Path outPath = Paths.get(to.getPath(), url.getFile().replace(BUNDLE_MANAGED_RESOURCES_DIR, ""));
                File outFile = outPath.toFile();
                String fileName = outPath.getFileName().toString();
                if (outFile.exists()) continue;
                if (fileName.matches(".+\\..+")) {
                    this.copyStream(url, outFile.getAbsolutePath());
                    continue;
                }
                outFile.mkdir();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
        return true;
    }

    protected void copyStream(URL inUrl, String outAbsolutPath) throws IOException {
        InputStream in = inUrl.openStream();
        FileOutputStream out = new FileOutputStream(outAbsolutPath);
        IOUtils.copy((InputStream)in, (OutputStream)out);
    }
}

