/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.session;

import java.util.Collection;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.web.http.api.resources.utils.SystemUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import pt.webdetails.cpf.session.IUserSession;

public class PentahoSession
implements IUserSession {
    private IPentahoSession userSession;

    public PentahoSession() {
        this(null);
    }

    public PentahoSession(IPentahoSession userSession) {
        this.userSession = userSession == null ? PentahoSessionHolder.getSession() : userSession;
    }

    public String getUserName() {
        return this.userSession.getName();
    }

    public boolean isAdministrator() {
        return SystemUtils.canAdminister();
    }

    public IPentahoSession getPentahoSession() {
        return this.userSession;
    }

    public String[] getAuthorities() {
        Authentication auth = SecurityHelper.getInstance().getAuthentication(PentahoSessionHolder.getSession(), true);
        Collection authorities = auth.getAuthorities();
        String[] result = new String[authorities.size()];
        int i = 0;
        for (GrantedAuthority authority : authorities) {
            result[i++] = authority.getAuthority();
        }
        return result;
    }

    public Object getParameter(String name) {
        if (name != null) {
            return this.userSession.getAttribute(name.toString());
        }
        return null;
    }

    public String getStringParameter(String name) {
        Object r = this.getParameter(name);
        if (r != null) {
            return r.toString();
        }
        return null;
    }

    public void setParameter(String key, Object value) {
        this.userSession.setAttribute(key.toString(), value);
    }
}

