/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.event.EventSource;
import org.hibernate.event.LockEvent;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.def.AbstractLockUpgradeEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultLockEventListener
extends AbstractLockUpgradeEventListener
implements LockEventListener {
    public void onLock(LockEvent event) throws HibernateException {
        if (event.getObject() == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (event.getLockMode() == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for lock()");
        }
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContext().unproxyAndReassociate(event.getObject());
        EntityEntry entry = source.getPersistenceContext().getEntry(entity);
        if (entry == null) {
            EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
            Serializable id = persister.getIdentifier(entity, source);
            if (!ForeignKeys.isNotTransient(event.getEntityName(), entity, Boolean.FALSE, source)) {
                throw new TransientObjectException("cannot lock an unsaved transient instance: " + persister.getEntityName());
            }
            entry = this.reassociate(event, entity, id, persister);
            this.cascadeOnLock(event, persister, entity);
        }
        this.upgradeLock(entity, entry, event.getLockOptions(), event.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnLock(LockEvent event, EntityPersister persister, Object entity) {
        EventSource source = event.getSession();
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.LOCK, 0, source).cascade(persister, entity, event.getLockOptions());
            Object var6_5 = null;
            source.getPersistenceContext().decrementCascadeLevel();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            source.getPersistenceContext().decrementCascadeLevel();
            throw throwable;
        }
    }
}

