/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceKeyPairProvider
extends AbstractKeyPairProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader cloader;
    private String[] resources;
    private PasswordFinder passwordFinder;

    public ResourceKeyPairProvider() {
        this.cloader = this.getClass().getClassLoader();
    }

    public ResourceKeyPairProvider(String[] resources) {
        this.cloader = this.getClass().getClassLoader();
        this.resources = resources;
    }

    public ResourceKeyPairProvider(String[] resources, PasswordFinder passwordFinder) {
        this.cloader = this.getClass().getClassLoader();
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public ResourceKeyPairProvider(String[] resources, PasswordFinder passwordFinder, ClassLoader cloader) {
        this.cloader = cloader;
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public PasswordFinder getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(PasswordFinder passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        return new Iterable<KeyPair>(){

            @Override
            public Iterator<KeyPair> iterator() {
                return new Iterator<KeyPair>(){
                    private final Iterator<String> iterator;
                    private KeyPair nextKeyPair;
                    private boolean nextKeyPairSet;
                    {
                        this.iterator = Arrays.asList(ResourceKeyPairProvider.this.resources).iterator();
                        this.nextKeyPairSet = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextKeyPairSet || this.setNextObject();
                    }

                    @Override
                    public KeyPair next() {
                        if (!this.nextKeyPairSet && !this.setNextObject()) {
                            throw new NoSuchElementException();
                        }
                        this.nextKeyPairSet = false;
                        return this.nextKeyPair;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private boolean setNextObject() {
                        while (this.iterator.hasNext()) {
                            String file = this.iterator.next();
                            this.nextKeyPair = ResourceKeyPairProvider.this.doLoadKey(file);
                            if (this.nextKeyPair == null) continue;
                            this.nextKeyPairSet = true;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyPair doLoadKey(String resource) {
        InputStream is;
        InputStreamReader isr;
        PEMParser r;
        block7: {
            KeyPair keyPair;
            Object o;
            block6: {
                r = null;
                isr = null;
                is = null;
                is = this.cloader.getResourceAsStream(resource);
                isr = new InputStreamReader(is);
                r = new PEMParser((Reader)isr);
                o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                pemConverter.setProvider("BC");
                if (this.passwordFinder != null && o instanceof PEMEncryptedKeyPair) {
                    JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                    PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(this.passwordFinder.getPassword());
                    o = pemConverter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor));
                }
                if (!(o instanceof PEMKeyPair)) break block6;
                o = pemConverter.getKeyPair((PEMKeyPair)o);
                keyPair = (KeyPair)o;
                IoUtils.closeQuietly(new Closeable[]{r, is, isr});
                return keyPair;
            }
            try {
                if (!(o instanceof KeyPair)) break block7;
                keyPair = (KeyPair)o;
            }
            catch (Exception e) {
                try {
                    this.log.warn("Unable to read key " + resource, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(new Closeable[]{r, is, isr});
                    throw throwable;
                }
                IoUtils.closeQuietly(new Closeable[]{r, is, isr});
            }
            IoUtils.closeQuietly(new Closeable[]{r, is, isr});
            return keyPair;
        }
        IoUtils.closeQuietly(new Closeable[]{r, is, isr});
        return null;
    }
}

