/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.invocationhandler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import org.pentaho.hadoop.shim.common.HiveSQLUtils;
import org.pentaho.hadoop.shim.common.invocationhandler.ConnectionInvocationHandler;

public class DriverInvocationHandler
implements InvocationHandler {
    Driver driver;

    public DriverInvocationHandler(Driver obj) {
        this.driver = obj;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object o = method.invoke((Object)this.driver, args);
            if (o instanceof Connection) {
                Connection proxiedConnection = (Connection)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler((Connection)o));
                String dbName = HiveSQLUtils.getDatabaseNameFromURL((String)args[0]);
                DriverInvocationHandler.useSchema(dbName, proxiedConnection.createStatement());
                return proxiedConnection;
            }
            return o;
        }
        catch (Throwable t) {
            throw t instanceof InvocationTargetException ? t.getCause() : t;
        }
    }

    protected static void useSchema(String dbName, Statement statement) throws SQLException {
        if (dbName.trim().length() > 0) {
            String queries = String.format("use %s", dbName);
            statement.execute(queries);
        }
    }
}

