/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPrepareStatementExtendedCommand
implements Command {
    private static final long serialVersionUID = 3760559793366120249L;
    private String _sql;
    private int _autoGeneratedKeys;
    private int[] _columnIndexes;
    private String[] _columnNames;

    public ConnectionPrepareStatementExtendedCommand() {
    }

    public ConnectionPrepareStatementExtendedCommand(String sql, int autoGeneratedKeys) {
        this._sql = sql;
        this._autoGeneratedKeys = autoGeneratedKeys;
    }

    public ConnectionPrepareStatementExtendedCommand(String sql, int[] columnIndexes) {
        this._sql = sql;
        this._columnIndexes = columnIndexes;
    }

    public ConnectionPrepareStatementExtendedCommand(String sql, String[] columnNames) {
        this._sql = sql;
        this._columnNames = columnNames;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._sql);
        out.writeInt(this._autoGeneratedKeys);
        out.writeObject(this._columnIndexes);
        out.writeObject(this._columnNames);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._sql = (String)in.readObject();
        this._autoGeneratedKeys = in.readInt();
        this._columnIndexes = (int[])in.readObject();
        this._columnNames = (String[])in.readObject();
    }

    @Override
    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        String sql = ctx.resolveOrCheckQuery(this._sql);
        if (this._columnIndexes != null) {
            return ((Connection)target).prepareStatement(sql, this._columnIndexes);
        }
        if (this._columnNames != null) {
            return ((Connection)target).prepareStatement(sql, this._columnNames);
        }
        return ((Connection)target).prepareStatement(sql, this._autoGeneratedKeys);
    }

    public String toString() {
        return "ConnectionPrepareStatementCommand";
    }
}

