/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.cache;

import de.simplicit.vjdbc.cache.SimpleStatementParser;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableCache
extends TimerTask {
    private static Log _logger = LogFactory.getLog(TableCache.class);
    private static Map _sqlTypeMappingForHSql = new HashMap();
    private Connection _vjdbcConnection;
    private Connection _hsqlConnection;
    private DatabaseMetaData _dbMetaData;
    private Statement _vjdbcStatement;
    private Statement _hsqlStatement;
    private Map _tableEntries = new HashMap();
    private Timer _cacheTimer = new Timer(true);
    private SimpleStatementParser _statementParser = new SimpleStatementParser();

    public TableCache(Connection conn, String cachedTables) throws SQLException {
        this._vjdbcConnection = conn;
        this._dbMetaData = this._vjdbcConnection.getMetaData();
        this._hsqlConnection = DriverManager.getConnection("jdbc:hsqldb:.", "sa", "");
        this._vjdbcStatement = this._vjdbcConnection.createStatement();
        this._hsqlStatement = this._hsqlConnection.createStatement();
        this._cacheTimer.scheduleAtFixedRate((TimerTask)this, 10000L, 10000L);
        _logger.info((Object)"Caching of following tables:");
        StringTokenizer tok = new StringTokenizer(cachedTables, ",");
        while (tok.hasMoreTokens()) {
            this.createCacheEntry(tok.nextToken());
        }
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        boolean cachingPossible;
        Set tables = this._statementParser.getTablesOfSelectStatement(sql);
        boolean bl = cachingPossible = tables.size() > 0;
        if (cachingPossible) {
            if (this._tableEntries.keySet().containsAll(tables)) {
                for (String tableName : tables) {
                    CacheEntry ce = (CacheEntry)this._tableEntries.get(tableName);
                    if (ce != null) {
                        if (ce._isFilled) continue;
                        try {
                            this.refreshCacheEntry(ce);
                        }
                        catch (SQLException e) {
                            cachingPossible = false;
                        }
                        continue;
                    }
                    cachingPossible = false;
                }
            } else {
                cachingPossible = false;
            }
        }
        if (cachingPossible) {
            _logger.debug((Object)("Returning prepared statement from HSQL for query " + sql));
            return this._hsqlConnection.prepareStatement(sql);
        }
        return null;
    }

    private void refreshCacheEntry(CacheEntry cacheEntry) throws SQLException {
        PreparedStatement hsqlPreparedStatement = null;
        ResultSet vjdbcResultSet = null;
        try {
            hsqlPreparedStatement = this._hsqlConnection.prepareStatement(cacheEntry._insert);
            vjdbcResultSet = this._vjdbcStatement.executeQuery(cacheEntry._select);
            ResultSetMetaData rsMetaData = vjdbcResultSet.getMetaData();
            this._hsqlStatement.executeUpdate(cacheEntry._delete);
            while (vjdbcResultSet.next()) {
                for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                    hsqlPreparedStatement.setObject(i, vjdbcResultSet.getObject(i));
                }
                hsqlPreparedStatement.execute();
            }
            this._hsqlConnection.commit();
            cacheEntry._lastTimeRefreshed = System.currentTimeMillis();
            cacheEntry._isFilled = true;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Error while refreshing table " + cacheEntry._name + ", dropping it"));
            this._hsqlStatement.executeUpdate(cacheEntry._drop);
            cacheEntry._isFilled = false;
            throw e;
        }
        finally {
            if (vjdbcResultSet != null) {
                try {
                    vjdbcResultSet.close();
                }
                catch (SQLException e) {}
            }
            if (hsqlPreparedStatement != null) {
                try {
                    hsqlPreparedStatement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private void createCacheEntry(String tableConfig) throws SQLException {
        int refreshInterval;
        String table;
        int colonPos = tableConfig.indexOf(58);
        if (colonPos > 0) {
            table = tableConfig.substring(0, colonPos);
            refreshInterval = Integer.parseInt(tableConfig.substring(colonPos + 1));
            _logger.info((Object)("... " + table + " with refreshing interval " + refreshInterval));
        } else {
            table = tableConfig;
            refreshInterval = 0;
            _logger.info((Object)("... " + table + ", no refreshing"));
        }
        ResultSet rs = this._dbMetaData.getColumns(null, null, table.toUpperCase(), "%");
        StringBuffer sbCreate = new StringBuffer("CREATE TABLE " + table + " (");
        StringBuffer sbInsert = new StringBuffer("INSERT INTO " + table + " (");
        StringBuffer sbInsert2 = new StringBuffer(" VALUES (");
        StringBuffer sbSelect = new StringBuffer("SELECT ");
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            int origDataType = rs.getInt("DATA_TYPE");
            String dataType = (String)_sqlTypeMappingForHSql.get(new Integer(origDataType));
            if (dataType != null) {
                int columnSize = rs.getInt("COLUMN_SIZE");
                int decimalDigits = rs.getInt("DECIMAL_DIGITS");
                sbCreate.append(columnName).append(" ").append(dataType).append("(").append(columnSize).append(",").append(decimalDigits).append("), ");
                sbInsert.append(columnName).append(", ");
                sbInsert2.append("?, ");
                sbSelect.append("t.").append(columnName).append(", ");
                continue;
            }
            throw new SQLException("Data-Type " + origDataType + " of column " + columnName + " of table " + table + " is not supported !");
        }
        sbCreate.setLength(sbCreate.length() - 2);
        sbCreate.append(")");
        sbInsert.setLength(sbInsert.length() - 2);
        sbInsert.append(")");
        sbInsert2.setLength(sbInsert2.length() - 2);
        sbInsert2.append(")");
        sbInsert.append(sbInsert2);
        sbSelect.setLength(sbSelect.length() - 2);
        sbSelect.append(" FROM ").append(table).append(" t");
        String create = sbCreate.toString();
        String insert = sbInsert.toString();
        String select = sbSelect.toString();
        this._hsqlStatement.executeQuery(create);
        this._tableEntries.put(table.toLowerCase(), new CacheEntry(table, refreshInterval, create, insert, select));
    }

    @Override
    public void run() {
        for (CacheEntry tableEntry : this._tableEntries.values()) {
            if (tableEntry._refreshInterval <= 0 || System.currentTimeMillis() - tableEntry._lastTimeRefreshed <= (long)tableEntry._refreshInterval) continue;
            try {
                _logger.debug((Object)("Refreshing cache for table " + tableEntry._name));
                this.refreshCacheEntry(tableEntry);
                _logger.debug((Object)"... successfully refreshed");
            }
            catch (SQLException e) {
                _logger.warn((Object)"... failed", (Throwable)e);
            }
        }
    }

    static {
        _sqlTypeMappingForHSql.put(new Integer(-5), "BIGINT");
        _sqlTypeMappingForHSql.put(new Integer(-7), "BIT");
        _sqlTypeMappingForHSql.put(new Integer(1), "CHAR");
        _sqlTypeMappingForHSql.put(new Integer(91), "DATE");
        _sqlTypeMappingForHSql.put(new Integer(3), "DECIMAL");
        _sqlTypeMappingForHSql.put(new Integer(8), "DOUBLE");
        _sqlTypeMappingForHSql.put(new Integer(6), "FLOAT");
        _sqlTypeMappingForHSql.put(new Integer(4), "INTEGER");
        _sqlTypeMappingForHSql.put(new Integer(2), "NUMERIC");
        _sqlTypeMappingForHSql.put(new Integer(5), "SMALLINT");
        _sqlTypeMappingForHSql.put(new Integer(93), "TIMESTAMP");
        _sqlTypeMappingForHSql.put(new Integer(-6), "TINYINT");
        _sqlTypeMappingForHSql.put(new Integer(12), "VARCHAR");
    }

    private static class CacheEntry {
        boolean _isFilled = false;
        long _lastTimeRefreshed = System.currentTimeMillis();
        String _name;
        int _refreshInterval;
        String _create;
        String _insert;
        String _select;
        String _delete;
        String _drop;

        CacheEntry(String name, int refreshInterval, String create, String insert, String select) {
            this._name = name;
            this._refreshInterval = refreshInterval;
            this._create = create;
            this._insert = insert;
            this._delete = "DELETE FROM " + name;
            this._select = select;
            this._drop = "DROP " + name;
        }
    }
}

