/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.ui;

import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class OpenERPSelectedFieldTable
extends AbstractTableModel {
    private static final long serialVersionUID = -6328970275546027138L;
    private ArrayList<OpenERPFieldInfo> fieldPaths = new ArrayList();

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "#";
        }
        if (column == 1) {
            return "Copy #";
        }
        if (column == 2) {
            return "Field Name";
        }
        if (column == 3) {
            return "Original Field Name";
        }
        if (column == 4) {
            return "Path";
        }
        if (column == 5) {
            return "Sort #";
        }
        if (column == 6) {
            return "Direction";
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2 || columnIndex == 5 || columnIndex == 6;
    }

    public void addField(int index, OpenERPFieldInfo fieldPath) {
        if (index < 0) {
            this.fieldPaths.add(fieldPath);
        } else {
            this.fieldPaths.add(index, fieldPath);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= this.fieldPaths.size()) {
            return;
        }
        int iValue = 0;
        if (columnIndex == 1 || columnIndex == 5) {
            try {
                iValue = Integer.parseInt(aValue.toString());
            }
            catch (Exception e) {
                iValue = 0;
            }
        }
        if (columnIndex == 1) {
            this.fieldPaths.get(rowIndex).setInstanceNum(iValue);
        } else if (columnIndex == 2) {
            this.fieldPaths.get(rowIndex).setRenamedFieldName(aValue.toString());
        } else if (columnIndex == 5) {
            this.fieldPaths.get(rowIndex).setSortIndex(iValue);
        } else if (columnIndex == 6) {
            iValue = 0;
            if (aValue.toString().equals("Descending")) {
                iValue = 1;
            }
            this.fieldPaths.get(rowIndex).setSortDirection(iValue);
        }
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.fieldPaths.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex;
        }
        if (columnIndex == 1) {
            return this.fieldPaths.get(rowIndex).getInstanceNum();
        }
        if (columnIndex == 2) {
            return this.fieldPaths.get(rowIndex).getRenamedFieldName();
        }
        if (columnIndex == 3) {
            return this.fieldPaths.get(rowIndex).getFieldName();
        }
        if (columnIndex == 4) {
            return this.fieldPaths.get(rowIndex).getModelPathName();
        }
        if (columnIndex == 5) {
            return this.fieldPaths.get(rowIndex).getSortIndex();
        }
        if (columnIndex == 6) {
            if (this.fieldPaths.get(rowIndex).getSortDirection() == 0) {
                return "Ascending";
            }
            return "Descending";
        }
        return null;
    }

    public ArrayList<OpenERPFieldInfo> getFieldPaths() {
        return this.fieldPaths;
    }

    public void setFieldPaths(ArrayList<OpenERPFieldInfo> fieldPaths) {
        if (fieldPaths == null) {
            this.fieldPaths.clear();
        } else {
            this.fieldPaths = fieldPaths;
        }
        this.fireTableDataChanged();
    }

    public void removeField(int[] indexes) {
        Arrays.sort(indexes);
        for (int i = indexes.length - 1; i >= 0; --i) {
            this.fieldPaths.remove(indexes[i]);
        }
        this.fireTableDataChanged();
    }
}

