/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.ui;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.ObjectAdapter;
import com.debortoliwines.openerp.api.Session;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import com.debortoliwines.openerp.reporting.ui.OpenERPChildTreeNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class OpenERPRootTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 6644384126284842886L;
    private boolean areChildrenDefined = false;
    private Session session;
    private String modelName;

    public OpenERPRootTreeNode(Session session, String modelName) {
        this.session = session;
        this.modelName = modelName;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getChildCount() {
        if (!this.areChildrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    private void defineChildNodes() {
        this.areChildrenDefined = true;
        try {
            ObjectAdapter adapter = new ObjectAdapter(this.session, this.modelName);
            this.add(new OpenERPChildTreeNode(this.session, new OpenERPFieldInfo(this.modelName, 1, "id", "id", null, Field.FieldType.INTEGER, "", 0, 0)));
            List<String> sortedFieldNames = Arrays.asList(adapter.getFieldNames());
            Collections.sort(sortedFieldNames);
            FieldCollection fields = adapter.getFields();
            fields.SortByName();
            for (Field fld : fields) {
                this.add(new OpenERPChildTreeNode(this.session, new OpenERPFieldInfo(this.modelName, 1, fld.getName(), fld.getName(), null, fld.getType(), fld.getRelation(), 0, 0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.modelName;
    }
}

