/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.ui;

import com.debortoliwines.openerp.api.ObjectAdapter;
import com.debortoliwines.openerp.api.OpenERPXmlRpcProxy;
import com.debortoliwines.openerp.api.Row;
import com.debortoliwines.openerp.api.RowCollection;
import com.debortoliwines.openerp.api.helpers.FilterHelper;
import com.debortoliwines.openerp.reporting.di.OpenERPConfiguration;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPFilterInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPHelper;
import com.debortoliwines.openerp.reporting.di.OpenERPQueryItem;
import com.debortoliwines.openerp.reporting.ui.OpenERPChildTreeNode;
import com.debortoliwines.openerp.reporting.ui.OpenERPFilterDetailTable;
import com.debortoliwines.openerp.reporting.ui.OpenERPFilterModelsTable;
import com.debortoliwines.openerp.reporting.ui.OpenERPRootTreeNode;
import com.debortoliwines.openerp.reporting.ui.OpenERPSelectedFieldTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class OpenERPPanel
extends JPanel {
    private static final long serialVersionUID = -8365272838537964196L;
    private final JPanel contentPanel = new JPanel();
    private JTree availableTree;
    DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode("root"));
    private DataFlavor nodesFlavor;
    private JTable selectedTable;
    private OpenERPSelectedFieldTable tableModel = new OpenERPSelectedFieldTable();
    private JScrollPane scrollPane;
    private JLabel lblNewLabel;
    private JTextField txtHost;
    private JTextField txtPort;
    private JTextField txtUsername;
    private JComboBox cmbDatabase;
    private JComboBox cmbModelName;
    private JPasswordField pwdPassword;
    private JTextField txtCustomFunction;
    private JComboBox cmbDataSource;
    private JTable filterModelsTable;
    private JTable filterDetailsTable;
    private OpenERPFilterModelsTable filterModel = new OpenERPFilterModelsTable();
    private OpenERPFilterDetailTable filterDetailModel = new OpenERPFilterDetailTable();
    private OpenERPConfiguration loadAvailableConfig = null;
    private OpenERPHelper helper = new OpenERPHelper();
    private JComboBox fieldsCombo = new JComboBox<String>(new String[0]);
    private JButton btnAdd;
    private JButton btnRemove;
    private JTabbedPane tabbedPane;

    public OpenERPPanel() {
        this.setBounds(100, 100, 800, 600);
        this.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Component c;
                JTabbedPane tabPane = (JTabbedPane)arg0.getSource();
                int tabNumber = tabPane.getComponentZOrder(c = tabPane.getSelectedComponent());
                if (tabNumber == 1) {
                    OpenERPPanel.this.loadAvailableFields();
                } else if (tabNumber == 2) {
                    OpenERPPanel.this.loadFilterList();
                }
            }
        });
        this.contentPanel.add((Component)this.tabbedPane, "Center");
        JPanel pnlDataSource = new JPanel();
        this.tabbedPane.addTab("Data Source", null, pnlDataSource, null);
        this.txtHost = new JTextField();
        this.txtHost.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OpenERPPanel.this.populateDatabase();
                OpenERPPanel.this.populateModelCombo();
            }
        });
        this.txtHost.setColumns(10);
        this.txtPort = new JTextField();
        this.txtPort.setText("8069");
        this.txtPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OpenERPPanel.this.populateDatabase();
                OpenERPPanel.this.populateModelCombo();
            }
        });
        this.txtPort.setColumns(10);
        this.txtUsername = new JTextField();
        this.txtUsername.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OpenERPPanel.this.populateModelCombo();
            }
        });
        this.txtUsername.setColumns(10);
        this.cmbDatabase = new JComboBox();
        this.cmbDatabase.setEditable(true);
        this.cmbDatabase.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OpenERPPanel.this.populateModelCombo();
            }
        });
        this.cmbModelName = new JComboBox();
        this.cmbModelName.setEditable(true);
        this.cmbModelName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                OpenERPPanel.this.populateModelCombo();
            }
        });
        this.pwdPassword = new JPasswordField();
        this.pwdPassword.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OpenERPPanel.this.populateModelCombo();
            }
        });
        JLabel lblPort = new JLabel("Port:");
        lblPort.setHorizontalAlignment(4);
        JLabel lblHost = new JLabel("Host:");
        lblHost.setHorizontalAlignment(4);
        JLabel lblDatabase = new JLabel("Database:");
        lblDatabase.setHorizontalAlignment(4);
        JLabel lblUsername = new JLabel("Username:");
        lblUsername.setHorizontalAlignment(4);
        JLabel lblPassword = new JLabel("Password:");
        lblPassword.setHorizontalAlignment(4);
        JLabel lblModelName = new JLabel("Model Name:");
        lblModelName.setHorizontalAlignment(4);
        this.cmbDataSource = new JComboBox();
        this.cmbDataSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OpenERPPanel.this.dataSourceChanged();
            }
        });
        this.cmbDataSource.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard Search", "Custom Function"}));
        JLabel lblDataSource = new JLabel("Data Source:");
        lblDataSource.setHorizontalAlignment(4);
        JLabel lblCustomDataFunction = new JLabel("Custom Data Function:");
        lblCustomDataFunction.setHorizontalAlignment(4);
        this.txtCustomFunction = new JTextField();
        this.txtCustomFunction.setEditable(false);
        this.txtCustomFunction.setColumns(10);
        JButton btnTest = new JButton("Test");
        btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String modelName = OpenERPPanel.this.cmbModelName.getSelectedItem() == null ? "" : OpenERPPanel.this.cmbModelName.getSelectedItem().toString();
                    OpenERPPanel.this.helper.getObjectAdapter(OpenERPPanel.this.getConfiguration(false), modelName);
                    JOptionPane.showMessageDialog(null, "Connection was successful", "Success", 1);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
                }
            }
        });
        GroupLayout gl_pnlDataSource = new GroupLayout(pnlDataSource);
        gl_pnlDataSource.setHorizontalGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_pnlDataSource.createSequentialGroup().addGap(66).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblPort, -2, 114, -2).addComponent(lblHost, -2, 114, -2).addComponent(lblUsername, -2, 114, -2).addComponent(lblCustomDataFunction).addComponent(lblModelName, -2, 114, -2).addComponent(lblPassword, -2, 114, -2).addComponent(lblDatabase, -2, 114, -2).addComponent(lblDataSource)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(btnTest).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.cmbModelName, GroupLayout.Alignment.LEADING, 0, 224, Short.MAX_VALUE).addComponent(this.cmbDatabase, GroupLayout.Alignment.LEADING, 0, 224, Short.MAX_VALUE).addComponent(this.txtUsername).addComponent(this.cmbDataSource, 0, -1, Short.MAX_VALUE).addComponent(this.pwdPassword, 211, 211, Short.MAX_VALUE).addComponent(this.txtCustomFunction, -1, 211, Short.MAX_VALUE).addComponent(this.txtPort, -1, 224, Short.MAX_VALUE).addComponent(this.txtHost))).addContainerGap(193, Short.MAX_VALUE)));
        gl_pnlDataSource.setVerticalGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_pnlDataSource.createSequentialGroup().addGap(40).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblHost).addComponent(this.txtHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPort, -2, -1, -2).addComponent(lblPort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbDatabase, -2, -1, -2).addComponent(lblDatabase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtUsername, -2, -1, -2).addComponent(lblUsername)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pwdPassword, -2, -1, -2).addComponent(lblPassword)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbDataSource, -2, -1, -2).addComponent(lblDataSource)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbModelName, -2, -1, -2).addComponent(lblModelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlDataSource.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtCustomFunction, -2, -1, -2).addComponent(lblCustomDataFunction)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnTest).addContainerGap(171, Short.MAX_VALUE)));
        pnlDataSource.setLayout(gl_pnlDataSource);
        JPanel pnlSearchFields = new JPanel();
        this.tabbedPane.addTab("Search Fields", null, pnlSearchFields, null);
        pnlSearchFields.setLayout(new BorderLayout(0, 0));
        JSplitPane splSearchFields = new JSplitPane();
        pnlSearchFields.add(splSearchFields);
        splSearchFields.setDividerLocation(250);
        JPanel pnlAvailableFields = new JPanel();
        splSearchFields.setLeftComponent(pnlAvailableFields);
        pnlAvailableFields.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel_2.getLayout();
        flowLayout.setAlignment(0);
        pnlAvailableFields.add((Component)panel_2, "North");
        this.lblNewLabel = new JLabel("Available Fields");
        panel_2.add(this.lblNewLabel);
        this.scrollPane = new JScrollPane();
        pnlAvailableFields.add(this.scrollPane);
        this.availableTree = new JTree();
        this.availableTree.setModel(this.model);
        this.availableTree.setDragEnabled(true);
        this.availableTree.setTransferHandler(new TreeViewTransferHandler());
        this.scrollPane.setViewportView(this.availableTree);
        JPanel pnlSelectedFields = new JPanel();
        splSearchFields.setRightComponent(pnlSelectedFields);
        pnlSelectedFields.setLayout(new BorderLayout(0, 0));
        panel_2 = new JPanel();
        pnlSelectedFields.add((Component)panel_2, "North");
        panel_2.setLayout(new FlowLayout(0, 5, 5));
        JLabel lblNewLabel_1 = new JLabel("Selected Fields");
        panel_2.add(lblNewLabel_1);
        JScrollPane scrollPane_1 = new JScrollPane();
        pnlSelectedFields.add(scrollPane_1);
        this.selectedTable = new JTable();
        this.selectedTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    OpenERPPanel.this.tableModel.removeField(OpenERPPanel.this.selectedTable.getSelectedRows());
                }
            }
        });
        scrollPane_1.setViewportView(this.selectedTable);
        this.selectedTable.setShowVerticalLines(false);
        this.selectedTable.setFillsViewportHeight(true);
        this.selectedTable.setModel(this.tableModel);
        this.selectedTable.setDragEnabled(true);
        this.selectedTable.setTransferHandler(new TableTransferHandler());
        JPanel pnlFilter = new JPanel();
        this.tabbedPane.addTab("Filters", null, pnlFilter, null);
        pnlFilter.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        pnlFilter.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(350);
        JPanel pnlFilterModelsParent = new JPanel();
        splitPane.setLeftComponent(pnlFilterModelsParent);
        pnlFilterModelsParent.setLayout(new BorderLayout(0, 0));
        JScrollPane scrFilterModelsTable = new JScrollPane();
        pnlFilterModelsParent.add(scrFilterModelsTable);
        this.filterModelsTable = new JTable();
        this.filterModelsTable.setSelectionMode(0);
        this.filterModelsTable.setModel(this.filterModel);
        scrFilterModelsTable.setViewportView(this.filterModelsTable);
        JPanel pnlFilterDetailsTable = new JPanel();
        splitPane.setRightComponent(pnlFilterDetailsTable);
        pnlFilterDetailsTable.setLayout(new BorderLayout(0, 0));
        JScrollPane scrFilterDetailsTable = new JScrollPane();
        pnlFilterDetailsTable.add((Component)scrFilterDetailsTable, "Center");
        this.filterDetailsTable = new JTable();
        this.filterDetailsTable.setModel(this.filterDetailModel);
        scrFilterDetailsTable.setViewportView(this.filterDetailsTable);
        JPanel panel = new JPanel();
        FlowLayout flowLayout2 = (FlowLayout)panel.getLayout();
        flowLayout2.setAlignment(2);
        pnlFilterDetailsTable.add((Component)panel, "North");
        this.btnAdd = new JButton("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OpenERPPanel.this.addFilterRow();
            }
        });
        panel.add(this.btnAdd);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OpenERPPanel.this.removeCurrentFilter();
            }
        });
        panel.add(this.btnRemove);
        this.filterDetailsTable.getColumnModel().getColumn(0).setMaxWidth(25);
        this.filterDetailsTable.getColumnModel().getColumn(1).setMaxWidth(80);
        this.filterDetailsTable.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.filterDetailsTable.getColumnModel().getColumn(3).setMaxWidth(150);
        this.filterDetailsTable.getColumnModel().getColumn(3).setPreferredWidth(110);
        this.filterDetailsTable.getColumnModel().getColumn(4).setPreferredWidth(200);
        this.filterDetailsTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new JComboBox<String>(FilterHelper.getOperators())));
        this.fieldsCombo.setEditable(true);
        this.filterDetailsTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.fieldsCombo));
        this.filterDetailsTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(new JComboBox<String>(FilterHelper.getComparators())));
        this.filterModelsTable.getColumnModel().getColumn(0).setMaxWidth(25);
        this.filterModelsTable.getColumnModel().getColumn(2).setMaxWidth(75);
        this.filterModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                OpenERPPanel.this.filterModelChanged(arg0);
            }
        });
        this.selectedTable.getColumnModel().getColumn(0).setMaxWidth(25);
        this.selectedTable.getColumnModel().getColumn(1).setMaxWidth(75);
        this.selectedTable.getColumnModel().getColumn(2).setMaxWidth(200);
        this.selectedTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.selectedTable.getColumnModel().getColumn(3).setMaxWidth(200);
        this.selectedTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.selectedTable.getColumnModel().getColumn(4).setPreferredWidth(150);
        this.selectedTable.getColumnModel().getColumn(5).setMaxWidth(150);
        this.selectedTable.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.selectedTable.getColumnModel().getColumn(6).setMaxWidth(100);
        this.selectedTable.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(new JComboBox<String>(new String[]{"Ascending", "Descending"})));
        try {
            this.nodesFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + OpenERPChildTreeNode.class.getName() + "\"");
        }
        catch (ClassNotFoundException e) {
            this.nodesFlavor = null;
        }
    }

    public void setFilterAddButtonIcon(Icon defaultIcon) {
        this.btnAdd.setOpaque(false);
        this.btnAdd.setContentAreaFilled(false);
        this.btnAdd.setBorderPainted(false);
        this.btnAdd.setText(null);
        this.btnAdd.setIcon(defaultIcon);
    }

    public void setFilterRemoveButtonIcon(Icon defaultIcon) {
        this.btnRemove.setOpaque(false);
        this.btnRemove.setContentAreaFilled(false);
        this.btnRemove.setBorderPainted(false);
        this.btnRemove.setText(null);
        this.btnRemove.setIcon(defaultIcon);
    }

    private void removeCurrentFilter() {
        this.filterDetailModel.removeFilters(this.filterDetailsTable.getSelectedRows());
    }

    private void filterModelChanged(ListSelectionEvent arg0) {
        DefaultListSelectionModel selectionModel = (DefaultListSelectionModel)arg0.getSource();
        if (!selectionModel.getValueIsAdjusting()) {
            String modelPath = "";
            int instanceNum = -1;
            OpenERPQueryItem item = null;
            if (selectionModel.getMinSelectionIndex() >= 0) {
                item = this.filterModel.getQueryItem().get(selectionModel.getMinSelectionIndex());
                modelPath = item.getModelPath();
                instanceNum = item.getInstanceNum();
            }
            this.filterDetailModel.setCurrentView(modelPath, instanceNum);
            this.fieldsCombo.removeAllItems();
            try {
                ObjectAdapter adapter = this.helper.getObjectAdapter(this.getConfiguration(false), item.getModelName());
                List<String> sortedFieldNames = Arrays.asList(adapter.getFieldNames());
                Collections.sort(sortedFieldNames);
                this.fieldsCombo.addItem("id");
                for (String fldName : sortedFieldNames.toArray(new String[0])) {
                    this.fieldsCombo.addItem(fldName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addFilterRow() {
        this.filterDetailModel.addFilter("", "", "=", "");
    }

    private void loadAvailableFields() {
        try {
            OpenERPConfiguration currentConfig = this.getConfiguration(false);
            if (this.loadAvailableConfig != null && currentConfig.getHostName().equals(this.loadAvailableConfig.getHostName()) && currentConfig.getPortNumber() == this.loadAvailableConfig.getPortNumber() && currentConfig.getDatabaseName().equals(this.loadAvailableConfig.getDatabaseName()) && currentConfig.getModelName().equals(this.loadAvailableConfig.getModelName())) {
                return;
            }
            this.model = new DefaultTreeModel(new OpenERPRootTreeNode(this.helper.getSession(this.getConfiguration(false)), this.cmbModelName.getSelectedItem().toString()));
            this.availableTree.setModel(this.model);
            this.loadAvailableConfig = currentConfig;
        }
        catch (Exception e) {
            this.availableTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(e.getMessage())));
        }
    }

    private void loadFilterList() {
        if (this.cmbModelName.getSelectedItem() == null) {
            return;
        }
        OpenERPQueryItem rootItem = this.helper.buildQueryItems(this.cmbModelName.getSelectedItem().toString(), this.tableModel.getFieldPaths(), null);
        ArrayList<OpenERPQueryItem> allItems = rootItem.getAllChildItems();
        allItems.add(0, rootItem);
        this.filterModel.setQueryItems(allItems);
    }

    public void setConfiguration(OpenERPConfiguration config) {
        this.txtHost.setText(config.getHostName());
        this.txtPort.setText(Integer.toString(config.getPortNumber() == 0 ? 8069 : config.getPortNumber()));
        this.cmbDatabase.removeAllItems();
        this.populateDatabase();
        this.cmbDatabase.setSelectedItem(config.getDatabaseName());
        this.txtUsername.setText(config.getUserName());
        this.pwdPassword.setText(config.getPassword());
        this.cmbModelName.removeAllItems();
        this.populateModelCombo();
        if (config.getDataSource() == null) {
            this.cmbDataSource.setSelectedIndex(0);
        } else {
            this.cmbDataSource.setSelectedIndex(config.getDataSource() == OpenERPConfiguration.DataSource.STANDARD ? 0 : 1);
        }
        this.cmbModelName.setSelectedItem(config.getModelName());
        this.txtCustomFunction.setText(config.getCustomFunctionName());
        this.dataSourceChanged();
        this.tableModel.setFieldPaths(config.getSelectedFields());
        this.filterDetailModel.setFilterData(config.getFilters());
    }

    public OpenERPConfiguration getConfiguration(boolean removeRedundantFilters) {
        OpenERPQueryItem rootItem;
        OpenERPConfiguration config = new OpenERPConfiguration();
        config.setHostName(this.txtHost.getText());
        int port = 0;
        try {
            port = Integer.parseInt(this.txtPort.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        config.setPortNumber(port);
        config.setDatabaseName(this.cmbDatabase.getSelectedItem() == null ? "" : this.cmbDatabase.getSelectedItem().toString());
        config.setUserName(this.txtUsername.getText());
        config.setPassword(this.pwdPassword.getText());
        config.setDataSource(this.cmbDataSource.getSelectedIndex() == 1 ? OpenERPConfiguration.DataSource.CUSTOM : OpenERPConfiguration.DataSource.STANDARD);
        if (this.cmbModelName.getSelectedItem() != null) {
            config.setModelName(this.cmbModelName.getSelectedItem().toString());
        }
        config.setCustomFunctionName(this.txtCustomFunction.getText());
        config.setSelectedFields(this.tableModel.getFieldPaths());
        ArrayList<OpenERPFilterInfo> filters = this.filterDetailModel.getFilterData();
        if (removeRedundantFilters && (rootItem = this.helper.buildQueryItems(config.getModelName(), config.getSelectedFields(), this.filterDetailModel.getFilterData())) != null) {
            filters = new ArrayList();
            filters.addAll(rootItem.getFilters());
            for (OpenERPQueryItem queryItem : rootItem.getAllChildItems()) {
                filters.addAll(queryItem.getFilters());
            }
        }
        config.setFilters(filters);
        return config;
    }

    public OpenERPConfiguration getConfiguration() {
        return this.getConfiguration(true);
    }

    private void dataSourceChanged() {
        if (this.cmbDataSource.getSelectedIndex() == OpenERPConfiguration.DataSource.STANDARD.ordinal()) {
            this.txtCustomFunction.setEditable(false);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setEnabledAt(2, true);
        } else {
            this.txtCustomFunction.setEditable(true);
            this.tabbedPane.setEnabledAt(1, false);
            this.tabbedPane.setEnabledAt(2, false);
        }
    }

    private void populateDatabase() {
        if (this.cmbDatabase.getItemCount() > 0 || this.txtHost.getText().length() == 0 || this.txtPort.getText().length() == 0) {
            return;
        }
        try {
            int portNumber = Integer.parseInt(this.txtPort.getText());
            ArrayList dbList = OpenERPXmlRpcProxy.getDatabaseList((String)this.txtHost.getText(), (int)portNumber);
            dbList.add(0, "");
            Object selectedItem = this.cmbDatabase.getSelectedItem();
            this.cmbDatabase.setModel(new DefaultComboBoxModel<String>(dbList.toArray(new String[0])));
            this.cmbDatabase.setSelectedItem(selectedItem);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void populateModelCombo() {
        if (this.cmbModelName.getItemCount() > 0 || this.txtHost.getText().length() == 0 || this.txtPort.getText().length() == 0 || this.cmbDatabase.getSelectedItem() == null || this.txtUsername.getText().length() == 0 || this.pwdPassword.getText().length() == 0) {
            return;
        }
        try {
            ObjectAdapter modelAdapter = this.helper.getObjectAdapter(this.getConfiguration(false), "ir.model");
            RowCollection models = modelAdapter.searchAndReadObject(null, new String[]{"model"});
            String[] modelList = new String[models.size() + 1];
            modelList[0] = "";
            for (int i = 0; i < models.size(); ++i) {
                modelList[i + 1] = ((Row)models.get(i)).get("model").toString();
            }
            Object selectedItem = this.cmbModelName.getSelectedItem();
            this.cmbModelName.setModel(new DefaultComboBoxModel<String>(modelList));
            this.cmbModelName.setSelectedItem(selectedItem);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class DataTransfer
    implements Transferable {
        private final ArrayList<OpenERPFieldInfo> fieldPaths;

        public DataTransfer(ArrayList<OpenERPFieldInfo> fieldPaths) {
            this.fieldPaths = fieldPaths;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.fieldPaths;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{OpenERPPanel.this.nodesFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(OpenERPPanel.this.nodesFlavor);
        }
    }

    private class TableTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -5578590246826642097L;

        private TableTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            JTable table = (JTable)c;
            ArrayList<OpenERPFieldInfo> fieldPaths = new ArrayList<OpenERPFieldInfo>();
            for (int i : table.getSelectedRows()) {
                fieldPaths.add(OpenERPPanel.this.tableModel.getFieldPaths().get(i));
            }
            return new DataTransfer(fieldPaths);
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            int dropRow = ((JTable.DropLocation)support.getDropLocation()).getRow();
            try {
                ArrayList data = (ArrayList)support.getTransferable().getTransferData(OpenERPPanel.this.nodesFlavor);
                for (Object field : data) {
                    OpenERPFieldInfo targetField = ((OpenERPFieldInfo)field).clone();
                    if (support.getDropAction() == 2 || targetField.getParentField() == null) {
                        int originalIndex = OpenERPPanel.this.tableModel.getFieldPaths().indexOf(targetField);
                        if (originalIndex >= 0) {
                            OpenERPPanel.this.tableModel.getFieldPaths().remove(originalIndex);
                        }
                    } else {
                        while (OpenERPPanel.this.tableModel.getFieldPaths().indexOf(targetField) >= 0) {
                            targetField.incrementInstanceNum();
                        }
                        if (targetField.getInstanceNum() > 1) {
                            targetField.setRenamedFieldName(targetField.getFieldName() + "_" + targetField.getInstanceNum());
                        }
                    }
                    OpenERPPanel.this.tableModel.addField(dropRow, targetField);
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    private class TreeViewTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -5578590246826642097L;

        private TreeViewTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            JTree tree = (JTree)c;
            TreePath[] paths = tree.getSelectionPaths();
            ArrayList<OpenERPFieldInfo> fieldPaths = new ArrayList<OpenERPFieldInfo>();
            for (TreePath path : paths) {
                if (!(path.getLastPathComponent() instanceof OpenERPChildTreeNode)) continue;
                OpenERPChildTreeNode node = (OpenERPChildTreeNode)path.getLastPathComponent();
                fieldPaths.add(node.getFieldInfo());
            }
            return new DataTransfer(fieldPaths);
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            return true;
        }
    }
}

