/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.di;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.reporting.di.OpenERPFilterInfo;
import java.util.ArrayList;

public class OpenERPQueryItem {
    private final String relatedField;
    private final Field.FieldType relationType;
    private final String modelName;
    private final int instanceNum;
    private final ArrayList<String> fields = new ArrayList();
    private ArrayList<OpenERPFilterInfo> filters = new ArrayList();
    private final ArrayList<OpenERPQueryItem> childItems = new ArrayList();
    private OpenERPQueryItem parentQueryItem = null;

    public OpenERPQueryItem(String relatedField, Field.FieldType relationType, String modelName, int instanceNum) {
        this.relatedField = relatedField;
        this.relationType = relationType;
        this.modelName = modelName;
        this.instanceNum = instanceNum;
    }

    public void addField(String fieldName) {
        if (!this.fields.contains(fieldName)) {
            this.fields.add(fieldName);
        }
    }

    public void addChildQuery(OpenERPQueryItem item) {
        this.childItems.add(item);
        item.setParentQueryItem(this);
    }

    public String getRelatedField() {
        return this.relatedField;
    }

    public ArrayList<OpenERPFilterInfo> getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList<OpenERPFilterInfo> filters) {
        this.filters = filters;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Field.FieldType getRelationType() {
        return this.relationType;
    }

    public ArrayList<String> getFields() {
        return this.fields;
    }

    public int getInstanceNum() {
        return this.instanceNum;
    }

    public ArrayList<OpenERPQueryItem> getChildItems() {
        return this.childItems;
    }

    public OpenERPQueryItem getChildQuery(String relatedField, int instanceNum) {
        for (OpenERPQueryItem item : this.childItems) {
            if (!item.getRelatedField().equals(relatedField) || item.getInstanceNum() != instanceNum) continue;
            return item;
        }
        return null;
    }

    public ArrayList<OpenERPQueryItem> getAllChildItems() {
        ArrayList<OpenERPQueryItem> children = new ArrayList<OpenERPQueryItem>();
        children.addAll(this.childItems);
        for (OpenERPQueryItem item : this.childItems) {
            children.addAll(item.getAllChildItems());
        }
        return children;
    }

    private void setParentQueryItem(OpenERPQueryItem parentQueryItem) {
        this.parentQueryItem = parentQueryItem;
    }

    public String getModelPath() {
        if (this.parentQueryItem == null) {
            return "[" + this.modelName + "]";
        }
        return this.parentQueryItem.getModelPath() + ".[" + this.relatedField + "]";
    }
}

