/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.widgets.callEndpointTabs;

import java.util.ArrayList;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.baserver.utils.CallEndpointMeta;
import org.pentaho.di.baserver.utils.widgets.TableViewBuilder;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.Tab;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;

public class ParametersTab
extends Tab {
    private final TableView queryParameters;

    public ParametersTab(CTabFolder tabFolder, PropsUI props, TransMeta transMeta, CallEndpointMeta metaInfo, ModifyListener modifyListener, String stepName, LogChannel log) {
        super(tabFolder, BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Parameters.Title", (String[])new String[0]), props);
        ColumnInfo cFieldName = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Parameters.Field", (String[])new String[0]), 2, new String[]{""}, false);
        ColumnInfo cParameter = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Parameters.Parameter", (String[])new String[0]), 1, false);
        cParameter.setUsingVariables(true);
        ColumnInfo cDefaultValue = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Parameters.Default", (String[])new String[0]), 1, false);
        cDefaultValue.setUsingVariables(true);
        cDefaultValue.setToolTip(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Column.DefaultValue.Tooltip", (String[])new String[0]));
        this.queryParameters = (TableView)new TableViewBuilder(props, this, (VariableSpace)transMeta).addColumnInfo(cFieldName).addColumnInfo(cParameter).addColumnInfo(cDefaultValue).setRowsCount(metaInfo.getFieldName().length).setModifyListener(modifyListener).setLeftPlacement(0).setRightPlacement(100).setTopPlacement(0).setBottomPlacement(100).build();
        StepMeta stepMeta = transMeta.findStep(stepName);
        if (stepMeta != null) {
            try {
                RowMetaInterface row = transMeta.getPrevStepFields(stepMeta);
                ArrayList<String> entries = new ArrayList<String>();
                for (int i = 0; i < row.size(); ++i) {
                    entries.add(row.getValueMeta(i).getName());
                }
                String[] fieldNames = entries.toArray(new String[entries.size()]);
                Const.sortStrings((String[])fieldNames);
                cFieldName.setComboValues(fieldNames);
            }
            catch (KettleException e) {
                log.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
            }
        }
    }

    @Override
    public void loadData(CallEndpointMeta meta) {
        for (int i = 0; i < meta.getFieldName().length; ++i) {
            TableItem item = this.queryParameters.table.getItem(i);
            int index = 0;
            item.setText(++index, Const.NVL((String)meta.getFieldName()[i], (String)""));
            item.setText(++index, Const.NVL((String)meta.getParameter()[i], (String)""));
            item.setText(++index, Const.NVL((String)meta.getDefaultValue()[i], (String)""));
        }
        this.queryParameters.setRowNums();
        this.queryParameters.optWidth(true);
    }

    @Override
    public void saveData(CallEndpointMeta meta) {
        int count = this.queryParameters.nrNonEmpty();
        meta.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.queryParameters.getNonEmpty(i);
            int index = 0;
            meta.getFieldName()[i] = item.getText(++index);
            meta.getParameter()[i] = item.getText(++index);
            meta.getDefaultValue()[i] = item.getText(++index);
        }
    }
}

