/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.inspector;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.di.baserver.utils.inspector.Endpoint;
import org.pentaho.di.baserver.utils.inspector.ParamDefinition;
import org.pentaho.di.baserver.utils.web.Http;
import org.pentaho.di.baserver.utils.web.HttpParameter;

public class WadlParser {
    private static final String REPRESENTATION = "*[local-name() = 'representation' and @mediaType='application/x-www-form-urlencoded']";
    private static final String RESOURCES = "/application/child::*[local-name() = 'resources' ]";
    private static final String RESOURCE = "*[local-name() = 'resource']";
    private static final String REQUEST = "*[local-name() = 'request']";
    private static final String PARAM = "*[local-name() = 'param']";
    private static final String METHOD = "*[local-name() = 'method']";
    private static final String DOC = "*[local-name() = 'doc']";
    private static final String PATH = "@path";
    private static final String BASE = "@base";
    private static final String NAME = "@name";
    private static final String TYPE = "@type";
    private static final String ID = "@id";
    private static final Pattern SUPPORTED = Pattern.compile("<supported>(true||TRUE||True)<\\/supported>.*", 32);
    private static final Pattern DEPRECATED = Pattern.compile(".*<deprecated>(true||TRUE||True)<\\/deprecated>.*", 32);
    private static final Pattern DOCUMENTATION = Pattern.compile(".*<documentation>(.*)<\\/documentation>.*", 32);

    public Collection<Endpoint> getEndpoints(Document doc) {
        Node resources = doc.selectSingleNode(RESOURCES);
        if (resources != null) {
            return this.parseResources(resources, this.sanitizePath(resources.valueOf(BASE)));
        }
        return Collections.emptySet();
    }

    protected Collection<Endpoint> parseResources(Node resourceNode, String parentPath) {
        String path = resourceNode.valueOf(PATH);
        path = path.isEmpty() ? parentPath : parentPath + "/" + this.sanitizePath(path);
        TreeSet<Endpoint> endpoints = new TreeSet<Endpoint>();
        for (Object methodNode : resourceNode.selectNodes(METHOD)) {
            endpoints.add(this.parseMethod((Node)methodNode, path));
        }
        for (Object innerResourceNode : resourceNode.selectNodes(RESOURCE)) {
            endpoints.addAll(this.parseResources((Node)innerResourceNode, path));
        }
        return endpoints;
    }

    protected Endpoint parseMethod(Node methodNode, String path) {
        Node nodeDoc;
        Endpoint endpoint = new Endpoint();
        endpoint.setId(methodNode.valueOf(ID));
        endpoint.setHttpMethod(Http.valueOf(methodNode.valueOf(NAME)));
        endpoint.setPath(this.shortPath(path));
        Node requestNode = methodNode.selectSingleNode(REQUEST);
        if (requestNode != null) {
            for (Object queryParamNode : requestNode.selectNodes(PARAM)) {
                endpoint.getParamDefinitions().add(this.parseParam((Node)queryParamNode, HttpParameter.ParamType.QUERY));
            }
            Node representationNode = requestNode.selectSingleNode(REPRESENTATION);
            if (representationNode != null) {
                for (Object bodyParamNode : representationNode.selectNodes(PARAM)) {
                    endpoint.getParamDefinitions().add(this.parseParam((Node)bodyParamNode, HttpParameter.ParamType.BODY));
                }
            }
        }
        if ((nodeDoc = methodNode.selectSingleNode(DOC)) != null) {
            endpoint.setDeprecated(this.isDeprecated(nodeDoc.getText()));
            endpoint.setDocumentation(this.extractComment(nodeDoc.getText()));
            endpoint.setSupported(this.isSupported(nodeDoc.getText()));
        }
        return endpoint;
    }

    protected ParamDefinition parseParam(Node paramNode, HttpParameter.ParamType paramType) {
        return new ParamDefinition(paramNode.valueOf(NAME), paramNode.valueOf(TYPE), paramType);
    }

    protected String sanitizePath(String path) {
        path = path.startsWith("/") ? path.substring(1) : path;
        path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        return path;
    }

    protected String shortPath(String path) {
        return path.contains("/api/") ? path.substring(path.indexOf("/api/") + 4) : path;
    }

    protected boolean isSupported(String in) {
        Matcher matcher = SUPPORTED.matcher(in);
        return matcher.matches();
    }

    protected boolean isDeprecated(String in) {
        Matcher matcher = DEPRECATED.matcher(in);
        return matcher.matches();
    }

    protected String extractComment(String in) {
        Matcher matcher = DOCUMENTATION.matcher(in);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }
}

