/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import org.pentaho.di.baserver.utils.SessionHelper;
import org.pentaho.di.baserver.utils.SetSessionVariableData;
import org.pentaho.di.baserver.utils.SetSessionVariableMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class SetSessionVariableStep
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SetSessionVariableMeta.class;
    private SetSessionVariableMeta meta;
    private SetSessionVariableData data;

    public SetSessionVariableStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SetSessionVariableMeta)smi;
        this.data = (SetSessionVariableData)sdi;
        return super.init(smi, sdi);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SetSessionVariableMeta)smi;
        this.data = (SetSessionVariableData)sdi;
        Object[] rowData = this.getRow();
        if (this.first) {
            this.first = false;
            if (rowData != null) {
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                    this.setValue(this.meta.getVariableName()[i], this.getRowValue(rowData, i));
                }
                this.putRow(this.data.outputRowMeta, rowData);
                return true;
            }
            this.logBasic(BaseMessages.getString(PKG, (String)"SetSessionVariable.Log.NoInputRowUseDefaults", (String[])new String[0]));
            for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                this.setValue(this.meta.getVariableName()[i], this.getRowDefaultValue(i));
            }
            this.setOutputDone();
            return false;
        }
        if (rowData == null) {
            this.setOutputDone();
            return false;
        }
        throw new KettleStepException(BaseMessages.getString(PKG, (String)"SetSessionVariable.RuntimeError.MoreThanOneRowReceived", (String[])new String[0]));
    }

    protected void setValue(String varName, String value) throws KettleException {
        if (Const.isEmpty((String)varName)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SetSessionVariable.RuntimeError.EmptyVariableName", (String[])new String[]{value}));
        }
        if (this.getData().getBlackList().contains(varName)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SetSessionVariable.RuntimeError.VariableInBlacklist", (String[])new String[]{varName}));
        }
        String sessionVarName = this.environmentSubstitute(varName);
        try {
            this.setSessionVariable(value, sessionVarName);
        }
        catch (NoClassDefFoundError e) {
            sessionVarName = "_FAKE_SESSION_" + sessionVarName;
            this.setVariable(sessionVarName, value);
            Trans trans = this.getTrans();
            trans.setVariable(sessionVarName, value);
            while (trans.getParentTrans() != null) {
                trans = trans.getParentTrans();
                trans.setVariable(sessionVarName, value);
            }
        }
        this.logBasic(BaseMessages.getString(PKG, (String)"SetSessionVariable.Log.SetVariable", (String[])new String[]{sessionVarName, value}));
    }

    protected void setSessionVariable(String value, String sessionVarName) {
        SessionHelper.setSessionVariable(sessionVarName, value);
    }

    protected String getRowValue(Object[] rowData, int i) throws KettleException {
        String fieldName = this.getMeta().getFieldName()[i];
        int index = this.getData().outputRowMeta.indexOfValue(fieldName);
        if (index >= 0) {
            ValueMetaInterface valueMeta = this.getData().outputRowMeta.getValueMeta(index);
            Object valueData = rowData[index];
            return this.getMeta().isUsingFormatting() ? valueMeta.getString(valueData) : valueMeta.getCompatibleString(valueData);
        }
        this.logBasic(BaseMessages.getString(PKG, (String)"SetSessionVariable.Log.UnableToFindFieldUsingDefault", (String[])new String[]{fieldName, this.getRowDefaultValue(i)}));
        return this.getRowDefaultValue(i);
    }

    private String getRowDefaultValue(int i) {
        return this.environmentSubstitute(this.meta.getDefaultValue()[i]);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SetSessionVariableMeta)smi;
        this.data = (SetSessionVariableData)sdi;
        super.dispose(smi, sdi);
    }

    protected SetSessionVariableMeta getMeta() {
        return this.meta;
    }

    protected void setMeta(SetSessionVariableMeta meta) {
        this.meta = meta;
    }

    protected SetSessionVariableData getData() {
        return this.data;
    }

    protected void setData(SetSessionVariableData data) {
        this.data = data;
    }
}

