/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.PlanWalker;

public class DependencyOrderWalker
extends PlanWalker {
    public DependencyOrderWalker(OperatorPlan plan) {
        super(plan);
    }

    @Override
    public PlanWalker spawnChildWalker(OperatorPlan plan) {
        return new DependencyOrderWalker(plan);
    }

    @Override
    public void walk(PlanVisitor visitor) throws FrontendException {
        ArrayList<Operator> fifo = new ArrayList<Operator>();
        HashSet<Operator> seen = new HashSet<Operator>();
        List<Operator> leaves = this.plan.getSinks();
        if (leaves == null) {
            return;
        }
        for (Operator op : leaves) {
            this.doAllPredecessors(op, seen, fifo);
        }
        for (Operator op : fifo) {
            op.accept(visitor);
        }
    }

    protected void doAllPredecessors(Operator node, Set<Operator> seen, Collection<Operator> fifo) throws FrontendException {
        if (!seen.contains(node)) {
            Collection<Operator> preds = Utils.mergeCollection(this.plan.getPredecessors(node), this.plan.getSoftLinkPredecessors(node));
            if (preds != null && preds.size() > 0) {
                for (Operator op : preds) {
                    this.doAllPredecessors(op, seen, fifo);
                }
            }
            seen.add(node);
            fifo.add(node);
        }
    }
}

